/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.preferences.view.panel;

import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.common.CommPort;
import org.bidib.wizard.api.model.common.NetBidibServiceInfo;
import org.bidib.wizard.api.model.common.PreferencesPortType;
import org.bidib.wizard.client.common.preferences.view.panel.AbstractSettingsPanel;
import org.bidib.wizard.common.model.settings.ConnectionConfiguration;
import org.bidib.wizard.common.model.settings.GlobalSettingsInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.mvc.preferences.model.PreferencesModel;
import org.bidib.wizard.mvc.preferences.view.panel.ConnectionPanel;
import org.bidib.wizard.mvc.preferences.view.panel.MiscSettingsPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPanel
extends AbstractSettingsPanel<GlobalSettingsInterface> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "top:pref, 8dlu, top:pref, 8dlu, top:pref, 8dlu, top:pref, 8dlu, pref";
    private final PreferencesModel model;
    private final GlobalSettingsInterface globalSettings;
    private CommPortRadioPanel commPortRadioPanel;
    private SpeedometerPanel speedometerPanel;
    private NetBidibPanel netBidibPanel;
    private SerialOverTcpPortRadioPanel serialOverTcpPortRadioPanel;
    private JLabel labelSerial;
    private JLabel labelSerialOverTcp;
    private JLabel labelNetBidib;
    private JLabel labelSpeedometer;
    private JPanel contentPanel;
    private final WizardSettingsInterface wizardSettings;
    private BufferedValueModel selectedPortTypeModel;
    private BufferedValueModel previousSelectedNetBidibHostModel;
    private BufferedValueModel previousSelectedSpeedometerPortModel;
    private BufferedValueModel previousSelectedSerialOverTcpHostModel;
    private BufferedValueModel previousSelectedSerialSymLinkModel;
    private BufferedValueModel previousSelectedComPortModel;
    private BufferedValueModel previousSelectedSimulationFileNameModel;

    public ConnectionPanel(PreferencesModel model, GlobalSettingsInterface globalSettings, WizardSettingsInterface wizardSettings, Consumer<Boolean> bufferingCallback) {
        super(bufferingCallback);
        this.model = model;
        this.globalSettings = globalSettings;
        this.wizardSettings = wizardSettings;
    }

    public JPanel createPanel() {
        Object panel;
        this.labelSerial = new JLabel(Resources.getString(MiscSettingsPanel.class, (String)"serialPort") + ":");
        this.labelSerialOverTcp = new JLabel(Resources.getString(MiscSettingsPanel.class, (String)"serialOverTcpPort") + ":");
        this.labelNetBidib = new JLabel(Resources.getString(MiscSettingsPanel.class, (String)"netBidib") + ":");
        this.labelSpeedometer = new JLabel(Resources.getString(MiscSettingsPanel.class, (String)"speedometer") + ":");
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.preparePresentationModel((Object)this.globalSettings);
        dialogBuilder.add((Component)this.labelSerial).xy(1, 1);
        JComboBox commPortsCombo = new JComboBox();
        ButtonGroup group = new ButtonGroup();
        this.commPortRadioPanel = new CommPortRadioPanel(this, group, commPortsCombo);
        dialogBuilder.add((Component)this.commPortRadioPanel).xy(3, 1);
        dialogBuilder.add((Component)this.labelSerialOverTcp).xy(1, 3);
        this.serialOverTcpPortRadioPanel = new SerialOverTcpPortRadioPanel(this, group);
        dialogBuilder.add((Component)this.serialOverTcpPortRadioPanel).xy(3, 3);
        dialogBuilder.add((Component)this.labelNetBidib).xy(1, 5);
        JComboBox netBidibServiceInfoCombo = new JComboBox();
        this.netBidibPanel = new NetBidibPanel(this, group, netBidibServiceInfoCombo);
        dialogBuilder.add((Component)this.netBidibPanel).xy(3, 5);
        dialogBuilder.add((Component)this.labelSpeedometer).xy(1, 7);
        JComboBox commPortsSpeedometer = new JComboBox();
        this.speedometerPanel = new SpeedometerPanel(this, group, commPortsSpeedometer);
        dialogBuilder.add((Component)this.speedometerPanel).xy(3, 7);
        this.speedometerPanel.addPeer((PortRadioPanel)this.commPortRadioPanel);
        this.speedometerPanel.addPeer((PortRadioPanel)this.netBidibPanel);
        this.speedometerPanel.addPeer((PortRadioPanel)this.serialOverTcpPortRadioPanel);
        this.commPortRadioPanel.addPeer((PortRadioPanel)this.netBidibPanel);
        this.commPortRadioPanel.addPeer((PortRadioPanel)this.speedometerPanel);
        this.commPortRadioPanel.addPeer((PortRadioPanel)this.serialOverTcpPortRadioPanel);
        this.netBidibPanel.addPeer((PortRadioPanel)this.commPortRadioPanel);
        this.netBidibPanel.addPeer((PortRadioPanel)this.speedometerPanel);
        this.netBidibPanel.addPeer((PortRadioPanel)this.serialOverTcpPortRadioPanel);
        this.serialOverTcpPortRadioPanel.addPeer((PortRadioPanel)this.commPortRadioPanel);
        this.serialOverTcpPortRadioPanel.addPeer((PortRadioPanel)this.speedometerPanel);
        this.serialOverTcpPortRadioPanel.addPeer((PortRadioPanel)this.netBidibPanel);
        this.setCommPorts(commPortsCombo);
        this.setCommPortsSpeedometer(commPortsSpeedometer);
        this.setNetBidibServices(netBidibServiceInfoCombo);
        this.commPortRadioPanel.setEnabled(this.globalSettings.isSerialPortsEnabled());
        this.speedometerPanel.setEnabled(this.globalSettings.isSpeedometerEnabled());
        this.netBidibPanel.setEnabled(this.globalSettings.isNetBidibEnabled());
        this.serialOverTcpPortRadioPanel.setEnabled(this.globalSettings.isSerialOverTcpEnabled());
        this.commPortRadioPanel.setInitialValues(this.globalSettings);
        this.speedometerPanel.setInitialValues(this.globalSettings);
        this.netBidibPanel.setInitialValues(this.globalSettings);
        this.serialOverTcpPortRadioPanel.setInitialValues(this.globalSettings);
        this.selectedPortTypeModel = this.presentationModel.getBufferedModel("selectedPortType");
        this.previousSelectedNetBidibHostModel = this.presentationModel.getBufferedModel("previousSelectedNetBidibHost");
        this.previousSelectedSpeedometerPortModel = this.presentationModel.getBufferedModel("previousSelectedSpeedometerPort");
        this.previousSelectedSerialOverTcpHostModel = this.presentationModel.getBufferedModel("previousSelectedSerialOverTcpHost");
        this.previousSelectedSerialSymLinkModel = this.presentationModel.getBufferedModel("previousSelectedSerialSymLink");
        this.previousSelectedComPortModel = this.presentationModel.getBufferedModel("previousSelectedComPort");
        this.previousSelectedSimulationFileNameModel = this.presentationModel.getBufferedModel("previousSelectedSimulationFileName");
        if (this.selectedPortTypeModel.getValue() != null) {
            PreferencesPortType selectedPortType = (PreferencesPortType)this.selectedPortTypeModel.getValue();
            switch (1.$SwitchMap$org$bidib$wizard$api$model$common$PreferencesPortType$ConnectionPortType[selectedPortType.getConnectionPortType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    this.commPortRadioPanel.select(selectedPortType);
                    break;
                }
                case 4: {
                    this.netBidibPanel.select(selectedPortType);
                    break;
                }
                case 5: 
                case 6: {
                    this.serialOverTcpPortRadioPanel.select(selectedPortType);
                    break;
                }
                default: {
                    PreferencesPortType speedometerPortType = PreferencesPortType.getValue((String)(PreferencesPortType.ConnectionPortType.Speedometer.name() + ":" + this.globalSettings.getPreviousSelectedSpeedometerPort()));
                    this.speedometerPanel.select(speedometerPortType);
                }
            }
        }
        this.model.addPropertyChangeListener(event -> {
            switch (event.getPropertyName()) {
                case "detectedNetBidibServices": {
                    this.setNetBidibServices(netBidibServiceInfoCombo);
                    break;
                }
                case "commPorts": {
                    this.setCommPorts(commPortsCombo);
                    break;
                }
            }
        });
        this.contentPanel = dialogBuilder.build();
        this.contentPanel.setOpaque(false);
        return this.contentPanel;
    }

    private void fireSelectedPortTypeChanged(PreferencesPortType portType) {
        LOGGER.info("Selected port type has changed: {}", (Object)portType);
        if (this.selectedPortTypeModel != null) {
            this.selectedPortTypeModel.setValue((Object)portType);
        }
    }

    private void setCommPorts(JComboBox<CommPort> commPortsCombo) {
        LinkedHashSet<CommPort> commPorts = new LinkedHashSet<CommPort>();
        CommPort activeCommPort = null;
        String activeCommPortName = null;
        PreferencesPortType portType = ConnectionConfiguration.toPreferencesPortType((List)this.globalSettings.getConnectionConfigurations(), (String)"main");
        if (portType != null && PreferencesPortType.ConnectionPortType.SerialPort.equals((Object)portType.getConnectionPortType())) {
            activeCommPortName = this.extractPortName(portType.getConnectionName());
            if ("null".equals(activeCommPortName)) {
                activeCommPortName = null;
            }
            LOGGER.debug("The activeCommPortName: {}", (Object)activeCommPortName);
        } else if (StringUtils.isNotBlank((CharSequence)this.globalSettings.getPreviousSelectedComPort())) {
            activeCommPortName = this.extractPortName(this.globalSettings.getPreviousSelectedComPort());
            if ("null".equals(activeCommPortName)) {
                activeCommPortName = null;
            }
            LOGGER.debug("The activeCommPortName: {}", (Object)activeCommPortName);
        }
        for (CommPort commPort : this.model.getAvailableCommPorts()) {
            commPorts.add(commPort);
            if (SystemUtils.IS_OS_WINDOWS) {
                if (activeCommPortName == null || !activeCommPortName.startsWith(commPort.getName())) continue;
                activeCommPort = commPort;
                continue;
            }
            if (activeCommPortName == null || !activeCommPortName.equals(commPort.getName())) continue;
            activeCommPort = commPort;
        }
        LOGGER.debug("Add empty item if someone wants to release the port.");
        CommPort commPortNone = new CommPort("<none>");
        commPorts.add(commPortNone);
        commPortsCombo.setModel(new DefaultComboBoxModel<CommPort>(commPorts.toArray(new CommPort[0])));
        if (activeCommPort != null) {
            LOGGER.debug("Select the active commport: {}", (Object)activeCommPort);
            this.commPortRadioPanel.setSelectedPort(activeCommPort);
        } else if (StringUtils.isNotBlank((CharSequence)activeCommPortName) && !"<none>".equals(activeCommPortName)) {
            LOGGER.debug("Set the active symlink: {}", (Object)activeCommPortName);
            this.commPortRadioPanel.setSymlink(activeCommPortName);
        } else {
            LOGGER.debug("Select <none> item because no default active port is set.");
            this.commPortRadioPanel.setSelectedPort(commPortNone);
        }
    }

    private void setCommPortsSpeedometer(JComboBox<CommPort> commPortsCombo) {
        LinkedHashSet<CommPort> commPorts = new LinkedHashSet<CommPort>();
        CommPort activeCommPort = null;
        String activeCommPortName = null;
        PreferencesPortType portType = ConnectionConfiguration.toPreferencesPortType((List)this.globalSettings.getConnectionConfigurations(), (String)"main");
        if (portType != null && PreferencesPortType.ConnectionPortType.Speedometer.equals((Object)portType.getConnectionPortType())) {
            activeCommPortName = this.extractPortName(portType.getConnectionName());
            if ("null".equals(activeCommPortName)) {
                activeCommPortName = null;
            }
            LOGGER.debug("The activeCommPortName: {}", (Object)activeCommPortName);
        } else if (StringUtils.isNotBlank((CharSequence)this.globalSettings.getPreviousSelectedSpeedometerPort())) {
            activeCommPortName = this.extractPortName(this.globalSettings.getPreviousSelectedSpeedometerPort());
            if ("null".equals(activeCommPortName)) {
                activeCommPortName = null;
            }
            LOGGER.debug("The activeCommPortName: {}", (Object)activeCommPortName);
        }
        for (CommPort commPort : this.model.getAvailableCommPorts()) {
            commPorts.add(commPort);
            if (activeCommPortName == null || !activeCommPortName.equals(commPort.getName())) continue;
            activeCommPort = commPort;
        }
        LOGGER.debug("Add empty item if someone wants to release the port.");
        CommPort commPortNone = new CommPort("<none>");
        commPorts.add(commPortNone);
        commPortsCombo.setModel(new DefaultComboBoxModel<CommPort>(commPorts.toArray(new CommPort[0])));
        if (activeCommPort != null) {
            LOGGER.debug("Select the active commport: {}", (Object)activeCommPort);
            this.speedometerPanel.setSelectedPort(activeCommPort);
        } else {
            LOGGER.debug("Select <none> item because no default active port is set.");
            this.speedometerPanel.setSelectedPort(commPortNone);
        }
    }

    private void setNetBidibServices(JComboBox<NetBidibServiceInfo> netBidibServiceInfoCombo) {
        PreferencesPortType portType = ConnectionConfiguration.toPreferencesPortType((List)this.globalSettings.getConnectionConfigurations(), (String)"main");
        String activeNetBidibServiceName = null;
        if (portType != null && PreferencesPortType.ConnectionPortType.NetBidibClient.equals((Object)portType.getConnectionPortType())) {
            activeNetBidibServiceName = this.extractPortName(portType.getConnectionName());
            if ("null".equals(activeNetBidibServiceName)) {
                activeNetBidibServiceName = null;
            }
            LOGGER.debug("The activeNetBidibServiceName: {}", (Object)activeNetBidibServiceName);
        } else if (StringUtils.isNotBlank((CharSequence)this.globalSettings.getPreviousSelectedNetBidibHost())) {
            activeNetBidibServiceName = this.extractPortName(this.globalSettings.getPreviousSelectedNetBidibHost());
            if ("null".equals(activeNetBidibServiceName)) {
                activeNetBidibServiceName = null;
            }
            LOGGER.debug("The activeNetBidibServiceName: {}", (Object)activeNetBidibServiceName);
        }
        LinkedHashSet<NetBidibServiceInfo> netBidibServices = new LinkedHashSet<NetBidibServiceInfo>();
        Set detectedNetBidibServices = this.model.getDetectedNetBidibServices();
        LOGGER.info("Detected netBidib services: {}", (Object)detectedNetBidibServices);
        NetBidibServiceInfo activeServiceInfo = null;
        for (NetBidibServiceInfo si : detectedNetBidibServices) {
            netBidibServices.add(si);
            if (activeNetBidibServiceName == null || !activeNetBidibServiceName.equals(si.getQualifiedName())) continue;
            activeServiceInfo = si;
        }
        NetBidibServiceInfo serviceInfoNone = new NetBidibServiceInfo("<none>");
        netBidibServices.add(serviceInfoNone);
        netBidibServiceInfoCombo.setModel(new DefaultComboBoxModel<NetBidibServiceInfo>(netBidibServices.toArray(new NetBidibServiceInfo[0])));
        if (activeServiceInfo != null) {
            LOGGER.debug("Select the active service info: {}", (Object)activeServiceInfo);
            this.netBidibPanel.setSelectedService(activeServiceInfo);
        } else {
            LOGGER.debug("Select <none> item because no default active port is set.");
            this.netBidibPanel.setSelectedService(serviceInfoNone);
        }
    }

    private String extractPortName(String connectionUri) {
        return connectionUri;
    }
}

