/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.bidib.wizard.model.stepcontrol.TurnTableType;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlModel;

public class StepControlAspectCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private final ImageIcon okIcon;
    private final ImageIcon errorIcon;
    private final StepControlModel stepControlModel;

    public StepControlAspectCellRenderer(StepControlModel stepControlModel, ImageIcon okIcon, ImageIcon errorIcon) {
        this.stepControlModel = stepControlModel;
        this.okIcon = okIcon;
        this.errorIcon = errorIcon;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof StepControlAspect) {
            StepControlAspect stepControlAspect = (StepControlAspect)value;
            Long position = stepControlAspect.getPosition() != null ? Long.valueOf(stepControlAspect.getPosition() & 0xFFFFFFFFL) : null;
            Long positionOpposite = stepControlAspect.getOppositePosition() != null ? Long.valueOf(stepControlAspect.getOppositePosition() & 0xFFFFFFFFL) : null;
            String text = null;
            boolean isValid = stepControlAspect.isValid();
            if (TurnTableType.round == this.stepControlModel.getTurnTableType()) {
                text = position != null && positionOpposite != null ? String.format("%d - %d", position, positionOpposite) : (position != null ? String.format("%d - ?", position) : String.format("? - %d", positionOpposite));
                isValid = stepControlAspect.isValid() && stepControlAspect.isOppositeValid();
            } else if (position != null) {
                text = String.format("%d", position);
            }
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            label.setIcon(isValid ? this.okIcon : this.errorIcon);
            return label;
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

