/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view.wizard;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.mvc.common.view.wizard.JWizardComponents;
import org.bidib.wizard.mvc.stepcontrol.model.AccelarationScaleEnum;
import org.bidib.wizard.mvc.stepcontrol.model.ConfigurationWizardModel;
import org.bidib.wizard.mvc.stepcontrol.model.Gearing;
import org.bidib.wizard.mvc.stepcontrol.model.MicroStepsEnum;
import org.bidib.wizard.mvc.stepcontrol.model.MotorSizeType;
import org.bidib.wizard.mvc.stepcontrol.model.MovementScaleEnum;
import org.bidib.wizard.mvc.stepcontrol.view.SpeedRangeValidationUtils;
import org.bidib.wizard.mvc.stepcontrol.view.wizard.AbstractWizardPanel;
import org.bidib.wizard.mvc.stepcontrol.view.wizard.StepMotorCharacteristicsPanel;
import org.bidib.wizard.mvc.stepcontrol.view.wizard.WizardValidationResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepMotorCharacteristicsPanel
extends AbstractWizardPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(StepMotorCharacteristicsPanel.class);
    private ConfigurationWizardModel configurationWizardModel;
    private ValueModel selectionHolderMotorSize;
    private JComboBox<MotorSizeType> comboMotorSize;
    private ValueModel stepCountValueModel;
    private JTextField textStepCount;
    private InputValidationDocument stepCountDocument;
    private ValueModel gearingModel;
    private JLabel gearRatioLabel;
    private JTextField textGearRatioPrimary;
    private JTextField textGearRatioSecondary;
    private InputValidationDocument gearRatioDocument;
    private JTextField textBackLash;
    private JLabel backLashLabel;
    private ValueModel microSteppingModel;
    private JComboBox<MicroStepsEnum> comboMicroSteps;
    private ValueModel speedScaleModel;
    private ValueModel accelarationScaleModel;
    private ValueModel speedModel;
    private ValueModel accelModel;
    private ValueModel decelModel;
    private WizardValidationResultModel motorCharacteristicsValidationModel;

    public StepMotorCharacteristicsPanel(JWizardComponents wizardComponents, ConfigurationWizardModel configurationWizardModel) {
        super(wizardComponents);
        this.configurationWizardModel = configurationWizardModel;
    }

    protected void initPanel() {
        super.initPanel();
        this.motorCharacteristicsValidationModel = new WizardValidationResultModel();
        boolean debug = false;
        FormBuilder builder = FormBuilder.create().columns("p, 3dlu, p:g", new Object[0]).rows("p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p", new Object[0]).panel((JPanel)(debug ? new FormDebugPanel() : new JPanel()));
        builder.border((Border)Paddings.TABBED_DIALOG);
        builder.add(Resources.getString(this.getClass(), (String)"message"), new Object[0]).xyw(1, 1, 3);
        this.selectionHolderMotorSize = new PropertyAdapter((Object)this.configurationWizardModel, "motorSizeType", true);
        ArrayList<MotorSizeType> motorSizes = new ArrayList<MotorSizeType>();
        for (MotorSizeType motorSize : MotorSizeType.values()) {
            motorSizes.add(motorSize);
        }
        ComboBoxAdapter comboBoxAdapterMotorSize = new ComboBoxAdapter(motorSizes, this.selectionHolderMotorSize);
        this.comboMotorSize = new JComboBox();
        this.comboMotorSize.setModel(comboBoxAdapterMotorSize);
        builder.add(Resources.getString(this.getClass(), (String)"motorSize"), new Object[0]).xy(1, 3);
        builder.add((Component)this.comboMotorSize).xy(3, 3);
        ValidationComponentUtils.setMandatory((JComponent)this.comboMotorSize, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)this.comboMotorSize, (Object[])new Object[]{"validation.motorSize"});
        this.stepCountValueModel = new PropertyAdapter((Object)this.configurationWizardModel, "stepCount", true);
        ConverterValueModel stepCountConverterModel = new ConverterValueModel(this.stepCountValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.textStepCount = new JTextField();
        this.stepCountDocument = new InputValidationDocument(5, "0123456789");
        this.textStepCount.setDocument((Document)this.stepCountDocument);
        this.textStepCount.setColumns(5);
        Bindings.bind((JTextField)this.textStepCount, (ValueModel)stepCountConverterModel, (boolean)false);
        builder.add(Resources.getString(this.getClass(), (String)"stepCount"), new Object[0]).xy(1, 5);
        builder.add((Component)this.textStepCount).xy(3, 5);
        ValidationComponentUtils.setMandatory((JComponent)this.textStepCount, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)this.textStepCount, (Object[])new Object[]{"validation.stepCount"});
        FormBuilder gearingBuilder = FormBuilder.create().columns("pref, 3dlu, pref", new Object[0]).rows("p, 3dlu, p", new Object[0]);
        this.gearingModel = new PropertyAdapter((Object)this.configurationWizardModel, "gearing", true);
        int column = 1;
        for (int i = 0; i < 2; ++i) {
            Gearing gearing = null;
            switch (i) {
                case 0: {
                    gearing = new Gearing("no");
                    break;
                }
                default: {
                    gearing = (Gearing)this.gearingModel.getValue();
                    if (gearing != null && !"no".equals(gearing.getKey())) break;
                    gearing = new Gearing("yes");
                }
            }
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)this.gearingModel, (Object)gearing, (String)Resources.getString(Gearing.class, (String)gearing.getKey()));
            gearingBuilder.add((Component)radio).xy(column, 1);
            column += 2;
        }
        builder.add(Resources.getString(this.getClass(), (String)"gearing"), new Object[0]).xy(1, 7);
        builder.add((Component)gearingBuilder.build()).xy(3, 7);
        FormBuilder gearingAddedBuilder = FormBuilder.create().columns("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref", new Object[0]).rows("p, 3dlu, p", new Object[0]);
        PropertyAdapter gearRatioPrimaryValueModel = new PropertyAdapter(this.gearingModel, "gearRatioPrimary", true);
        ConverterValueModel gearRatioPrimaryConverterModel = new ConverterValueModel((ValueModel)gearRatioPrimaryValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.textGearRatioPrimary = new JTextField();
        InputValidationDocument gearRatioPrimaryDocument = new InputValidationDocument(3, "0123456789");
        this.textGearRatioPrimary.setDocument((Document)gearRatioPrimaryDocument);
        this.textGearRatioPrimary.setColumns(3);
        Bindings.bind((JTextField)this.textGearRatioPrimary, (ValueModel)gearRatioPrimaryConverterModel, (boolean)false);
        this.gearRatioLabel = new JLabel(Resources.getString(this.getClass(), (String)"gearRatio"));
        gearingAddedBuilder.add((Component)this.gearRatioLabel).xy(1, 1);
        gearingAddedBuilder.add((Component)this.textGearRatioPrimary).xy(3, 1);
        ValidationComponentUtils.setMandatory((JComponent)this.textGearRatioPrimary, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)this.textGearRatioPrimary, (Object[])new Object[]{"validation.gearRatioPrimary"});
        PropertyAdapter gearRatioSecondaryValueModel = new PropertyAdapter(this.gearingModel, "gearRatioSecondary", true);
        DecimalFormat decFormat = new DecimalFormat("#");
        ConverterValueModel gearRatioSecondaryConverterModel = new ConverterValueModel((ValueModel)gearRatioSecondaryValueModel, (BindingConverter)new StringConverter((Format)decFormat));
        this.textGearRatioSecondary = new JTextField();
        this.gearRatioDocument = new InputValidationDocument(5, "0123456789");
        this.textGearRatioSecondary.setDocument((Document)this.gearRatioDocument);
        this.textGearRatioSecondary.setColumns(5);
        Bindings.bind((JTextField)this.textGearRatioSecondary, (ValueModel)gearRatioSecondaryConverterModel, (boolean)false);
        gearingAddedBuilder.add(":", new Object[0]).xy(5, 1);
        gearingAddedBuilder.add((Component)this.textGearRatioSecondary).xy(7, 1);
        ValidationComponentUtils.setMandatory((JComponent)this.textGearRatioSecondary, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)this.textGearRatioSecondary, (Object[])new Object[]{"validation.gearRatioSecondary"});
        this.gearRatioLabel.setEnabled(false);
        this.textGearRatioPrimary.setEnabled(false);
        this.textGearRatioSecondary.setEnabled(false);
        PropertyAdapter backLashValueModel = new PropertyAdapter(this.gearingModel, "backLash", true);
        ConverterValueModel backLashConverterModel = new ConverterValueModel((ValueModel)backLashValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.textBackLash = new JTextField();
        InputValidationDocument backLashDocument = new InputValidationDocument(5, "0123456789");
        this.textBackLash.setDocument((Document)backLashDocument);
        this.textBackLash.setColumns(5);
        Bindings.bind((JTextField)this.textBackLash, (ValueModel)backLashConverterModel, (boolean)false);
        this.backLashLabel = new JLabel(Resources.getString(this.getClass(), (String)"backLash"));
        gearingAddedBuilder.add((Component)this.backLashLabel).xy(1, 3);
        gearingAddedBuilder.add((Component)this.textBackLash).xyw(3, 3, 3);
        ValidationComponentUtils.setMandatory((JComponent)this.textBackLash, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)this.textBackLash, (Object[])new Object[]{"validation.backLash"});
        this.textBackLash.setEnabled(false);
        this.backLashLabel.setEnabled(false);
        builder.add((Component)new JLabel()).xy(1, 9);
        builder.add((Component)gearingAddedBuilder.build()).xy(3, 9);
        this.microSteppingModel = new PropertyAdapter((Object)this.configurationWizardModel, "microStepping", true);
        this.comboMicroSteps = new JComboBox();
        ComboBoxAdapter comboAdapterMicroSteps = new ComboBoxAdapter((Object[])MicroStepsEnum.values(), this.microSteppingModel);
        this.comboMicroSteps.setModel(comboAdapterMicroSteps);
        this.comboMicroSteps.setRenderer(new MicroStepsCellRenderer(this));
        builder.add(Resources.getString(this.getClass(), (String)"microStepping"), new Object[0]).xy(1, 11);
        builder.add((Component)this.comboMicroSteps).xy(3, 11);
        ValidationComponentUtils.setMandatory((JComponent)this.comboMicroSteps, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)this.comboMicroSteps, (Object[])new Object[]{"validation.microStepping"});
        FormBuilder speedScaleBuilder = FormBuilder.create().columns("pref, 3dlu, pref", new Object[0]).rows("pref, 3dlu, pref", new Object[0]);
        this.speedScaleModel = new PropertyAdapter((Object)this.configurationWizardModel, "speedScale", true);
        column = 1;
        for (int i = 0; i < 2; ++i) {
            MovementScaleEnum speedScale = null;
            switch (i) {
                case 0: {
                    speedScale = MovementScaleEnum.scale0_1;
                    break;
                }
                default: {
                    speedScale = MovementScaleEnum.scale1;
                }
            }
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)this.speedScaleModel, (Object)speedScale, (String)Resources.getString(MovementScaleEnum.class, (String)speedScale.getKey()));
            speedScaleBuilder.add((Component)radio).xy(column, 1);
            column += 2;
            radio.setEnabled(false);
        }
        builder.add(Resources.getString(this.getClass(), (String)"speedScale"), new Object[0]).xy(1, 13);
        builder.add((Component)speedScaleBuilder.build()).xy(3, 13);
        FormBuilder accelarationScaleBuilder = FormBuilder.create().columns("pref, 3dlu, pref", new Object[0]).rows("pref, 3dlu, pref", new Object[0]);
        this.accelarationScaleModel = new PropertyAdapter((Object)this.configurationWizardModel, "accelerationScale", true);
        column = 1;
        for (int i = 0; i < 2; ++i) {
            AccelarationScaleEnum accelarationScale = null;
            switch (i) {
                case 0: {
                    accelarationScale = AccelarationScaleEnum.scale0_1;
                    break;
                }
                default: {
                    accelarationScale = AccelarationScaleEnum.scale1;
                }
            }
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)this.accelarationScaleModel, (Object)accelarationScale, (String)Resources.getString(AccelarationScaleEnum.class, (String)accelarationScale.getKey()));
            accelarationScaleBuilder.add((Component)radio).xy(column, 1);
            column += 2;
            radio.setEnabled(false);
        }
        builder.add(Resources.getString(this.getClass(), (String)"accelarationScale"), new Object[0]).xy(1, 15);
        builder.add((Component)accelarationScaleBuilder.build()).xy(3, 15);
        this.speedModel = new PropertyAdapter((Object)this.configurationWizardModel, "speed", true);
        ConverterValueModel speedConverterModel = new ConverterValueModel(this.speedModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField textSpeed = new JTextField();
        InputValidationDocument speedDocument = new InputValidationDocument(10, "0123456789");
        textSpeed.setDocument((Document)speedDocument);
        textSpeed.setColumns(8);
        Bindings.bind((JTextField)textSpeed, (ValueModel)speedConverterModel, (boolean)false);
        builder.add(Resources.getString(this.getClass(), (String)"speed"), new Object[0]).xy(1, 17);
        builder.add((Component)textSpeed).xy(3, 17);
        textSpeed.setEditable(false);
        ValidationComponentUtils.setMandatory((JComponent)textSpeed, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)textSpeed, (Object[])new Object[]{"validation.speed"});
        this.accelModel = new PropertyAdapter((Object)this.configurationWizardModel, "accel", true);
        ConverterValueModel accelConverterModel = new ConverterValueModel(this.accelModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField textAccel = new JTextField();
        InputValidationDocument accelDocument = new InputValidationDocument(10, "0123456789");
        textAccel.setDocument((Document)accelDocument);
        textAccel.setColumns(8);
        Bindings.bind((JTextField)textAccel, (ValueModel)accelConverterModel, (boolean)false);
        builder.add(Resources.getString(this.getClass(), (String)"accel"), new Object[0]).xy(1, 19);
        builder.add((Component)textAccel).xy(3, 19);
        textAccel.setEditable(false);
        ValidationComponentUtils.setMandatory((JComponent)textAccel, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)textAccel, (Object[])new Object[]{"validation.accel"});
        this.decelModel = new PropertyAdapter((Object)this.configurationWizardModel, "decel", true);
        ConverterValueModel decelConverterModel = new ConverterValueModel(this.decelModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField textDecel = new JTextField();
        InputValidationDocument decelDocument = new InputValidationDocument(10, "0123456789");
        textDecel.setDocument((Document)decelDocument);
        textDecel.setColumns(8);
        Bindings.bind((JTextField)textDecel, (ValueModel)decelConverterModel, (boolean)false);
        builder.add(Resources.getString(this.getClass(), (String)"decel"), new Object[0]).xy(1, 21);
        builder.add((Component)textDecel).xy(3, 21);
        textDecel.setEditable(false);
        ValidationComponentUtils.setMandatory((JComponent)textDecel, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)textDecel, (Object[])new Object[]{"validation.decel"});
        PropertyAdapter totalStepCountModel = new PropertyAdapter((Object)this.configurationWizardModel, "totalStepCount", true);
        ConverterValueModel totalStepCountConverterModel = new ConverterValueModel((ValueModel)totalStepCountModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField textTotalStepCount = new JTextField();
        InputValidationDocument totalStepCountDocument = new InputValidationDocument(10, "0123456789");
        textTotalStepCount.setDocument((Document)totalStepCountDocument);
        textTotalStepCount.setColumns(10);
        Bindings.bind((JTextField)textTotalStepCount, (ValueModel)totalStepCountConverterModel, (boolean)false);
        builder.add(Resources.getString(this.getClass(), (String)"totalStepCount"), new Object[0]).xy(1, 23);
        builder.add((Component)textTotalStepCount).xy(3, 23);
        textTotalStepCount.setEditable(false);
        if (this.getValidationResultModel() != null) {
            LOGGER.debug("Create iconfeedback panel.");
            IconFeedbackPanel cvIconPanel = new IconFeedbackPanel(this.getValidationResultModel(), (JComponent)builder.build());
            FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]);
            feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
            this.panel = feedbackBuilder.build();
        } else {
            this.panel = builder.build();
        }
        this.configurationWizardModel.addPropertyChangeListener("stepCount", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.configurationWizardModel.addPropertyChangeListener("microStepping", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.configurationWizardModel.addPropertyChangeListener("motorSizeType", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.configurationWizardModel.addPropertyChangeListener("gearing", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        5 gearingModelChangeListener = new /* Unavailable Anonymous Inner Class!! */;
        this.gearingModel.addValueChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.gearingModel.getValue() != null) {
            LOGGER.info("Add initial property change listener for gearing properties.");
            Gearing gearing = (Gearing)this.gearingModel.getValue();
            gearing.addPropertyChangeListener("gearRatioPrimary", (PropertyChangeListener)gearingModelChangeListener);
            gearing.addPropertyChangeListener("gearRatioSecondary", (PropertyChangeListener)gearingModelChangeListener);
            gearing.addPropertyChangeListener("backLash", (PropertyChangeListener)gearingModelChangeListener);
        }
        PropertyConnector.connect((Object)this.motorCharacteristicsValidationModel, (String)"validStateNoWarnOrErrors", (Object)this, (String)"stepValid");
        LOGGER.info("initPanel finished.");
    }

    protected ValidationResultModel getValidationResultModel() {
        return this.motorCharacteristicsValidationModel;
    }

    private ValidationResult validate() {
        Gearing gearing;
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.configurationWizardModel, "validation");
        if (this.comboMotorSize.getSelectedItem() == null) {
            support.addError("motorSize", "not_empty");
        }
        if (this.configurationWizardModel.getStepCount() == null || this.configurationWizardModel.getStepCount() < 1) {
            support.addError("stepCount", "invalid_value;min=4,max=16384");
        }
        if ((gearing = this.configurationWizardModel.getGearing()) != null && "yes".equals(gearing.getKey())) {
            if (gearing.getBackLash() == null || gearing.getBackLash() < 0) {
                support.addError("backLash", "invalid_value;min=0,max=1000");
            }
            if (gearing.getGearRatioPrimary() == null || gearing.getGearRatioPrimary() < 1 || gearing.getGearRatioPrimary() > 255) {
                support.addError("gearRatioPrimary", "invalid_value;min=1,max=255");
            }
            if (gearing.getGearRatioSecondary() == null || gearing.getGearRatioSecondary() < 1 || gearing.getGearRatioSecondary() > 20000) {
                support.addError("gearRatioSecondary", "invalid_value;min=1,max=20000");
            }
        }
        if (this.configurationWizardModel.getMicroStepping() == null) {
            support.addError("microStepping", "invalid_value;min=64,max=256");
        }
        if (this.configurationWizardModel.getMicroStepping() != null && this.configurationWizardModel.getStepCount() != null) {
            try {
                long maxSpeed = SpeedRangeValidationUtils.calculateValidMaxSpeed((int)this.configurationWizardModel.getMicroStepping().getSteps(), (int)this.configurationWizardModel.getStepCount(), (MovementScaleEnum)this.configurationWizardModel.getSpeedScale());
                LOGGER.info("The calculated maxSpeed: {}, selected speed: {}", (Object)maxSpeed, (Object)this.configurationWizardModel.getSpeed());
                if ((long)this.configurationWizardModel.getSpeed().intValue() > maxSpeed) {
                    support.addError("speed", "invalid_value");
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Validation of speed value failed", (Throwable)ex);
                support.addError("speed", "invalid_value");
            }
            try {
                long accelDecelLimit = 191500L;
                if (this.configurationWizardModel.getAccelerationScale() == AccelarationScaleEnum.scale0_1) {
                    accelDecelLimit = 19150L;
                }
                long accelarationFactor = SpeedRangeValidationUtils.calculateValidAccelarationFactor((int)this.configurationWizardModel.getMicroStepping().getSteps(), (int)this.configurationWizardModel.getStepCount());
                long minAccel = accelarationFactor * (long)this.configurationWizardModel.getAccel().intValue();
                LOGGER.info("The calculated minAccel: {}", (Object)minAccel);
                if (minAccel < accelDecelLimit) {
                    support.addError("accel", "invalid_value");
                }
                long minDecel = accelarationFactor * (long)this.configurationWizardModel.getDecel().intValue();
                LOGGER.info("The calculated minDecel: {}", (Object)minDecel);
                if (minDecel < accelDecelLimit) {
                    support.addError("decel", "invalid_value");
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Validation of speed value failed", (Throwable)ex);
                support.addError("speed", "invalid_value");
            }
        }
        ValidationResult validationResult = support.getResult();
        LOGGER.info("Prepared validationResult: {}", (Object)validationResult);
        return validationResult;
    }

    protected void triggerValidation() {
        ValidationResult validationResult = this.validate();
        this.motorCharacteristicsValidationModel.setResult(validationResult);
    }

    public void update() {
        LOGGER.info("update is called.");
        super.update();
        this.updateGearingComponents();
    }

    private void updateGearingComponents() {
        if (this.configurationWizardModel.getGearing() != null && "yes".equals(this.configurationWizardModel.getGearing().getKey())) {
            this.gearRatioLabel.setEnabled(true);
            this.textGearRatioPrimary.setEnabled(true);
            this.textGearRatioSecondary.setEnabled(true);
            this.textBackLash.setEnabled(true);
            this.backLashLabel.setEnabled(true);
        } else {
            this.gearRatioLabel.setEnabled(false);
            this.textGearRatioPrimary.setEnabled(false);
            this.textGearRatioSecondary.setEnabled(false);
            this.textBackLash.setEnabled(false);
            this.backLashLabel.setEnabled(false);
        }
        this.triggerValidation();
    }
}

