/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.worklist.controller;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.event.DefaultLabelsWorkListItemEvent;
import org.bidib.wizard.api.event.WorkListItemEvent;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.exception.UserActionAbortedException;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.common.event.WizardApplicationReadyEvent;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.mvc.main.controller.MainControllerInterface;
import org.bidib.wizard.mvc.worklist.controller.WorkListItemProvider;
import org.bidib.wizard.mvc.worklist.controller.actions.WorkListAction;
import org.bidib.wizard.mvc.worklist.controller.listener.WorkListControllerListener;
import org.bidib.wizard.mvc.worklist.model.WorkItemListModel;
import org.bidib.wizard.mvc.worklist.model.WorkItemModel;
import org.bidib.wizard.mvc.worklist.model.WorkItems;
import org.bidib.wizard.mvc.worklist.view.WorkListView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class WorkListController
implements WorkListControllerListener,
WorkListItemProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkListController.class);
    public static final String WORKLIST_FILENAME = "workList-bidib-wizard-2.0.json";
    private final DockingDesktop desktop;
    private DockableStateChangeListener dockableStateChangeListener;
    private final MainControllerInterface mainController;
    private final WorkItemListModel workListItemModel;
    private final WizardSettingsInterface wizardSettings;
    private final MiscSettingsInterface miscSettings;
    private final Map<String, Supplier<WorkListAction>> actionMap;
    private WorkListView workListView;
    private final ObjectMapper objectMapper;
    private static final String WORKING_DIR_WORKLIST_KEY = "workList";

    public WorkListController(DockingDesktop desktop, MainControllerInterface mainController, WorkItemListModel workListItemModel, WizardSettingsInterface wizardSettings, MiscSettingsInterface miscSettings, Map<String, Supplier<WorkListAction>> actionMap) {
        this.desktop = desktop;
        this.mainController = mainController;
        this.workListItemModel = workListItemModel;
        this.wizardSettings = wizardSettings;
        this.miscSettings = miscSettings;
        this.actionMap = actionMap;
        this.objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
        this.objectMapper.enable(DeserializationFeature.USE_LONG_FOR_INTS);
        this.workListView = new WorkListView(this.desktop, (WorkListControllerListener)this, this.workListItemModel);
    }

    public void start() {
        String searchKey = "workListPanel";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable view = this.desktop.getContext().getDockableByKey(searchKey);
        if (view != null) {
            LOGGER.info("Select the existing worklist view.");
            DockUtils.selectWindow((Dockable)view);
            return;
        }
        this.registerDockable();
    }

    @PreDestroy
    public void shutdown() {
        LOGGER.info("Save the worklist during shutdown.");
        this.saveWorkList();
    }

    public Dockable registerDockable() {
        LOGGER.info("Register the WorkListView in the desktop.");
        DockableState[] dockables = this.desktop.getDockables();
        LOGGER.info("Current dockables: {}", new Object[]{dockables});
        if (this.desktop.getDockables().length > 1) {
            DockableState nodeListPanel = null;
            for (DockableState dockable : dockables) {
                if (!DockKeys.DOCKKEY_DMX_SCENERY_VIEW.equals((Object)dockable.getDockable().getDockKey())) continue;
                LOGGER.info("Found the dmx scenery view dockable.");
                nodeListPanel = dockable;
                break;
            }
            if (nodeListPanel == null) {
                for (DockableState dockable : dockables) {
                    if (!DockKeys.DOCKKEY_NODE_LIST_PANEL.equals((Object)dockable.getDockable().getDockKey())) continue;
                    LOGGER.info("Found the nodeList panel dockable.");
                    nodeListPanel = dockable;
                    break;
                }
            }
            Dockable dock = this.desktop.getDockables()[1].getDockable();
            if (nodeListPanel != null) {
                LOGGER.info("Add the worklist view below the dmx scenery view or node list panel.");
                dock = nodeListPanel.getDockable();
                this.desktop.split(dock, (Dockable)this.workListView, DockingConstants.SPLIT_BOTTOM, 0.8);
            } else if (this.desktop.getDockables().length > 1) {
                this.desktop.split(dock, (Dockable)this.workListView, DockingConstants.SPLIT_BOTTOM);
                this.desktop.setDockableHeight((Dockable)this.workListView, 0.2);
            } else {
                this.desktop.split(dock, (Dockable)this.workListView, DockingConstants.SPLIT_RIGHT);
            }
        } else {
            this.desktop.addDockable((Dockable)this.workListView, RelativeDockablePosition.RIGHT);
        }
        this.dockableStateChangeListener = new /* Unavailable Anonymous Inner Class!! */;
        this.desktop.addDockableStateChangeListener(this.dockableStateChangeListener);
        return this.workListView;
    }

    @EventListener
    public void applicationStarted(WizardApplicationReadyEvent readyEvent) {
        LOGGER.info("Received application ready event: {}", (Object)readyEvent);
        SwingUtils.executeInEDT(() -> this.doLoadWorkListItems());
    }

    private void doLoadWorkListItems() {
        this.loadWorkList();
    }

    @EventListener
    public void addWorkListItem(WorkListItemEvent item) {
        LOGGER.info("Received worklist item event: {}", (Object)item);
        SwingUtils.executeInEDT(() -> this.doAddWorkListItem(item));
    }

    private void doAddWorkListItem(WorkListItemEvent item) {
        if (this.workListView != null) {
            LOGGER.info("Add the new worklist item.");
            boolean added = this.workListView.addWorkListItem(item);
            if (added) {
                LOGGER.info("New worklist item added. Show notification and save new data.");
                this.start();
                try {
                    this.workListView.getDockKey().setNotification(true);
                }
                catch (Exception ex) {
                    LOGGER.warn("Set notification on dockKey failed.", (Throwable)ex);
                }
                this.saveWorkList();
            } else {
                LOGGER.info("New worklist item was not added.");
            }
        } else {
            LOGGER.warn("No workListView available.");
        }
    }

    protected void loadWorkList() {
        String storedWorkingDirectory = this.getWorkingDirectory();
        try {
            this.workListItemModel.clear();
            Path path = Paths.get(storedWorkingDirectory, "worklist");
            File file = path.resolve(WORKLIST_FILENAME).toFile();
            WorkItems workListItemEvents = (WorkItems)this.objectMapper.readValue(file, WorkItems.class);
            ArrayList workListItemModel = new ArrayList();
            workListItemModel.addAll(workListItemEvents.workListItems);
            this.workListItemModel.addWorkListItems(workListItemModel);
        }
        catch (Exception ex) {
            LOGGER.warn("Load worklist failed.", (Throwable)ex);
        }
    }

    protected void saveWorkList() {
        try {
            String storedWorkingDirectory = this.getWorkingDirectory();
            ObjectWriter writer = this.objectMapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
            Path path = Paths.get(storedWorkingDirectory, "worklist");
            Files.createDirectories(path, new FileAttribute[0]);
            WorkItems workListItemEvents = new WorkItems();
            for (WorkItemModel model : this.workListItemModel.getWorkItems()) {
                workListItemEvents.add(model.getWorkListItemEvent());
            }
            writer.writeValue(path.resolve(WORKLIST_FILENAME).toFile(), (Object)workListItemEvents);
        }
        catch (Exception ex) {
            LOGGER.warn("Save worklist failed.", (Throwable)ex);
        }
    }

    private String getWorkingDirectory() {
        String storedWorkingDirectory = this.wizardSettings.getWorkingDirectory(WORKING_DIR_WORKLIST_KEY);
        if (StringUtils.isBlank((CharSequence)storedWorkingDirectory)) {
            storedWorkingDirectory = this.miscSettings.getBidibConfigDir();
        }
        return storedWorkingDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyAction(WorkItemModel selected) {
        String actionIdentifier = selected.getWorkListItemEvent().getAction();
        LOGGER.info("Apply action with actionIdentifier: {}, worklist item: {}", (Object)actionIdentifier, (Object)selected.getWorkListItemEvent());
        try {
            WorkListAction workListAction = (WorkListAction)((Supplier)this.actionMap.get(actionIdentifier)).get();
            workListAction.apply(this.desktop, selected.getWorkListItemEvent());
            if (WorkListItemEvent.Status.ignore != selected.getWorkListItemEvent().getStatus()) {
                this.workListItemModel.removeWorkListItem(selected);
            }
            this.saveWorkList();
        }
        catch (UserActionAbortedException ex) {
            LOGGER.warn("Apply action was aborted: {}", (Object)ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.warn("Apply action failed.", (Throwable)ex);
        }
        finally {
            if (this.workListView != null) {
                this.workListView.getDockKey().setNotification(false);
            } else {
                LOGGER.info("Now workListView opened.");
            }
        }
    }

    public WorkItemModel getDefaultLabelsWorkItemModel(String connectionId, NodeInterface node) {
        LOGGER.info("Get DefaultLabels work item model for connectionId: {}, node: {}", (Object)connectionId, (Object)node);
        long uniqueId = node.getUniqueId();
        WorkItemModel selected = null;
        for (WorkItemModel model : this.workListItemModel.getWorkItems()) {
            DefaultLabelsWorkListItemEvent event;
            if (!(model.getWorkListItemEvent() instanceof DefaultLabelsWorkListItemEvent) || !(event = (DefaultLabelsWorkListItemEvent)model.getWorkListItemEvent()).getConnectionId().equals(connectionId) || event.getUniqueId() == null || event.getUniqueId() != uniqueId) continue;
            selected = model;
            LOGGER.info("Found pending worklist item: {}", (Object)selected);
            break;
        }
        if (selected == null) {
            int relevantPidBits = node.getNode().getRelevantPidBits();
            DefaultLabelsWorkListItemEvent workListItemEvent = new DefaultLabelsWorkListItemEvent(ByteUtils.getUniqueIdAsString((long)uniqueId), WorkListItemEvent.Status.pending, connectionId, Long.valueOf(uniqueId), relevantPidBits);
            LOGGER.info("Created new workListItemEvent: {}", (Object)workListItemEvent);
            selected = new WorkItemModel((WorkListItemEvent)workListItemEvent);
        }
        return selected;
    }
}

