package org.bidib.wizard.config;

import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

import javax.swing.JFrame;

import org.bidib.wizard.api.LookupService;
import org.bidib.wizard.api.event.DefaultLabelsWorkListItemEvent;
import org.bidib.wizard.api.event.FirmwareUpdateWorkListItemEvent;
import org.bidib.wizard.api.event.WizardUpdateWorkListItemEvent;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeProvider;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.core.LocoService;
import org.bidib.wizard.api.service.node.BoosterService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.client.common.controller.CvDefinitionPanelControllerInterface;
import org.bidib.wizard.client.common.mvc.firmware.controller.FirmwareArchiveValidationController;
import org.bidib.wizard.client.common.mvc.firmware.controller.FirmwareController;
import org.bidib.wizard.client.common.preferences.view.panel.SettingsPanelInterface;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeModelRegistry;
import org.bidib.wizard.client.common.view.cvdef.DefaultCvDefinitionTreeModelRegistry;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.FirmwareRepoSettingsInterface;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.common.model.settings.TracerServiceSettingsInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.script.node.NodeScripting;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.core.model.connection.ConnectionRegistry;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.core.service.DebugConnectionService;
import org.bidib.wizard.core.service.firmware.FirmwareArchiveValidationService;
import org.bidib.wizard.core.service.node.DebugService;
import org.bidib.wizard.dcca.client.controller.DccAdvController;
import org.bidib.wizard.firmwarerepo.client.controller.FirmwareRepoController;
import org.bidib.wizard.firmwarerepo.core.FirmwareRepoService;
import org.bidib.wizard.firmwarerepo.core.NodeFirmwareRepoService;
import org.bidib.wizard.mvc.accessory.controller.AccessoryController;
import org.bidib.wizard.mvc.backup.controller.BackupController;
import org.bidib.wizard.mvc.booster.controller.BoosterTableController;
import org.bidib.wizard.mvc.common.DialogRegistry;
import org.bidib.wizard.mvc.comparison.controller.ComparisonController;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.bidib.wizard.mvc.console.controller.DefaultConsoleService;
import org.bidib.wizard.mvc.debug.controller.DebugInterfaceController;
import org.bidib.wizard.mvc.features.controller.FeaturesController;
import org.bidib.wizard.mvc.loco.controller.LocoController;
import org.bidib.wizard.mvc.locolist.controller.LocoTableController;
import org.bidib.wizard.mvc.logger.controller.LogPanelController;
import org.bidib.wizard.mvc.main.controller.AccessoryPanelController;
import org.bidib.wizard.mvc.main.controller.AlertController;
import org.bidib.wizard.mvc.main.controller.BacklightPortPanelController;
import org.bidib.wizard.mvc.main.controller.BoosterPanelController;
import org.bidib.wizard.mvc.main.controller.CvDefinitionPanelController;
import org.bidib.wizard.mvc.main.controller.DefaultMainMenuListener;
import org.bidib.wizard.mvc.main.controller.DefaultNodeScripting;
import org.bidib.wizard.mvc.main.controller.DefaultPairingController;
import org.bidib.wizard.mvc.main.controller.FeedbackPortPanelController;
import org.bidib.wizard.mvc.main.controller.FeedbackPositionPanelController;
import org.bidib.wizard.mvc.main.controller.FlagPanelController;
import org.bidib.wizard.mvc.main.controller.GlobalDetectorPanelController;
import org.bidib.wizard.mvc.main.controller.InputPortPanelController;
import org.bidib.wizard.mvc.main.controller.LightPortPanelController;
import org.bidib.wizard.mvc.main.controller.LocoPanelController;
import org.bidib.wizard.mvc.main.controller.MacroPanelController;
import org.bidib.wizard.mvc.main.controller.MainController;
import org.bidib.wizard.mvc.main.controller.MainControllerInterface;
import org.bidib.wizard.mvc.main.controller.MotorPortPanelController;
import org.bidib.wizard.mvc.main.controller.PairingController;
import org.bidib.wizard.mvc.main.controller.ReverserPanelController;
import org.bidib.wizard.mvc.main.controller.ServoPortPanelController;
import org.bidib.wizard.mvc.main.controller.SoundPortPanelController;
import org.bidib.wizard.mvc.main.controller.SwitchPairPortPanelController;
import org.bidib.wizard.mvc.main.controller.SwitchPortPanelController;
import org.bidib.wizard.mvc.main.controller.docking.DefaultDockableResolver;
import org.bidib.wizard.mvc.main.model.ConnectionPhaseModel;
import org.bidib.wizard.mvc.main.model.FeedbackPortModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.StatusModel;
import org.bidib.wizard.mvc.main.view.MainNodeListActionListener;
import org.bidib.wizard.mvc.main.view.MainView;
import org.bidib.wizard.mvc.main.view.menu.listener.MainMenuListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.statusbar.DefaultJideStatusBar;
import org.bidib.wizard.mvc.netdebug.controller.NetDebugController;
import org.bidib.wizard.mvc.nodedebug.controller.DebugConsoleController;
import org.bidib.wizard.mvc.nodedebug.model.DebugConsoleModel;
import org.bidib.wizard.mvc.ping.controller.PingTableController;
import org.bidib.wizard.mvc.pom.controller.PomProgrammerController;
import org.bidib.wizard.mvc.position.controller.FeedbackPositionController;
import org.bidib.wizard.mvc.preferences.controller.PreferencesController;
import org.bidib.wizard.mvc.pt.controller.PtProgrammerController;
import org.bidib.wizard.mvc.stepcontrol.controller.StepControlController;
import org.bidib.wizard.mvc.tips.controller.TipOfDayController;
import org.bidib.wizard.mvc.worklist.controller.WorkListController;
import org.bidib.wizard.mvc.worklist.controller.actions.ApplyDefaultLabelsAction;
import org.bidib.wizard.mvc.worklist.controller.actions.DownloadFirmwareAction;
import org.bidib.wizard.mvc.worklist.controller.actions.DownloadWizardAction;
import org.bidib.wizard.mvc.worklist.controller.actions.WorkListAction;
import org.bidib.wizard.mvc.worklist.model.WorkItemListModel;
import org.bidib.wizard.nodes.client.controller.NodesClientController;
import org.bidib.wizard.nodescript.client.controller.NodeScriptController;
import org.bidib.wizard.nodescript.script.node.NodeScriptingSupportProvider;
import org.bidib.wizard.script.client.controller.ScriptClientController;
import org.bidib.wizard.simulation.client.controller.SimulationController;
import org.bidib.wizard.tracer.client.controller.TracerClientController;
import org.bidib.wizard.tracer.service.BidibTracerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;

import com.vlsolutions.swing.docking.DockableResolver;
import com.vlsolutions.swing.docking.DockingContext;
import com.vlsolutions.swing.docking.DockingDesktop;

@Configuration
public class StandaloneConfig {

    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneConfig.class);

    @Bean
    @Lazy
    AlertController alertController() {
        return new AlertController(mainView());
    }

    @Bean
    @Lazy
    TipOfDayController tipOfDayController() {
        return new TipOfDayController(mainView());
    }

    @Bean
    @Lazy
    NodeScriptController nodeScriptController(
        final SettingsService settingsService, final SwitchingNodeService switchingNodeService,
        final NodeScripting nodeScripting, final MainControllerInterface mainController,
        final WizardLabelWrapper wizardLabelWrapper, final ConsoleService consoleService) {
        return new NodeScriptController(settingsService, switchingNodeService, nodeScripting, wizardLabelWrapper,
            consoleService);
    }

    @Bean
    DebugInterfaceControllerFactory debugInterfaceControllerFactory() {
        DebugInterfaceControllerFactory factory = new DebugInterfaceControllerFactory() {
            @Override
            public DebugInterfaceController createController(
                final DockingDesktop desktop, final SettingsService settingsService) {
                return debugInterfaceController(desktop, settingsService);
            }
        };
        return factory;
    }

    @Autowired
    private DebugConnectionService debugConnectionService;

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    DebugInterfaceController debugInterfaceController(
        final DockingDesktop desktop, final SettingsService settingsService) {

        DebugInterfaceController controller =
            new DebugInterfaceController(desktop, settingsService, this.debugConnectionService);
        return controller;
    }

    @Bean
    DebugConsoleControllerFactory debugConsoleControllerFactory() {
        DebugConsoleControllerFactory factory = new DebugConsoleControllerFactory() {
            @Override
            public DebugConsoleController createController() {
                LOGGER.info("Create the DebugConsoleController.");
                DebugConsoleController controller = debugConsoleController();
                return controller;
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    DebugConsoleController debugConsoleController() {
        DebugConsoleController debugConsoleController = new DebugConsoleController();

        return debugConsoleController;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    DebugConsoleModel debugConsoleModel() {
        DebugConsoleModel debugConsoleModel = new DebugConsoleModel();

        return debugConsoleModel;
    }

    @Bean
    NetDebugControllerFactory netDebugControllerFactory() {
        NetDebugControllerFactory factory = new NetDebugControllerFactory() {
            @Override
            public NetDebugController createController(final DockingDesktop desktop) {
                return netDebugController(desktop);
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    NetDebugController netDebugController(final DockingDesktop desktop) {

        NetDebugController controller = new NetDebugController(desktop);
        return controller;
    }

    @Bean
    @Lazy
    FirmwareRepoController firmwareRepoController(
        final DockingDesktop desktop, final FirmwareRepoSettingsInterface firmwareRepoSettings,
        final LookupService lookupService, final StatusBar statusBar,
        final NodeFirmwareRepoService firmwareRepoService) {

        final FirmwareRepoController controller =
            new FirmwareRepoController(desktop, firmwareRepoSettings, lookupService, statusBar, firmwareRepoService);
        return controller;
    }

    @Bean
    @Lazy
    FirmwareArchiveValidationController firmwareArchiveValidationController(
        final DockingDesktop desktop, final FirmwareArchiveValidationService firmwareArchiveValidationService,
        final SettingsService settingsService) {

        final FirmwareArchiveValidationController controller =
            new FirmwareArchiveValidationController(desktop, firmwareArchiveValidationService, settingsService);
        return controller;
    }

    @Bean
    @Lazy
    NodesClientController nodesClientController(
        final DockingDesktop desktop, final MainModel mainModel, final SettingsService settingsSevice,
        final NodeService nodeService, final WizardLabelWrapper wizardLabelWrapper) {

        String connectionId = ConnectionRegistry.CONNECTION_ID_MAIN;

        final NodesClientController controller =
            new NodesClientController(desktop, () -> mainModel.getNodeProvider(), () -> mainModel, settingsSevice,
                nodeService, connectionId, wizardLabelWrapper);
        return controller;
    }

    @Bean
    @Lazy
    ScriptClientController scriptClientController(
        final DockingDesktop desktop, final SettingsService settingsSevice, final NodeService nodeService,
        final SwitchingNodeService switchingNodeService, final BoosterService boosterService, final MainModel mainModel,
        final ConsoleService consoleService, final ConnectionService connectionService,
        final DebugConnectionService debugConnectionService, final DebugService debugService) {

        final ScriptClientController controller =
            new ScriptClientController(desktop, settingsSevice.getWizardSettings(), nodeService, switchingNodeService,
                boosterService, consoleService, connectionService, debugConnectionService, debugService,
                () -> mainModel.getNodeProvider());
        return controller;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    TracerClientController tracerClientController(
        final DockingDesktop desktop, final TracerServiceSettingsInterface tracerServiceSettings,
        final BidibTracerService bidibTracerService) {

        TracerClientController controller =
            new TracerClientController(desktop, tracerServiceSettings, bidibTracerService);
        return controller;
    }

    @Bean
    DccAdvControllerFactory dccAdvControllerFactory() {
        DccAdvControllerFactory factory = new DccAdvControllerFactory() {
            @Override
            public DccAdvController createController(final NodeInterface node, final DockingDesktop desktop) {
                return dccAdvController(node, desktop);
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    DccAdvController dccAdvController(final NodeInterface node, final DockingDesktop desktop) {

        DccAdvController controller = new DccAdvController(node, desktop);
        return controller;
    }

    @Bean
    SimulationControllerFactory simulationControllerFactory() {
        SimulationControllerFactory factory = new SimulationControllerFactory() {
            @Override
            public SimulationController createController(final DockingDesktop desktop) {
                SimulationController controller = simulationController(desktop);
                return controller;
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    SimulationController simulationController(final DockingDesktop desktop) {
        SimulationController simulationController = new SimulationController(desktop);
        return simulationController;
    }

    @Bean
    ComparisonControllerFactory comparisonControllerFactory() {
        ComparisonControllerFactory factory = new ComparisonControllerFactory() {
            @Override
            public ComparisonController createController(final DockingDesktop desktop) {
                ComparisonController controller = comparisonController(desktop);
                return controller;
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    ComparisonController comparisonController(final DockingDesktop desktop) {
        ComparisonController comparisonController = new ComparisonController(desktop);
        return comparisonController;
    }

    @Bean
    BackupControllerFactory backupControllerFactory() {
        BackupControllerFactory factory = new BackupControllerFactory() {
            @Override
            public BackupController createController(final DockingDesktop desktop, final MainModel mainModel) {
                BackupController controller = backupController(desktop, mainModel);
                return controller;
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    BackupController backupController(final DockingDesktop desktop, final MainModel mainModel) {
        BackupController backupController = new BackupController(desktop, () -> mainModel.getNodeProvider(), mainModel);

        return backupController;
    }

    @Bean
    CvDefinitionPanelControllerFactory cvDefinitionPanelControllerFactory() {
        CvDefinitionPanelControllerFactory factory = new CvDefinitionPanelControllerFactory() {
            @Override
            public CvDefinitionPanelController createController(MainModel mainModel) {
                return cvDefinitionPanelController(mainModel);
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    CvDefinitionPanelController cvDefinitionPanelController(final MainModel mainModel) {
        String connectionId = ConnectionRegistry.CONNECTION_ID_MAIN;

        CvDefinitionPanelController controller =
            new CvDefinitionPanelController(mainModel, feedbackPortModel(), connectionId, statusBar());
        return controller;
    }

    @Bean
    @Lazy
    NodeScriptingSupportProvider nodeScriptingSupportProvider() {
        return new NodeScriptingSupportProvider();
    }

    @Bean
    @Primary
    @Lazy
    NodeScripting nodeScripting(
        final MainModel mainModel, final MainControllerInterface mainController,
        CvDefinitionPanelControllerInterface cvDefinitionPanelController,
        final SwitchingNodeService switchingNodeService, final NodeService nodeService,
        final NodeScriptingSupportProvider nodeScriptingSupportProvider) {
        LOGGER.info("Create new NodeScripting.");
        NodeScripting nodeScripting =
            new DefaultNodeScripting(mainModel, mainController, cvDefinitionPanelController, switchingNodeService,
                nodeService, nodeScriptingSupportProvider);
        return nodeScripting;
    }

    @Bean
    @Lazy
    ReverserPanelControllerFactory reverserPanelControllerFactory() {
        ReverserPanelControllerFactory factory = new ReverserPanelControllerFactory() {
            @Override
            public ReverserPanelController createController(
                final MainModel mainModel, TabVisibilityListener tabVisibilityListener) {
                return reverserPanelController(mainModel, feedbackPortModel(), tabVisibilityListener);
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    ReverserPanelController reverserPanelController(
        final MainModel mainModel, final FeedbackPortModel feedbackPortModel,
        final TabVisibilityListener tabVisibilityListener) {

        ReverserPanelController controller =
            new ReverserPanelController(mainModel, feedbackPortModel, tabVisibilityListener);
        return controller;
    }

    @Bean
    LocoControllerFactory locoControllerFactory() {

        LocoControllerFactory locoControllerFactory = new LocoControllerFactory() {

            @Override
            public LocoController createLocoController(
                CommandStationNodeInterface node, JFrame parent, final NodeProvider nodeProvider,
                final DialogRegistry dialogRegistry) {
                return locoController(node, parent, nodeProvider, dialogRegistry);
            }
        };

        return locoControllerFactory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    LocoController locoController(
        CommandStationNodeInterface node, JFrame parent, final NodeProvider nodeProvider,
        final DialogRegistry dialogRegistry) {
        LocoController locoController = new LocoController(node, parent, nodeProvider, dialogRegistry);

        return locoController;
    }

    @Bean
    LocoTableControllerFactory locoTableControllerFactory() {

        LocoTableControllerFactory locoTableControllerFactory = new LocoTableControllerFactory() {

            @Override
            public LocoTableController createLocoTableController(
                final NodeInterface node, final DockingDesktop desktop, JFrame parent) {

                return locoTableController(node, desktop, parent);
            }
        };

        return locoTableControllerFactory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    LocoTableController locoTableController(NodeInterface node, final DockingDesktop desktop, JFrame parent) {
        LocoTableController locoTableController = new LocoTableController(node, desktop, parent, mainModel());

        return locoTableController;
    }

    @Bean
    FeaturesControllerFactory featuresControllerFactory() {

        FeaturesControllerFactory featuresControllerFactory = new FeaturesControllerFactory() {

            @Override
            public FeaturesController createFeaturesController(
                final NodeInterface node, final JFrame parent, final WizardSettingsInterface wizardSettings) {
                return featuresController(node, parent, wizardSettings);
            }
        };

        return featuresControllerFactory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    FeaturesController featuresController(
        final NodeInterface node, final JFrame parent, final WizardSettingsInterface wizardSettings) {
        final FeaturesController featuresController = new FeaturesController(parent, node, wizardSettings);
        return featuresController;
    }

    @Bean
    FirmwareControllerFactory firmwareControllerFactory() {

        FirmwareControllerFactory firmwareControllerFactory = new FirmwareControllerFactory() {

            @Override
            public FirmwareController createFirmwareController(
                final FirmwareRepoService firmwareRepoService, final NodeInterface node, JFrame parent) {
                return firmwareController(firmwareRepoService, node, parent);
            }
        };

        return firmwareControllerFactory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    FirmwareController firmwareController(
        final FirmwareRepoService firmwareRepoService, final NodeInterface node, JFrame parent) {
        FirmwareController firmwareController = new FirmwareController(firmwareRepoService, node, mainModel(), parent);

        return firmwareController;
    }

    @Bean
    PtProgrammerControllerFactory ptProgrammerControllerFactory() {

        PtProgrammerControllerFactory ptProgrammerControllerFactory = new PtProgrammerControllerFactory() {

            @Override
            public PtProgrammerController createPtProgrammerController(
                NodeInterface node, JFrame parent, Point location) {
                return ptProgrammerController(node, parent, location);
            }
        };

        return ptProgrammerControllerFactory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    PtProgrammerController ptProgrammerController(NodeInterface node, JFrame parent, Point location) {
        PtProgrammerController ptProgrammerController =
            new PtProgrammerController(node, parent, location.x, location.y);

        return ptProgrammerController;
    }

    @Bean
    PomProgrammerControllerFactory pomProgrammerControllerFactory() {

        PomProgrammerControllerFactory pomProgrammerControllerFactory = new PomProgrammerControllerFactory() {

            @Override
            public PomProgrammerController createPomProgrammerController(
                final CommandStationNodeInterface node, final DialogRegistry dialogRegistry, JFrame parent,
                Point location) {
                return pomProgrammerController(node, dialogRegistry, parent, location);
            }
        };

        return pomProgrammerControllerFactory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    PomProgrammerController pomProgrammerController(
        final CommandStationNodeInterface node, final DialogRegistry dialogRegistry, JFrame parent, Point location) {
        PomProgrammerController pomProgrammerController =
            new PomProgrammerController(node, dialogRegistry, parent, location.x, location.y);

        return pomProgrammerController;
    }

    @Bean
    AccessoryControllerFactory accessoryControllerFactory() {

        AccessoryControllerFactory accessoryControllerFactory = new AccessoryControllerFactory() {

            @Override
            public AccessoryController createAccessoryController(NodeInterface node, JFrame parent, Point location) {
                return accessoryController(node, parent, location);
            }
        };

        return accessoryControllerFactory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    AccessoryController accessoryController(NodeInterface node, JFrame parent, Point location) {
        AccessoryController accessoryController = new AccessoryController(node, parent, location.x, location.y);

        return accessoryController;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    PingTableController pingTableController(
        final MainControllerInterface mainController, final ApplicationEventPublisher applicationEventPublisher,
        final DockingDesktop desktop) {
        final PingTableController pingTableController =
            new PingTableController(mainController, applicationEventPublisher, desktop);

        return pingTableController;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    PreferencesController preferencesController(final List<SettingsPanelInterface> settingsPanelInterfaces) {

        JFrame parent = mainView().getFrame();
        PreferencesController preferencesController = new PreferencesController(parent, settingsPanelInterfaces);
        return preferencesController;
    }

    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    MainModel mainModel() {
        String connectionId = ConnectionRegistry.CONNECTION_ID_MAIN;
        return new MainModel(statusModel(), connectionId, applicationContext);
    }

    // TODO the status model should be attached to the connection ...
    @Bean
    StatusModel statusModel() {
        return new StatusModel();
    }

    @Bean
    @Lazy
    DefaultJideStatusBar statusBar() {
        return new DefaultJideStatusBar(statusModel());
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    MainController mainController() {
        String connectionId = ConnectionRegistry.CONNECTION_ID_MAIN;
        return new MainController(mainModel(), connectionPhaseModel(), connectionId);
    }

    @Bean
    PairingControllerFactory pairingControllerFactory() {

        final PairingControllerFactory pairingControllerFactory = new PairingControllerFactory() {

            @Override
            public PairingController create(final StatusBar statusBar, final ConnectionService connectionService) {
                final MainModel mainModel = mainModel();
                final Supplier<JFrame> parent = () -> mainView().getFrame();
                return new DefaultPairingController(parent, statusBar, connectionService,
                    () -> mainModel.getConnectionId());
            }

        };

        return pairingControllerFactory;
    }

    @Bean
    MainViewFactory mainViewFactory() {

        final MainViewFactory mainViewFactory = new MainViewFactory() {

            @Override
            public MainView create(final SettingsService settingsService) {
                final MainView mainView = mainView();

                final MainMenuListener mainMenuListener =
                    mainMenuListener(dockingDesktop(), settingsService, StandaloneConfig.this.applicationContext);
                mainView.setMainMenuListener(mainMenuListener);
                return mainView;
            }

        };
        return mainViewFactory;
    }

    @Bean
    @Lazy
    MainView mainView() {
        return new MainView(mainModel(), connectionPhaseModel(), nodeScriptingSupportProvider(),
            workListControllerFactory());
    }

    @Bean
    @Lazy
    MainNodeListActionListener mainNodeListActionListener(final MainView mainView, final LookupService lookupService) {
        return new MainNodeListActionListener(mainView, mainModel(), statusBar(), lookupService);
    }

    @Bean
    @Lazy
    DefaultMainMenuListener mainMenuListener(
        final DockingDesktop dockingDesktop, final SettingsService settingsService,
        final ApplicationContext applicationContext) {

        return new DefaultMainMenuListener(mainView(), dockingDesktop, mainModel(), settingsService,
            applicationContext);
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    DockingContext dockingContext() {
        final DockingContext dockingContext = new DockingContext();

        // set the dockable resolver
        // this will allow to load the dockables dynamically
        dockingContext.setDockableResolver(dockableResolver());

        return dockingContext;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    DockingDesktop dockingDesktop() {
        LOGGER.info("Create the dockingDesktop.");
        final DockingDesktop dockingDesktop = new DockingDesktop();

        dockingDesktop.setContext(dockingContext());
        // add the desktop to the context
        dockingContext().addDesktop(dockingDesktop);

        return dockingDesktop;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    DockableResolver dockableResolver() {
        return new DefaultDockableResolver();
    }

    @Bean
    @Lazy
    ConsoleControllerFactory consoleControllerFactory() {
        ConsoleControllerFactory factory = new ConsoleControllerFactory() {
            @Override
            public ConsoleController createController(
                final DockingDesktop desktop, final ConsoleService consoleService) {
                return consoleController(desktop, consoleService);
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    ConsoleController consoleController(final DockingDesktop desktop, final ConsoleService consoleService) {
        LOGGER.info("Create the ConsoleController instance.");
        ConsoleController controller = new ConsoleController(desktop, mainModel(), consoleService);
        return controller;
    }

    @Bean
    ConsoleService consoleService() {
        return new DefaultConsoleService();
    }

    @Bean
    @Lazy
    WorkItemListModel workListItemModel() {
        return new WorkItemListModel();
    }

    @Bean
    @Lazy
    ConnectionPhaseModel connectionPhaseModel() {
        return new ConnectionPhaseModel();
    }

    @Bean
    @Lazy
    AccessoryPanelController accessoryPanelController() {
        return new AccessoryPanelController(mainModel());
    }

    @Bean
    @Lazy
    BoosterPanelController boosterPanelController() {
        return new BoosterPanelController(mainModel());
    }

    @Bean
    @Lazy
    WorkListControllerFactory workListControllerFactory() {

        final WorkListControllerFactory workListControllerFactory = new WorkListControllerFactory() {

            @Override
            public WorkListController createWorkListController(
                final DockingDesktop desktop, final WizardSettingsInterface wizardSettings,
                final MiscSettingsInterface miscSettings, final ApplicationContext applicationContext) {
                return workListController(desktop, wizardSettings, miscSettings, applicationContext);
            }
        };
        return workListControllerFactory;
    }

    @Bean
    @Lazy
    // @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    WorkListController workListController(
        final DockingDesktop desktop, final WizardSettingsInterface wizardSettings,
        final MiscSettingsInterface miscSettings, final ApplicationContext applicationContext) {
        LOGGER.info("Create the WorkListController instance.");

        final Map<String, Supplier<WorkListAction>> actionMap = new HashMap<>();
        actionMap
            .put(DefaultLabelsWorkListItemEvent.ACTION_IDENTIFIER,
                () -> applicationContext.getBean(ApplyDefaultLabelsAction.class));
        actionMap
            .put(FirmwareUpdateWorkListItemEvent.ACTION_IDENTIFIER,
                () -> applicationContext.getBean(DownloadFirmwareAction.class));
        actionMap
            .put(WizardUpdateWorkListItemEvent.ACTION_IDENTIFIER,
                () -> applicationContext.getBean(DownloadWizardAction.class));

        return new WorkListController(desktop, mainController(), workListItemModel(), wizardSettings, miscSettings,
            actionMap);
    }

    @Bean
    @Lazy
    ApplyDefaultLabelsAction applyDefaultLabelsAction(
        final ConnectionService connectionService, final WizardLabelWrapper wizardLabelWrapper,
        final ApplicationEventPublisher applicationEventPublisher, final ConsoleService consoleService) {
        final ApplyDefaultLabelsAction action =
            new ApplyDefaultLabelsAction(connectionService, wizardLabelWrapper, applicationEventPublisher,
                consoleService);
        return action;
    }

    @Bean
    @Lazy
    DownloadFirmwareAction downloadFirmwareAction(
        final ApplicationContext applicationContext, final StatusBar statusBar) {
        return new DownloadFirmwareAction(applicationContext, statusBar);
    }

    @Bean
    @Lazy
    DownloadWizardAction downloadWizardAction() {
        return new DownloadWizardAction();
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    BoosterTableController boosterTableController(final DockingDesktop desktop, final MainModel mainModel) {
        LOGGER.info("Create the BoosterTableController instance.");
        return new BoosterTableController(desktop, () -> mainModel.getNodeProvider(), mainModel);
    }

    @Bean
    @Lazy
    BacklightPortPanelController backlightPortPanelController() {
        return new BacklightPortPanelController(mainModel());
    }

    @Bean
    @Lazy
    FeedbackPortModel feedbackPortModel() {
        return new FeedbackPortModel();
    }

    @Bean
    @Lazy
    FeedbackPortPanelController feedbackPortPanelController(final DockingDesktop desktop) {
        return new FeedbackPortPanelController(mainModel(), feedbackPortModel(), desktop);
    }

    @Lazy
    @Bean
    FeedbackPositionPanelController feedbackPositionPanelController(final WizardSettingsInterface wizardSettings) {
        return new FeedbackPositionPanelController(mainModel(), wizardSettings);
    }

    @Bean
    @Lazy
    FeedbackPositionControllerFactory feedbackPositionControllerFactory() {
        FeedbackPositionControllerFactory factory = new FeedbackPositionControllerFactory() {
            @Override
            public FeedbackPositionController createController(
                final DockingDesktop desktop, final MainModel mainModel) {
                return feedbackPositionController(desktop, mainModel);
            }
        };
        return factory;
    }

    @Bean
    @Lazy
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    FeedbackPositionController feedbackPositionController(final DockingDesktop desktop, final MainModel mainModel) {
        LOGGER.info("Create the feedbackPositionController instance.");
        FeedbackPositionController controller =
            new FeedbackPositionController(desktop, () -> mainModel.getNodeProvider(), mainController());
        return controller;
    }

    @Bean
    @Lazy
    GlobalDetectorPanelController GlobalDetectorPanelController(
        final MainModel mainModel, final CommandStationService commandStationService, final LocoService locoService) {
        return new GlobalDetectorPanelController(mainModel, commandStationService, locoService);
    }

    @Bean
    @Lazy
    FlagPanelController flagPanelController() {
        return new FlagPanelController(mainModel());
    }

    @Bean
    @Lazy
    InputPortPanelController inputPortPanelController() {
        return new InputPortPanelController(mainModel());
    }

    @Bean
    @Lazy
    LightPortPanelController lightPortPanelController(final ApplicationEventPublisher applicationEventPublisher) {
        return new LightPortPanelController(mainModel(), applicationEventPublisher, statusBar());
    }

    @Bean
    @Lazy
    LocoPanelController locoPanelController() {
        return new LocoPanelController(mainModel());
    }

    @Bean
    @Lazy
    MacroPanelController macroPanelController() {
        return new MacroPanelController(mainModel(), statusBar());
    }

    @Bean
    @Lazy
    MotorPortPanelController motorPortPanelController() {
        return new MotorPortPanelController(mainModel());
    }

    @Bean
    @Lazy
    ServoPortPanelController servoPortPanelController() {
        return new ServoPortPanelController(mainModel());
    }

    @Bean
    @Lazy
    SoundPortPanelController soundPortPanelController() {
        return new SoundPortPanelController(mainModel());
    }

    @Bean
    @Lazy
    StepControlController stepControlController() {
        return new StepControlController(mainModel(), feedbackPortModel(), statusBar());
    }

    @Bean
    @Lazy
    SwitchPortPanelController switchPortPanelController() {
        return new SwitchPortPanelController(mainModel());
    }

    @Bean
    @Lazy
    SwitchPairPortPanelController switchPairPortPanelController() {
        return new SwitchPairPortPanelController(mainModel());
    }

    @Bean
    @Lazy
    CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry() {
        return new DefaultCvDefinitionTreeModelRegistry();
    }

    @Bean
    @Lazy
    LogPanelController logPanelController(final DockingDesktop desktop) {
        return new LogPanelController(desktop);
    }

    @Bean
    @Lazy
    DialogRegistry dialogRegistry() {
        return new DialogRegistry();
    }
}
