/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.debug.controller;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.status.Status;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.model.common.CommPort;
import org.bidib.wizard.api.model.common.PreferencesPortType;
import org.bidib.wizard.api.model.debug.DebugConnection;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.common.model.settings.DebugConnectionConfiguration;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.core.service.DebugConnectionService;
import org.bidib.wizard.mvc.debug.controller.listener.DebugInterfaceControllerListener;
import org.bidib.wizard.mvc.debug.model.DebugInterfaceModel;
import org.bidib.wizard.mvc.debug.view.DebugInterfaceView;
import org.bidib.wizard.mvc.debug.view.listener.DebugInterfaceViewListener;
import org.bidib.wizard.mvc.debug.view.listener.ProgressStatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugInterfaceController
implements DebugInterfaceControllerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugInterfaceController.class);
    private static final String APPENDER_NAME = DebugInterfaceController.class.getName();
    private final DockingDesktop desktop;
    private DockableStateChangeListener dockableStateChangeListener;
    private DebugInterfaceModel debugInterfaceModel;
    private DebugInterfaceView debugInterfaceView;
    private DebugConnection connection;
    private List<byte[]> firmwareContent;
    private ScheduledExecutorService sendFileWorker;
    private final SettingsService settingsService;
    private final DebugConnectionService debugConnectionService;
    private CompositeDisposable compDisposable;
    private final Supplier<String> connectionId;

    public DebugInterfaceController(DockingDesktop desktop, SettingsService settingsService, DebugConnectionService debugConnectionService) {
        this.desktop = desktop;
        this.settingsService = settingsService;
        this.debugConnectionService = debugConnectionService;
        this.connectionId = () -> "DebugMain";
    }

    private String extractPortName(String connectionUri) {
        if (connectionUri != null && connectionUri.indexOf(" - ") > 0) {
            connectionUri = connectionUri.substring(0, connectionUri.indexOf(" - "));
        }
        return connectionUri;
    }

    public void start() {
        DebugConnectionConfiguration config;
        String searchKey = "DebugInterfaceView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable view = this.desktop.getContext().getDockableByKey(searchKey);
        if (view != null) {
            LOGGER.info("Select the existing debug interface view instead of open a new one.");
            DockUtils.selectWindow((Dockable)view);
            return;
        }
        LOGGER.info("Create new DebugInterfaceView.");
        this.debugInterfaceModel = new DebugInterfaceModel();
        List connectionConfigurations = this.settingsService.getDebugToolsSettings().getDebugConnectionConfigurations();
        if (connectionConfigurations != null && !connectionConfigurations.isEmpty() && (config = (DebugConnectionConfiguration)connectionConfigurations.stream().filter(cc -> ((String)this.connectionId.get()).equals(cc.getId())).findFirst().orElse(null)) != null) {
            try {
                this.debugInterfaceModel.setSelectedPort(new CommPort(this.extractPortName(config.getConnectionUri())));
            }
            catch (Exception ex) {
                LOGGER.warn("Extract com port identifier from connectionUri failed: {}", (Object)config.getConnectionUri(), (Object)ex);
            }
        }
        this.debugInterfaceView = new DebugInterfaceView(this.desktop, (DebugInterfaceControllerListener)this, this.debugInterfaceModel, this.settingsService);
        DockableState[] dockables = this.desktop.getDockables();
        LOGGER.info("Current dockables: {}", new Object[]{dockables});
        if (dockables.length > 1) {
            DockableState tabPanelNodeDetails = null;
            for (DockableState dockable : dockables) {
                if (!DockKeys.DOCKKEY_TAB_PANEL.equals((Object)dockable.getDockable().getDockKey())) continue;
                LOGGER.info("Found the tab panel dockable.");
                tabPanelNodeDetails = dockable;
                break;
            }
            Dockable dock = this.desktop.getDockables()[1].getDockable();
            if (tabPanelNodeDetails != null) {
                LOGGER.info("Add the debug interface view next to the node details panel.");
                dock = tabPanelNodeDetails.getDockable();
                TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)dock);
                int order = 0;
                if (container != null) {
                    order = container.getTabCount();
                }
                LOGGER.info("Add new debugInterfaceView at order: {}", (Object)order);
                this.desktop.createTab(dock, (Dockable)this.debugInterfaceView, order, true);
            } else {
                this.desktop.split(dock, (Dockable)this.debugInterfaceView, DockingConstants.SPLIT_RIGHT);
            }
        } else {
            this.desktop.addDockable((Dockable)this.debugInterfaceView, RelativeDockablePosition.RIGHT);
        }
        this.debugInterfaceView.addDebugInterfaceViewListener((DebugInterfaceViewListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dockableStateChangeListener = new /* Unavailable Anonymous Inner Class!! */;
        this.desktop.addDockableStateChangeListener(this.dockableStateChangeListener);
        this.debugInterfaceModel.addPropertyChangeListener("logToFile", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.debugInterfaceModel.addPropertyChangeListener("logFileName", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.debugInterfaceModel.addPropertyChangeListener("selectedPort", evt -> {
            LOGGER.info("The selected port has been changed: {}", (Object)this.debugInterfaceModel.getSelectedPort());
            if (connectionConfigurations != null) {
                DebugConnectionConfiguration config = connectionConfigurations.stream().filter(cc -> ((String)this.connectionId.get()).equals(cc.getId())).findFirst().orElse(null);
                if (config != null) {
                    LOGGER.info("Update the existing config entry.");
                    PreferencesPortType portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.SerialPort.name());
                    config.setConnectionUri(this.debugInterfaceModel.getSelectedPort().getName());
                    config.setBaudRate(this.debugInterfaceModel.getBaudRate());
                    config.setConnectionProvider(portType.getConnectionPortType().name());
                } else {
                    LOGGER.info("Create new config entry.");
                    PreferencesPortType portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.SerialPort.name());
                    DebugConnectionConfiguration newConfig = new DebugConnectionConfiguration().withConnectionUri(this.debugInterfaceModel.getSelectedPort().getName()).withBaudRate(this.debugInterfaceModel.getBaudRate()).withConnectionProvider(portType.getConnectionPortType().name()).withId((String)this.connectionId.get()).withName((String)this.connectionId.get());
                    newConfig.setProviderKey("debugTools");
                    connectionConfigurations.add(newConfig);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTransmitFile(AtomicBoolean continueTransmit, ProgressStatusCallback callback) {
        File sendFile = this.debugInterfaceModel.getSendFile();
        LOGGER.info("Send file content to debugReader: {}", (Object)sendFile);
        if (this.connection != null) {
            this.firmwareContent = null;
            InputStream input = null;
            ArrayList<byte[]> firmwareContent = new ArrayList<byte[]>();
            try {
                byte[] buffer = new byte[256];
                input = new FileInputStream(sendFile);
                int readBytes = IOUtils.read((InputStream)input, (byte[])buffer);
                while (readBytes > 0) {
                    LOGGER.info("Number of bytes read: {}", (Object)readBytes);
                    byte[] packet = Arrays.copyOf(buffer, readBytes);
                    firmwareContent.add(packet);
                    readBytes = IOUtils.read((InputStream)input, (byte[])buffer);
                }
                this.firmwareContent = firmwareContent;
            }
            catch (IOException ex) {
                LOGGER.info("No firmware content file found.");
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Close input stream failed.", (Throwable)e);
                    }
                    input = null;
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)this.firmwareContent)) {
                LOGGER.info("Send first packet to debug reader.");
                this.debugInterfaceModel.setTransferInProgress(true);
                this.sendFirmwarePackets(continueTransmit, callback);
            }
        }
    }

    private void sendFirmwarePackets(AtomicBoolean continueTransmitHolder, ProgressStatusCallback callback) {
        Runnable runnable = () -> {
            LOGGER.info("Start sending firmware packets.");
            int packetsSent = 0;
            int totalPackets = this.firmwareContent.size();
            try {
                for (byte[] content : this.firmwareContent) {
                    if (!continueTransmitHolder.get()) {
                        LOGGER.warn("Transfer firmware was aborted by user.");
                        break;
                    }
                    this.connection.transmit(content);
                    ++packetsSent;
                    if (callback == null) continue;
                    callback.statusChanged(packetsSent * 100 / totalPackets);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Send firmware content to debug reader failed.", (Throwable)ex);
            }
            this.debugInterfaceModel.setTransferInProgress(false);
            if (callback != null) {
                callback.transferFinished();
            }
        };
        if (this.sendFileWorker == null) {
            this.sendFileWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("sendFileWorkers-thread-%d").build());
        }
        this.sendFileWorker.execute(runnable);
    }

    private void fireCloseConnection() {
        if (this.connection != null) {
            LOGGER.info("Close the debug reader.");
            this.connection.disconnect();
            this.debugInterfaceModel.setConnected(false);
            if (this.compDisposable != null) {
                LOGGER.info("Dispose and release the compDisposable.");
                this.compDisposable.dispose();
                this.compDisposable = null;
            }
            this.connection = null;
        } else {
            LOGGER.info("debug reader not available.");
        }
    }

    public void viewClosed() {
        LOGGER.info("The view is closed.");
        this.fireCloseConnection();
    }

    protected void fireLogToFileChanged() {
        block14: {
            if (this.debugInterfaceModel.isLogToFile() && StringUtils.isNotBlank((CharSequence)this.debugInterfaceModel.getLogFileName())) {
                LOGGER.info("Add logger for debug interface: {}", (Object)this.debugInterfaceModel.getLogFileName());
                try {
                    LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
                    ch.qos.logback.classic.Logger logTX = context.getLogger("DebugInterfacePane");
                    Appender appender = logTX.getAppender(APPENDER_NAME);
                    if (appender == null) {
                        context.getStatusManager().clear();
                        PatternLayoutEncoder ple = new PatternLayoutEncoder();
                        ple.setPattern("%msg%n");
                        ple.setContext((Context)context);
                        ple.start();
                        LOGGER.info("Create new appender.");
                        FileAppender fileAppender = new FileAppender();
                        fileAppender.setFile(this.debugInterfaceModel.getLogFileName());
                        fileAppender.setAppend(false);
                        fileAppender.setEncoder((Encoder)ple);
                        fileAppender.setContext((Context)context);
                        fileAppender.setName(APPENDER_NAME);
                        fileAppender.start();
                        logTX.setAdditive(false);
                        logTX.setLevel(Level.INFO);
                        logTX.addAppender((Appender)fileAppender);
                        List statusList = context.getStatusManager().getCopyOfStatusList();
                        if (CollectionUtils.isNotEmpty((Collection)statusList)) {
                            for (Status status : statusList) {
                                LOGGER.warn("Current status entry: {}", (Object)status);
                            }
                        }
                        break block14;
                    }
                    LOGGER.info("{} appender is already assigned.", (Object)APPENDER_NAME);
                }
                catch (Exception ex) {
                    LOGGER.info("Add debug interface logger failed.");
                }
            } else if (!this.debugInterfaceModel.isLogToFile() || StringUtils.isBlank((CharSequence)this.debugInterfaceModel.getLogFileName())) {
                LOGGER.info("Check if we must stop the logger.");
                try {
                    LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
                    ch.qos.logback.classic.Logger logTX = context.getLogger("DebugInterfacePane");
                    Appender appender = logTX.getAppender(APPENDER_NAME);
                    LOGGER.info("Current debug interface appender: {}", (Object)appender);
                    if (appender != null) {
                        context.getStatusManager().clear();
                        LOGGER.info("Detach and stop the appender.");
                        logTX.detachAppender(appender);
                        ((FileAppender)appender).stop();
                        Map map = (Map)context.getObject("RFA_FILENAME_PATTERN_COLLISION_MAP");
                        map.remove(APPENDER_NAME);
                        List statusList = context.getStatusManager().getCopyOfStatusList();
                        if (CollectionUtils.isNotEmpty((Collection)statusList)) {
                            for (Status status : statusList) {
                                LOGGER.warn("Current status entry: {}", (Object)status);
                            }
                        }
                    } else {
                        LOGGER.warn("Appender was not attached.");
                    }
                }
                catch (Exception ex) {
                    LOGGER.info("Remove debug interface logger failed.");
                }
            }
        }
    }
}

