/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.loco.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.util.function.Consumer;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.model.loco.LocoModel;
import org.bidib.wizard.mvc.common.view.RegisteredDialog;
import org.bidib.wizard.mvc.common.view.ViewCloseListener;
import org.bidib.wizard.mvc.loco.controller.LocoControlListener;
import org.bidib.wizard.mvc.loco.view.LocoView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class LocoDialog
extends JDialog
implements RegisteredDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoDialog.class);
    private static final long serialVersionUID = 1L;
    private LocoView locoView;
    private final LocoModel locoModel;
    private final Consumer<LocoModel> locoModelConsumer;
    private final Consumer<Integer> locoAddressChangeListener;

    public LocoDialog(JFrame parent, LocoModel locoModel, SettingsService settingsService, LocoControlListener locoControlListener, Consumer<LocoModel> locoModelConsumer, Consumer<Integer> locoAddressChangeListener) {
        super(parent);
        this.locoModel = locoModel;
        this.locoModelConsumer = locoModelConsumer;
        this.locoAddressChangeListener = locoAddressChangeListener;
        this.setDefaultCloseOperation(2);
        if (locoModel.isCarControlEnabled()) {
            this.setTitle(Resources.getString(LocoView.class, (String)"title.car"));
        } else {
            this.setTitle(Resources.getString(LocoView.class, (String)"title.loco"));
        }
        LOGGER.info("Create the locoDialog for locoModel: {}", (Object)locoModel);
        if (this.locoModel != null) {
            this.locoModelConsumer.accept(this.locoModel);
        }
        this.addContentPanel(locoModel, settingsService, locoControlListener);
        this.setLocationRelativeTo((Component)parent);
    }

    public static String prepareKey(Integer address) {
        if (address != null) {
            return LocoDialog.class.getSimpleName() + "-" + address;
        }
        return LocoDialog.class.getSimpleName() + "-";
    }

    public String getKey() {
        LOGGER.info("Prepare the key: {}", (Object)this.locoModel);
        Integer address = this.locoModel != null ? this.locoModel.getAddress() : null;
        return LocoDialog.prepareKey((Integer)address);
    }

    public Window getWindow() {
        return this;
    }

    private void addContentPanel(LocoModel locoModel, SettingsService settingsService, LocoControlListener locoControlListener) {
        this.locoView = new LocoView(locoModel, settingsService, locoControlListener, this.locoAddressChangeListener);
        this.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.locoView.getComponent(), "Center");
        this.pack();
        this.setMinimumSize(new Dimension(this.locoView.getComponent().getPreferredSize().width + 20, this.locoView.getComponent().getPreferredSize().height + 20));
        this.setVisible(true);
    }

    public void addViewCloseListener(ViewCloseListener listener) {
        this.locoView.addViewCloseListener(listener);
    }

    public void close(SettingsService settingsService) {
        LOGGER.info("The LocoView should be closed.");
        this.cleanup(settingsService);
        LOGGER.info("Cleanup has passed, set visible false.");
        this.setVisible(false);
    }

    private void cleanup(SettingsService settingsService) {
        LOGGER.info("The LocoDialog is disposed.");
        if (this.locoView != null) {
            this.locoView.cleanup(settingsService);
        }
    }
}

