/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.exchange;

import java.awt.Component;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.bidib.jbidibc.core.schema.bidib2.BiDiB;
import org.bidib.jbidibc.core.schema.bidib2.ConfigurationVariable;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointInput;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutput;
import org.bidib.jbidibc.core.schema.bidib2.Node;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.LookupService;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.client.common.exception.UserActionAbortedException;
import org.bidib.wizard.client.common.view.DefaultBusyFrame;
import org.bidib.wizard.client.common.view.cvdef.CvContainer;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeModelRegistry;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.mvc.main.view.exchange.NodeExchangeHelper;
import org.bidib.wizard.mvc.main.view.panel.listener.NodeListActionListener;
import org.bidib.wizard.utils.FileUtils;
import org.bidib.wizard.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class NodeExchangeHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeExchangeHelper.class);
    public static final String NODE_X_EXTENSION = "nodex";
    private static final String WORKING_DIR_NODE_EXCHANGE_KEY = "nodeExchange";

    public void importNode(DefaultBusyFrame parentComponent, NodeInterface node, SettingsService settingsService, NodeService nodeService, SwitchingNodeService switchingNodeService, CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry, FileFilter nodeFilter, WizardLabelWrapper wizardLabelWrapper, StatusBar statusBar, NodeListActionListener nodeListActionListener, LookupService lookupService) {
        HashMap importParams = new HashMap();
        WizardSettingsInterface wizardSettings = settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory("nodeExchange");
        1 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    protected void transformMatchingProduct(Component parent, NodeInterface node, BiDiB bidib, LookupService lookupService) throws UserActionAbortedException {
        if (bidib == null || bidib.getNodes() == null || bidib.getNodes().getNode().isEmpty()) {
            LOGGER.warn("The provided BiDiB data is not valid for node import.");
            throw new IllegalArgumentException("The provided BiDiB data is not valid for node import.");
        }
        Node importNode = (Node)bidib.getNodes().getNode().get(0);
        LOGGER.info("Transform the bidib instance, node: {}, schemaNode: {}", (Object)node, (Object)importNode.getProductName());
        long sourceUniqueId = importNode.getUniqueId();
        long targetUniqueId = node.getUniqueId();
        if (ProductUtils.isProductEqual((long)targetUniqueId, (long)sourceUniqueId)) {
            if (ProductUtils.getVendorId((long)sourceUniqueId) == 251 && (ProductUtils.getPid((long)sourceUniqueId) == 114 || ProductUtils.getPid((long)sourceUniqueId) == 113) || ProductUtils.getVendorId((long)sourceUniqueId) == 13 && ProductUtils.getPid((long)sourceUniqueId) == 118) {
                SoftwareVersion importVersion = SoftwareVersion.parse((String)importNode.getFirmwareRelease());
                if (node.getNode().getSoftwareVersion().isHigherOrEqualThan(SoftwareVersion.build((int)2, (int)0, (int)0)) && importVersion.isLowerThan(SoftwareVersion.build((int)2, (int)0, (int)0))) {
                    this.transformOneDmxToV2(importNode);
                }
            }
            return;
        }
        if (ProductUtils.getVendorId((long)sourceUniqueId) == 13 && ProductUtils.getVendorId((long)targetUniqueId) == 13) {
            if (ProductUtils.getPid((long)sourceUniqueId) == 142 && ProductUtils.getPid((long)targetUniqueId) == 140 || ProductUtils.getPid((long)sourceUniqueId) == 141 && ProductUtils.getPid((long)targetUniqueId) == 117) {
                LOGGER.info("Found import of OneControl-04-16-48-24 --> OneControl-08-00-48-24 or OneControl 04-16-32-20 --> OneControl 08-00-32-20. Must change the port numbers for all ports with portnumber > 3.");
                int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(parent), Resources.getString(NodeExchangeHelper.class, (String)"import-with-transformation.message"), Resources.getString(NodeExchangeHelper.class, (String)"import-with-transformation.title"), 2, 1);
                if (result != 0) {
                    LOGGER.info("User cancelled import operation.");
                    throw new UserActionAbortedException("User cancelled import operation.");
                }
                this.transformOneControlOneDriveTurn(importNode);
            } else if (ProductUtils.getPid((long)sourceUniqueId) == 145 && ProductUtils.getPid((long)targetUniqueId) == 143 || ProductUtils.getPid((long)sourceUniqueId) == 144 && ProductUtils.getPid((long)targetUniqueId) == 122) {
                LOGGER.info("Found import of OneDriveTurn-04-16-48-24 --> OneDriveTurn-08-00-48-24 or OneDriveTurn 04-16-32-20 --> OneDriveTurn 08-00-32-20. Must change the port numbers for all ports with portnumber > 3.");
                int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(parent), Resources.getString(NodeExchangeHelper.class, (String)"import-with-transformation.message"), Resources.getString(NodeExchangeHelper.class, (String)"import-with-transformation.title"), 2, 1);
                if (result != 0) {
                    LOGGER.info("User cancelled import operation.");
                    throw new UserActionAbortedException("User cancelled import operation.");
                }
                this.transformOneControlOneDriveTurn(importNode);
            } else if (ProductUtils.getPid((long)sourceUniqueId) != ProductUtils.getPid((long)targetUniqueId)) {
                String sourceProductName = this.getProductName(lookupService, sourceUniqueId);
                String targetProductName = this.getProductName(lookupService, targetUniqueId);
                int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(parent), Resources.getString(NodeExchangeHelper.class, (String)"import-with-different-pid.message", (Object[])new Object[]{sourceProductName, targetProductName}), Resources.getString(NodeExchangeHelper.class, (String)"import-with-different-pid.title"), 2, 2);
                if (result != 0) {
                    LOGGER.info("User cancelled import operation.");
                    throw new UserActionAbortedException("User cancelled import operation.");
                }
            }
        } else if (ProductUtils.getVendorId((long)sourceUniqueId) == 251 && ProductUtils.getVendorId((long)targetUniqueId) == 251) {
            if (ProductUtils.getPid((long)sourceUniqueId) != ProductUtils.getPid((long)targetUniqueId)) {
                String sourceProductName = this.getProductName(lookupService, sourceUniqueId);
                String targetProductName = this.getProductName(lookupService, targetUniqueId);
                int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(parent), Resources.getString(NodeExchangeHelper.class, (String)"import-with-different-pid.message", (Object[])new Object[]{sourceProductName, targetProductName}), Resources.getString(NodeExchangeHelper.class, (String)"import-with-different-pid.title"), 2, 2);
                if (result != 0) {
                    LOGGER.info("User cancelled import operation.");
                    throw new UserActionAbortedException("User cancelled import operation.");
                }
            }
        } else if (ProductUtils.getVendorId((long)sourceUniqueId) != ProductUtils.getVendorId((long)targetUniqueId) && ProductUtils.getPid((long)sourceUniqueId) != ProductUtils.getPid((long)targetUniqueId)) {
            String sourceProductName = this.getProductName(lookupService, sourceUniqueId);
            String targetProductName = this.getProductName(lookupService, targetUniqueId);
            int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(parent), Resources.getString(NodeExchangeHelper.class, (String)"import-with-different-pid.message", (Object[])new Object[]{sourceProductName, targetProductName}), Resources.getString(NodeExchangeHelper.class, (String)"import-with-different-pid.title"), 2, 2);
            if (result != 0) {
                LOGGER.info("User cancelled import operation.");
                throw new UserActionAbortedException("User cancelled import operation.");
            }
        }
    }

    protected String getProductName(LookupService lookupService, long sourceUniqueId) {
        String sourceProductName = lookupService.getProduct(ProductUtils.getVendorId((long)sourceUniqueId), ProductUtils.getPid((long)sourceUniqueId)).filter(Objects::nonNull).map(pt -> pt.getName()).orElse(Resources.getString(NodeExchangeHelper.class, (String)"import-with-different-pid.unknown-product", (Object[])new Object[]{ProductUtils.getVendorId((long)sourceUniqueId), ProductUtils.getPid((long)sourceUniqueId)}));
        return sourceProductName;
    }

    protected void transformOneDmxToV2(Node importNode) {
        if (importNode.getConfigurationVariables() != null && !importNode.getConfigurationVariables().getConfigurationVariable().isEmpty()) {
            LOGGER.info("Process CV values.");
            Collections.sort(importNode.getConfigurationVariables().getConfigurationVariable(), (cv1, cv2) -> Integer.compare(Integer.parseInt(cv1.getName()), Integer.parseInt(cv2.getName())));
            LOGGER.info("Number of CV values: {}", (Object)importNode.getConfigurationVariables().getConfigurationVariable().size());
            if (LOGGER.isDebugEnabled()) {
                importNode.getConfigurationVariables().getConfigurationVariable().forEach(cv -> LOGGER.debug("Current CV, num: {}, value: {}", (Object)cv.getName(), (Object)cv.getValue()));
            }
            List configurationVariables = importNode.getConfigurationVariables().getConfigurationVariable();
            ArrayList configurationVariablesTarget = new ArrayList();
            int startCvSource = 781;
            int startCvTarget = 771;
            for (int overlayIndex = 3; overlayIndex > -1; --overlayIndex) {
                int cvNumberSource = startCvSource;
                int cvNumberTarget = startCvTarget;
                for (int channelIndex = 7; channelIndex > -1; --channelIndex) {
                    LOGGER.info("sourceCv: {} --> targetCv: {}", (Object)cvNumberSource, (Object)cvNumberTarget);
                    this.transformCv(configurationVariables, configurationVariablesTarget, cvNumberSource, cvNumberTarget, (cvVarSource, cvVarTarget) -> cvVarTarget.setValue(cvVarSource.getValue()));
                    this.transformCv(configurationVariables, configurationVariablesTarget, cvNumberSource + 1, cvNumberTarget + 1, (cvVarSource, cvVarTarget) -> cvVarTarget.setValue(cvVarSource.getValue()));
                    this.transformCv(configurationVariables, configurationVariablesTarget, cvNumberSource + 2, cvNumberTarget + 4, (cvVarSource, cvVarTarget) -> cvVarTarget.setValue(cvVarSource.getValue()));
                    this.transformCv(configurationVariablesTarget, cvNumberTarget + 2, cvVar -> cvVar.setValue(String.valueOf(0)));
                    this.transformCv(configurationVariablesTarget, cvNumberTarget + 3, cvVar -> cvVar.setValue(String.valueOf(0)));
                    cvNumberSource -= 3;
                    cvNumberTarget -= 5;
                }
                startCvSource -= 48;
                startCvTarget -= 40;
            }
            Collections.sort(configurationVariablesTarget, (cv1, cv2) -> Integer.compare(Integer.parseInt(cv1.getName()), Integer.parseInt(cv2.getName())));
            LOGGER.info("configurationVariablesTarget: {}", configurationVariablesTarget);
            List filteredCVs = configurationVariables.stream().filter(cv -> Integer.parseInt(cv.getName()) < 616 || Integer.parseInt(cv.getName()) > 807).collect(Collectors.toList());
            LOGGER.info("Number of filtered CV values: {}", (Object)filteredCVs.size());
            configurationVariables.clear();
            configurationVariables.addAll(filteredCVs);
            configurationVariables.addAll(configurationVariablesTarget);
            LOGGER.info("Final number of CV values: {}", (Object)configurationVariables.size());
        }
    }

    private void transformCv(List<ConfigurationVariable> configurationVariables, List<ConfigurationVariable> configurationVariablesTarget, int cvNumberSource, int cvNumberTarget, BiConsumer<ConfigurationVariable, ConfigurationVariable> action) {
        ConfigurationVariable cvVarSource = configurationVariables.stream().filter(cv -> cv.getName().equals(String.valueOf(cvNumberSource))).findFirst().orElseThrow(() -> new IllegalArgumentException("No CV available, cvNumber: " + cvNumberSource));
        ConfigurationVariable cvVarTarget = new ConfigurationVariable().withName(String.valueOf(cvNumberTarget)).withDescription(cvVarSource.getDescription()).withDefaultValue(cvVarSource.getDefaultValue()).withValue(cvVarSource.getValue()).withTimeout(cvVarSource.isTimeout());
        configurationVariablesTarget.add(cvVarTarget);
        action.accept(cvVarSource, cvVarTarget);
    }

    private void transformCv(List<ConfigurationVariable> configurationVariablesTarget, int cvNumberTarget, Consumer<ConfigurationVariable> action) {
        ConfigurationVariable cvVarTarget = new ConfigurationVariable().withName(String.valueOf(cvNumberTarget));
        configurationVariablesTarget.add(cvVarTarget);
        action.accept(cvVarTarget);
    }

    protected void transformOneControlOneDriveTurn(Node importNode) {
        if (importNode.getPorts() != null) {
            importNode.getPorts().getPort().stream().map(port -> {
                LOGGER.info("Process port: {}", port);
                if (port.getNumber() > 3) {
                    LOGGER.info("Port: change port number from {} to {}", (Object)port.getNumber(), (Object)(port.getNumber() + 4));
                    port.setNumber(port.getNumber() + 4);
                }
                return port;
            }).collect(Collectors.toList());
        } else {
            LOGGER.warn("No ports available.");
        }
        if (importNode.getMacros() != null) {
            importNode.getMacros().getMacro().forEach(macro -> {
                if (macro.getMacroPoints() != null) {
                    macro.getMacroPoints().getMacroPoint().stream().filter(mp -> mp instanceof MacroPointOutput || mp instanceof MacroPointInput).map(mp -> {
                        MacroPointInput mpi;
                        if (mp instanceof MacroPointOutput) {
                            MacroPointOutput mpo = (MacroPointOutput)mp;
                            if (mpo.getOutputNumber() > 3) {
                                LOGGER.info("Macro: change port number from {} to {}", (Object)mpo.getOutputNumber(), (Object)(mpo.getOutputNumber() + 4));
                                mpo.setOutputNumber(mpo.getOutputNumber() + 4);
                            }
                        } else if (mp instanceof MacroPointInput && (mpi = (MacroPointInput)mp).getInputNumber() > 3) {
                            LOGGER.info("Macro: change input port number from {} to {}", (Object)mpi.getInputNumber(), (Object)(mpi.getInputNumber() + 4));
                            mpi.setInputNumber(mpi.getInputNumber() + 4);
                        }
                        return mp;
                    }).collect(Collectors.toList());
                }
            });
        } else {
            LOGGER.warn("No macros available.");
        }
        if (importNode.getConfigurationVariables() != null && !importNode.getConfigurationVariables().getConfigurationVariable().isEmpty()) {
            LOGGER.info("Process CV values.");
            Collections.sort(importNode.getConfigurationVariables().getConfigurationVariable(), (cv1, cv2) -> Integer.compare(Integer.parseInt(cv1.getName()), Integer.parseInt(cv2.getName())));
            LOGGER.info("Number of CV values: {}", (Object)importNode.getConfigurationVariables().getConfigurationVariable().size());
            if (LOGGER.isDebugEnabled()) {
                importNode.getConfigurationVariables().getConfigurationVariable().forEach(cv -> LOGGER.debug("Current CV, num: {}, value: {}", (Object)cv.getName(), (Object)cv.getValue()));
            }
            List filteredCVs = importNode.getConfigurationVariables().getConfigurationVariable().stream().filter(cv -> Integer.parseInt(cv.getName()) < 10000).collect(Collectors.toList());
            LOGGER.info("Number of filtered CV values: {}", (Object)filteredCVs.size());
            importNode.getConfigurationVariables().getConfigurationVariable().clear();
            importNode.getConfigurationVariables().getConfigurationVariable().addAll(filteredCVs);
        }
    }

    public void exportNode(DefaultBusyFrame parentComponent, NodeInterface node, SettingsService settingsService, NodeService nodeService, SwitchingNodeService switchingNodeService, WizardLabelWrapper wizardLabelWrapper, CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry, FileFilter nodeFilter, StatusBar statusBar, String lang) {
        LOGGER.info("export node: {}", (Object)node);
        WizardSettingsInterface wizardSettings = settingsService.getWizardSettings();
        String fileName = NodeExchangeHelper.prepareFileName((WizardSettingsInterface)wizardSettings, (NodeInterface)node);
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory("nodeExchange");
        2 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    public BiDiB prepareBiDiB(NodeInterface node, CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry, String lang, boolean skipCvValues, WizardLabelWrapper wizardLabelWrapper) {
        CvContainer cvContainer = cvDefinitionTreeModelRegistry.getCvContainer(node.getUniqueId());
        Map cvNumberToNodeMap = cvContainer != null ? cvContainer.getCvNumberToNodeMap() : new HashMap();
        BiDiB bidib = NodeUtils.convertToBiDiB((NodeInterface)node, (Map)cvNumberToNodeMap, (String)lang, (boolean)skipCvValues, (WizardLabelWrapper)wizardLabelWrapper);
        LOGGER.debug("prepareBiDiB, converted node to bidib: {}", (Object)bidib);
        return bidib;
    }

    public static String prepareFileName(WizardSettingsInterface wizardSettings, NodeInterface node) {
        Object nodeLabel = NodeUtils.prepareLabel((NodeInterface)node);
        boolean nodeExportAppendDateEnabled = wizardSettings.isNodeExportAppendDateEnabled();
        if (nodeExportAppendDateEnabled) {
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("_yyyyMMdd_HHmmss");
            String currentDateTime = now.format(formatter);
            nodeLabel = (String)nodeLabel + currentDateTime;
        }
        LOGGER.info("export node, prepared nodeLabel as filename: {}", nodeLabel);
        if (!FileUtils.isPathValid((String)nodeLabel) || !FileUtils.isFilenameValid((String)nodeLabel)) {
            LOGGER.warn("The default filename is not a valid filename: {}", nodeLabel);
            nodeLabel = FileUtils.escapeInvalidFilenameCharacters((String)nodeLabel, (String)"_");
            LOGGER.info("export node, prepared escaped filename: {}", nodeLabel);
        }
        return (String)nodeLabel + ".nodex";
    }
}

