package org.bidib.wizard.mvc.main.model;

import org.bidib.wizard.api.model.Macro;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.Model;

public class SelectedMacroModel extends Model {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(SelectedMacroModel.class);

    public static final String PROPERTY_SELECTED_MACRO = "selectedMacro";

    private Macro selectedMacro;

    public void setSelectedMacro(Macro selectedMacro) {
        Macro oldValue = this.selectedMacro;

        this.selectedMacro = selectedMacro;

        LOGGER.debug("Set the new selected macro: {}, oldValue: {}", selectedMacro, oldValue);

        firePropertyChange(PROPERTY_SELECTED_MACRO, oldValue, selectedMacro);
    }

    public Macro getSelectedMacro() {
        return selectedMacro;
    }

    public void triggerLabelChanged() {
        firePropertyChange(PROPERTY_SELECTED_MACRO, null, selectedMacro);
    }

}
