package org.bidib.wizard.mvc.main.view.panel.renderer;

import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.common.utils.ImageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessoryListRenderer extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryListRenderer.class);

    private ImageIcon pendingChangesIcon;

    private ImageIcon permanentlyStoredIcon;

    private ImageIcon errorIcon;

    public AccessoryListRenderer() {
        pendingChangesIcon = ImageUtils.createImageIcon(AccessoryListRenderer.class, "/icons/write.png");
        permanentlyStoredIcon = ImageUtils.createImageIcon(AccessoryListRenderer.class, "/icons/16x16/lock.png");
        errorIcon = ImageUtils.createImageIcon(AccessoryListRenderer.class, "/icons/accessory-error.png");
    }

    @Override
    public Component getTableCellRendererComponent(
        JTable list, Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
        // prepare the default renderer
        Component renderer = super.getTableCellRendererComponent(list, value, isSelected, cellHasFocus, row, column);
        if (value instanceof Accessory) {
            Accessory accessory = (Accessory) value;

            switch (accessory.getAccessorySaveState()) {
                case PENDING_CHANGES:
                    // set the pending changes icon
                    setIcon(pendingChangesIcon);
                    break;
                case PERMANENTLY_STORED_ON_NODE:
                    setIcon(permanentlyStoredIcon);
                    break;
                default:
                    LOGGER.error("Unknown accessory save state detected: {}", accessory.getAccessorySaveState());
                    break;
            }

            if (accessory.hasError()) {
                setIcon(errorIcon);
                setToolTipText("The accessory has an error.");
            }
            else if (accessory.hasExecutionStateError()) {

                //

                setIcon(errorIcon);
                setToolTipText(
                    "The accessory has an excution error: " + accessory.getAccessoryState().getErrorInformation());
            }
            else {
                setToolTipText(null);
            }

            String text = null;
            if (StringUtils.isNotBlank(accessory.getLabel())) {
                text = String.format("%1$02d : %2$s", accessory.getId(), accessory.getLabel());
            }
            else if (accessory.getId() > -1) {
                text = String.format("%1$02d :", accessory.getId());
            }
            else {
                text = " ";
            }

            setText(text);
        }
        return renderer;
    }
}