package org.bidib.wizard.mvc.loco.view;

import java.util.BitSet;
import java.util.Map;

import javax.swing.JButton;

import org.assertj.core.api.Assertions;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.model.loco.LocoModel;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.mvc.loco.controller.LocoControlListener;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.TestInstance.Lifecycle;
import org.junit.jupiter.api.condition.DisabledIf;
import org.mockito.Mockito;

@TestInstance(Lifecycle.PER_CLASS)
@DisabledIf(value = "java.awt.GraphicsEnvironment#isHeadless", disabledReason = "headless environment")
class LocoViewTest {

    private LocoView locoView;

    private SettingsService settingsService;

    private WizardSettingsInterface wizardSettings;

    private LocoModel locoModel;

    private LocoListModel locoListModel;

    private LocoControlListener locoControlListener;

    @BeforeAll
    void setup() {

        this.settingsService = Mockito.mock(SettingsService.class);
        this.wizardSettings = Mockito.mock(WizardSettingsInterface.class);
        Mockito.when(this.settingsService.getWizardSettings()).thenReturn(this.wizardSettings);
        Mockito.when(this.wizardSettings.isM4SupportEnabled()).thenReturn(false);

        this.locoControlListener = Mockito.mock(LocoControlListener.class);

        this.locoListModel = new LocoListModel(10);
        this.locoModel = new LocoModel(this.locoListModel);

        this.locoView = new LocoView(locoModel, settingsService, this.locoControlListener, null);
    }

    @Test
    void updateFunctionState() {

        final Map<String, JButton> functionButtonMap = locoView.getFunctionButtonMap();

        final BitSet functions = this.locoListModel.getFunctions();

        int function = 1;
        functions.set(function, true);
        locoView.updateFunctionState(functions, functionButtonMap);

        Assertions.assertThat(functionButtonMap.get("F" + function)).isNotNull();
        Assertions.assertThat(functionButtonMap.get("F" + function).isSelected()).isTrue();

        Assertions.assertThat(functionButtonMap.get("F" + function + 1)).isNotNull();
        Assertions.assertThat(functionButtonMap.get("F" + function + 1).isSelected()).isFalse();
    }

}
