/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.FormsSetup;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import com.jidesoft.combobox.ColorExComboBox;
import com.jidesoft.converter.ColorConverter;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.Int16PortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.port.RgbPortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.utils.PortUtils;
import org.bidib.wizard.client.common.component.SliderAndValuePanel;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.converter.ColorRGBToIntegerConverter;
import org.bidib.wizard.client.common.converter.StringToDmxChannelConverter;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.rxjava2.SwingScheduler;
import org.bidib.wizard.client.common.table.AbstractPortEditorPanel;
import org.bidib.wizard.client.common.table.listener.PortEditorPanelCallback;
import org.bidib.wizard.client.common.text.HintTextField;
import org.bidib.wizard.client.common.text.WizardBindings;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.renderer.BidibStatusListRenderer;
import org.bidib.wizard.client.common.view.validation.DefaultRangeValidationCallback;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.IntegerInputValidationDocument;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.client.common.view.validation.RangeValidationCallback;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.mvc.main.model.LightPortTableModel;
import org.bidib.wizard.mvc.main.view.table.converter.PortStatusToStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightPortEditorPanel
extends AbstractPortEditorPanel<LightPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LightPortEditorPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, max(60dlu;pref), 3dlu, pref, 3dlu, pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private static final int TIME_BETWEEN_STATUS_EVENTS_MILLIS = 80;
    private static final int TIME_BETWEEN_PORT_CONFIG_EVENTS_MILLIS = 100;
    private ValueModel portLevelOffConverterModel;
    private ValueModel portLevelOnConverterModel;
    private ValueModel dimmDownConverterModel;
    private ValueModel dimmUpConverterModel;
    private ValueModel rgbValueModel;
    private ValueModel transitionTimeConverterModel;
    private ValueModel dmxMappingConverterModel;
    private JTextField portName;
    private HintTextField portLevelOffText;
    private HintTextField portLevelOnText;
    private HintTextField dimmDownText;
    private HintTextField dimmUpText;
    private HintTextField transitionTimeText;
    private HintTextField dmxMappingText;
    private SliderAndValuePanel portLevelOffSlider;
    private SliderAndValuePanel portLevelOnSlider;
    private SliderAndValuePanel dimmDownSlider;
    private SliderAndValuePanel dimmUpSlider;
    private JComboBox<LightPortStatus> comboPortStatus;
    private JLabel statusLabel;
    private JButton btnPortStatus;
    private ColorExComboBox rgbColorComboBox;
    private byte dimmUpPcfg = (byte)3;
    private byte dimmDownPcfg = (byte)4;
    private PublishSubject<LightPortStatus> statusEventSubject = PublishSubject.create();

    public LightPortEditorPanel(LightPort port, Consumer<LightPort> saveCallback, Consumer<LightPort> valueCallback, Consumer<LightPort> refreshCallback, PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        super((Port)port, saveCallback, valueCallback, refreshCallback, portConfigChangeEventSubject, nodeSelectionProvider);
    }

    protected LightPort clonePort(LightPort port) {
        LightPort clone = (LightPort)LightPort.builder().withDimMax(port.getDimMax()).withDimMin(port.getDimMin()).withPwmMax(port.getPwmMax()).withPwmMin(port.getPwmMin()).withRgbValue(port.getRgbValue()).withTransitionTime(port.getTransitionTime()).withDmxMapping(port.getDmxMapping()).withStatus((BidibStatus)((LightPortStatus)port.getStatus())).withRemappingEnabled(port.isRemappingEnabled()).withKnownPortConfigKeys(port.getKnownPortConfigKeys()).withId(port.getId()).withLabel(port.getLabel()).withEnabled(port.isEnabled()).withIsInactive(port.isInactive()).withPortIdentifier(port.getPortIdentifier()).build();
        if (clone.getDimMax() == 0) {
            clone.setDimMax(1);
        }
        if (clone.getDimMin() == 0) {
            clone.setDimMin(1);
        }
        return clone;
    }

    protected JPanel doCreateComponent(LightPort port) {
        boolean dimm_8_8;
        JLabel label;
        BufferedValueModel valueValueModel;
        AbstractPortEditorPanel.PortEditorPanelDebugContainer panel;
        int row = 1;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new AbstractPortEditorPanel.PortEditorPanelDebugContainer((PortEditorPanelCallback)this);
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new AbstractPortEditorPanel.PortEditorPanelContainer((PortEditorPanelCallback)this);
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        ArrayList<JComponent> order = new ArrayList<JComponent>();
        BufferedValueModel bufferedPortNameModel = this.getPresentationModel().getBufferedModel("label");
        dialogBuilder.add(Resources.getString(LightPortTableModel.class, (String)"label") + ":", new Object[0]).xy(1, row);
        this.portName = WizardComponentFactory.createTextField((ValueModel)bufferedPortNameModel, (boolean)false);
        this.portName.setEnabled(port.isEnabled());
        dialogBuilder.add((Component)this.portName).xyw(3, row, 7);
        order.add(this.portName);
        row += 2;
        if (this.isPortConfigKeySupported((byte)2)) {
            valueValueModel = this.getPresentationModel().getBufferedModel("pwmMin");
            this.portLevelOffConverterModel = new ConverterValueModel((ValueModel)valueValueModel, (BindingConverter)new StringToIntegerConverter());
            this.portLevelOffText = new HintTextField(() -> this.triggerValidation());
            IntegerInputValidationDocument portLevelOffDocument = new IntegerInputValidationDocument(5, "0123456789");
            portLevelOffDocument.setRangeValidationCallback((RangeValidationCallback)new DefaultRangeValidationCallback(0, 255, showHint -> this.portLevelOffText.showHint(showHint.booleanValue())));
            this.portLevelOffText.setDocument((Document)portLevelOffDocument);
            this.portLevelOffText.setColumns(2);
            this.portLevelOffText.setHorizontalAlignment(4);
            WizardBindings.bind((JTextField)this.portLevelOffText, (ValueModel)this.portLevelOffConverterModel, (boolean)true);
            dialogBuilder.add(Resources.getString(LightPortTableModel.class, (String)"portLevelOff"), new Object[0]).xy(1, row);
            dialogBuilder.add((Component)this.portLevelOffText).xy(3, row);
            this.portLevelOffText.setEnabled(port.isEnabled());
            order.add((JComponent)this.portLevelOffText);
            ValidationComponentUtils.setMandatory((JComponent)this.portLevelOffText, (boolean)true);
            ValidationComponentUtils.setMessageKeys((JComponent)this.portLevelOffText, (Object[])new Object[]{"validation.portLevelOff_key"});
            this.portLevelOffSlider = new SliderAndValuePanel(0, 255, 10);
            this.portLevelOffSlider.createComponent();
            WizardBindings.bind((SliderAndValuePanel)this.portLevelOffSlider, (ValueModel)valueValueModel);
            this.portLevelOffSlider.setEnabled(port.isEnabled());
            dialogBuilder.add((Component)this.portLevelOffSlider).xyw(5, row, 5);
            order.add(this.portLevelOffSlider.getSlider());
            valueValueModel.addValueChangeListener(evt -> {
                if (valueValueModel.getValue() instanceof Integer) {
                    int portLevelOffValue = (Integer)valueValueModel.getValue();
                    LOGGER.info("The portLevelOff value has been changed: {}", (Object)portLevelOffValue);
                    this.getLocalPortConfigChangeEventSubject().onNext((Object)new PortConfigChangeEvent(null, 0L, (PortTypeAware)port, Byte.valueOf((byte)2), (PortConfigValue)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)portLevelOffValue)))));
                }
            });
            row += 2;
        }
        if (this.isPortConfigKeySupported((byte)1)) {
            valueValueModel = this.getPresentationModel().getBufferedModel("pwmMax");
            this.portLevelOnConverterModel = new ConverterValueModel((ValueModel)valueValueModel, (BindingConverter)new StringToIntegerConverter());
            this.portLevelOnText = new HintTextField(() -> this.triggerValidation());
            IntegerInputValidationDocument portLevelOnDocument = new IntegerInputValidationDocument(5, "0123456789");
            portLevelOnDocument.setRangeValidationCallback((RangeValidationCallback)new DefaultRangeValidationCallback(0, 255, showHint -> this.portLevelOnText.showHint(showHint.booleanValue())));
            this.portLevelOnText.setDocument((Document)portLevelOnDocument);
            this.portLevelOnText.setColumns(2);
            this.portLevelOnText.setHorizontalAlignment(4);
            WizardBindings.bind((JTextField)this.portLevelOnText, (ValueModel)this.portLevelOnConverterModel, (boolean)true);
            dialogBuilder.add(Resources.getString(LightPortTableModel.class, (String)"portLevelOn"), new Object[0]).xy(1, row);
            dialogBuilder.add((Component)this.portLevelOnText).xy(3, row);
            this.portLevelOnText.setEnabled(port.isEnabled());
            order.add((JComponent)this.portLevelOnText);
            ValidationComponentUtils.setMandatory((JComponent)this.portLevelOnText, (boolean)true);
            ValidationComponentUtils.setMessageKeys((JComponent)this.portLevelOnText, (Object[])new Object[]{"validation.portLevelOn_key"});
            this.portLevelOnSlider = new SliderAndValuePanel(0, 255, 10);
            this.portLevelOnSlider.createComponent();
            WizardBindings.bind((SliderAndValuePanel)this.portLevelOnSlider, (ValueModel)valueValueModel);
            this.portLevelOnSlider.setEnabled(port.isEnabled());
            dialogBuilder.add((Component)this.portLevelOnSlider).xyw(5, row, 5);
            order.add(this.portLevelOnSlider.getSlider());
            valueValueModel.addValueChangeListener(evt -> {
                if (valueValueModel.getValue() instanceof Integer) {
                    int portLevelOnValue = (Integer)valueValueModel.getValue();
                    LOGGER.info("The portLevelOn value has been changed: {}", (Object)portLevelOnValue);
                    this.getLocalPortConfigChangeEventSubject().onNext((Object)new PortConfigChangeEvent(null, 0L, (PortTypeAware)port, Byte.valueOf((byte)1), (PortConfigValue)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)portLevelOnValue)))));
                }
            });
            row += 2;
        }
        if (this.isPortConfigKeySupported((byte)3) || this.isPortConfigKeySupported((byte)67)) {
            valueValueModel = this.getPresentationModel().getBufferedModel("dimMax");
            this.dimmUpConverterModel = new ConverterValueModel((ValueModel)valueValueModel, (BindingConverter)new StringToIntegerConverter());
            int maxRange = this.isPortConfigKeySupported((byte)67) ? 65535 : 255;
            this.dimmUpText = new HintTextField(() -> this.triggerValidation(), maxRange);
            IntegerInputValidationDocument dimmUpDocument = new IntegerInputValidationDocument(5, "0123456789");
            dimmUpDocument.setRangeValidationCallback((RangeValidationCallback)new DefaultRangeValidationCallback(1, maxRange, showHint -> this.dimmUpText.showHint(showHint.booleanValue())));
            this.dimmUpText.setDocument((Document)dimmUpDocument);
            this.dimmUpText.setColumns(2);
            this.dimmUpText.setHorizontalAlignment(4);
            WizardBindings.bind((JTextField)this.dimmUpText, (ValueModel)this.dimmUpConverterModel, (boolean)true);
            label = FormsSetup.getComponentFactoryDefault().createLabel(Resources.getString(LightPortTableModel.class, (String)"dimmUp"));
            label.setToolTipText(Resources.getString(LightPortTableModel.class, (String)"dimmUp.tooltip"));
            dialogBuilder.add((Component)label).xy(1, row);
            dialogBuilder.add((Component)this.dimmUpText).xy(3, row);
            this.dimmUpText.setEnabled(port.isEnabled());
            order.add((JComponent)this.dimmUpText);
            ValidationComponentUtils.setMandatory((JComponent)this.dimmUpText, (boolean)true);
            ValidationComponentUtils.setMessageKeys((JComponent)this.dimmUpText, (Object[])new Object[]{"validation.dimmUp_key"});
            this.dimmUpSlider = new /* Unavailable Anonymous Inner Class!! */;
            this.dimmUpSlider.createComponent();
            WizardBindings.bind((SliderAndValuePanel)this.dimmUpSlider, (ValueModel)valueValueModel);
            this.dimmUpSlider.setEnabled(port.isEnabled());
            dialogBuilder.add((Component)this.dimmUpSlider).xyw(5, row, 5);
            order.add(this.dimmUpSlider.getSlider());
            dimm_8_8 = this.isPortConfigKeySupported((byte)67);
            this.dimmUpPcfg = (byte)(dimm_8_8 ? 67 : 3);
            valueValueModel.addValueChangeListener(evt -> {
                if (valueValueModel.getValue() instanceof Integer) {
                    int dimmUpValue = (Integer)valueValueModel.getValue();
                    LOGGER.info("The dimmUp value has been changed: {}", (Object)dimmUpValue);
                    this.getLocalPortConfigChangeEventSubject().onNext((Object)new PortConfigChangeEvent(null, 0L, (PortTypeAware)port, Byte.valueOf(dimm_8_8 ? (byte)67 : (byte)3), (PortConfigValue)(dimm_8_8 ? new Int16PortConfigValue(Integer.valueOf(ByteUtils.getWORD((int)dimmUpValue))) : new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)dimmUpValue))))));
                }
            });
            row += 2;
        }
        if (this.isPortConfigKeySupported((byte)4) || this.isPortConfigKeySupported((byte)68)) {
            valueValueModel = this.getPresentationModel().getBufferedModel("dimMin");
            this.dimmDownConverterModel = new ConverterValueModel((ValueModel)valueValueModel, (BindingConverter)new StringToIntegerConverter());
            int maxRange = this.isPortConfigKeySupported((byte)68) ? 65535 : 255;
            this.dimmDownText = new HintTextField(() -> this.triggerValidation(), maxRange);
            IntegerInputValidationDocument dimmDownDocument = new IntegerInputValidationDocument(5, "0123456789");
            dimmDownDocument.setRangeValidationCallback((RangeValidationCallback)new DefaultRangeValidationCallback(1, maxRange, showHint -> this.dimmDownText.showHint(showHint.booleanValue())));
            this.dimmDownText.setDocument((Document)dimmDownDocument);
            this.dimmDownText.setColumns(2);
            this.dimmDownText.setHorizontalAlignment(4);
            WizardBindings.bind((JTextField)this.dimmDownText, (ValueModel)this.dimmDownConverterModel, (boolean)true);
            label = FormsSetup.getComponentFactoryDefault().createLabel(Resources.getString(LightPortTableModel.class, (String)"dimmDown"));
            label.setToolTipText(Resources.getString(LightPortTableModel.class, (String)"dimmDown.tooltip"));
            dialogBuilder.add((Component)label).xy(1, row);
            dialogBuilder.add((Component)this.dimmDownText).xy(3, row);
            this.dimmDownText.setEnabled(port.isEnabled());
            order.add((JComponent)this.dimmDownText);
            ValidationComponentUtils.setMandatory((JComponent)this.dimmDownText, (boolean)true);
            ValidationComponentUtils.setMessageKeys((JComponent)this.dimmDownText, (Object[])new Object[]{"validation.dimmDown_key"});
            this.dimmDownSlider = new /* Unavailable Anonymous Inner Class!! */;
            this.dimmDownSlider.createComponent();
            WizardBindings.bind((SliderAndValuePanel)this.dimmDownSlider, (ValueModel)valueValueModel);
            this.dimmDownSlider.setEnabled(port.isEnabled());
            dialogBuilder.add((Component)this.dimmDownSlider).xyw(5, row, 5);
            order.add(this.dimmDownSlider.getSlider());
            dimm_8_8 = this.isPortConfigKeySupported((byte)68);
            this.dimmDownPcfg = (byte)(dimm_8_8 ? 68 : 4);
            valueValueModel.addValueChangeListener(evt -> {
                if (valueValueModel.getValue() instanceof Integer) {
                    int dimmDownValue = (Integer)valueValueModel.getValue();
                    LOGGER.info("The dimmDown value has been changed: {}", (Object)dimmDownValue);
                    this.getLocalPortConfigChangeEventSubject().onNext((Object)new PortConfigChangeEvent(null, 0L, (PortTypeAware)port, Byte.valueOf(dimm_8_8 ? (byte)68 : (byte)4), (PortConfigValue)(dimm_8_8 ? new Int16PortConfigValue(Integer.valueOf(ByteUtils.getWORD((int)dimmDownValue))) : new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)dimmDownValue))))));
                }
            });
            row += 2;
        }
        if (this.isPortConfigKeySupported((byte)-128)) {
            valueValueModel = this.getPresentationModel().getBufferedModel("rgbValue");
            this.rgbValueModel = new ConverterValueModel((ValueModel)valueValueModel, (BindingConverter)new ColorRGBToIntegerConverter());
            this.rgbColorComboBox = new ColorExComboBox();
            this.rgbColorComboBox.setConverterContext(ColorConverter.CONTEXT_RGB);
            this.rgbColorComboBox.setColorValueVisible(false);
            this.rgbColorComboBox.setEnabled(port.isEnabled());
            this.rgbColorComboBox.setSelectedColor((Color)this.rgbValueModel.getValue());
            this.rgbColorComboBox.addItemListener((ItemListener)new /* Unavailable Anonymous Inner Class!! */);
            this.rgbValueModel.addValueChangeListener(evt -> {
                LOGGER.info("Set the color: {}", evt.getNewValue());
                this.rgbColorComboBox.setSelectedColor((Color)evt.getNewValue());
            });
            this.rgbColorComboBox.setEnabled(port.isEnabled());
            dialogBuilder.add(Resources.getString(LightPortTableModel.class, (String)"rgbValue"), new Object[0]).xy(1, row);
            dialogBuilder.add((Component)this.rgbColorComboBox).xy(3, row);
            order.add((JComponent)this.rgbColorComboBox);
            ValidationComponentUtils.setMandatory((JComponent)this.rgbColorComboBox, (boolean)true);
            ValidationComponentUtils.setMessageKeys((JComponent)this.rgbColorComboBox, (Object[])new Object[]{"validation.rgbValue_key"});
            row += 2;
            valueValueModel.addValueChangeListener(evt -> {
                if (valueValueModel.getValue() instanceof Integer) {
                    int rgbValue = (Integer)valueValueModel.getValue();
                    LOGGER.info("The rgb value has been changed: {}", (Object)rgbValue);
                    this.getLocalPortConfigChangeEventSubject().onNext((Object)new PortConfigChangeEvent(null, 0L, (PortTypeAware)port, Byte.valueOf((byte)-128), (PortConfigValue)new RgbPortConfigValue(ByteUtils.getRGB((Integer)rgbValue))));
                }
            });
        }
        if (this.isPortConfigKeySupported(BidibLibrary.BIDIB_PCFG_TRANSITION_TIME)) {
            valueValueModel = this.getPresentationModel().getBufferedModel("transitionTime");
            this.transitionTimeConverterModel = new ConverterValueModel((ValueModel)valueValueModel, (BindingConverter)new StringToIntegerConverter());
            this.transitionTimeText = new HintTextField(() -> this.triggerValidation());
            IntegerInputValidationDocument transitionTimeDocument = new IntegerInputValidationDocument(3, "0123456789");
            transitionTimeDocument.setRangeValidationCallback((RangeValidationCallback)new DefaultRangeValidationCallback(0, 255, showHint -> this.transitionTimeText.showHint(showHint.booleanValue())));
            this.transitionTimeText.setDocument((Document)transitionTimeDocument);
            this.transitionTimeText.setColumns(2);
            this.transitionTimeText.setHorizontalAlignment(4);
            WizardBindings.bind((JTextField)this.transitionTimeText, (ValueModel)this.transitionTimeConverterModel, (boolean)true);
            this.transitionTimeText.setEnabled(port.isEnabled());
            dialogBuilder.add(Resources.getString(LightPortTableModel.class, (String)"transitionTime"), new Object[0]).xy(1, row);
            dialogBuilder.add((Component)this.transitionTimeText).xy(3, row);
            order.add((JComponent)this.transitionTimeText);
            ValidationComponentUtils.setMandatory((JComponent)this.transitionTimeText, (boolean)true);
            ValidationComponentUtils.setMessageKeys((JComponent)this.transitionTimeText, (Object[])new Object[]{"validation.transitionTime_key"});
            row += 2;
            valueValueModel.addValueChangeListener(evt -> {
                if (valueValueModel.getValue() instanceof Integer) {
                    int transitionTime = (Integer)valueValueModel.getValue();
                    LOGGER.info("The transitionTime value has been changed: {}", (Object)transitionTime);
                    this.getLocalPortConfigChangeEventSubject().onNext((Object)new PortConfigChangeEvent(null, 0L, (PortTypeAware)port, Byte.valueOf(BidibLibrary.BIDIB_PCFG_TRANSITION_TIME), (PortConfigValue)new Int16PortConfigValue(Integer.valueOf(transitionTime))));
                }
            });
        }
        if (this.isPortConfigKeySupported((byte)6)) {
            valueValueModel = this.getPresentationModel().getBufferedModel("dmxMapping");
            this.dmxMappingConverterModel = new ConverterValueModel((ValueModel)valueValueModel, (BindingConverter)new StringToDmxChannelConverter());
            this.dmxMappingText = new HintTextField(() -> this.triggerValidation());
            IntegerInputValidationDocument dmxMappingDocument = new IntegerInputValidationDocument(3, "0123456789");
            dmxMappingDocument.setRangeValidationCallback((RangeValidationCallback)new DefaultRangeValidationCallback(1, 255, showHint -> this.dmxMappingText.showHint(showHint.booleanValue())));
            this.dmxMappingText.setDocument((Document)dmxMappingDocument);
            this.dmxMappingText.setColumns(2);
            this.dmxMappingText.setHorizontalAlignment(4);
            WizardBindings.bind((JTextField)this.dmxMappingText, (ValueModel)this.dmxMappingConverterModel, (boolean)true);
            this.dmxMappingText.setEnabled(port.isEnabled());
            dialogBuilder.add(Resources.getString(LightPortTableModel.class, (String)"dmxMapping"), new Object[0]).xy(1, row);
            dialogBuilder.add((Component)this.dmxMappingText).xy(3, row);
            order.add((JComponent)this.dmxMappingText);
            ValidationComponentUtils.setMandatory((JComponent)this.dmxMappingText, (boolean)true);
            ValidationComponentUtils.setMessageKeys((JComponent)this.dmxMappingText, (Object[])new Object[]{"validation.dmxMapping_key"});
            valueValueModel.addValueChangeListener(evt -> {
                if (valueValueModel.getValue() instanceof Integer) {
                    int outputMap = (Integer)valueValueModel.getValue();
                    LOGGER.info("The outputMap value has been changed: {}", (Object)outputMap);
                    this.getLocalPortConfigChangeEventSubject().onNext((Object)new PortConfigChangeEvent(null, 0L, (PortTypeAware)port, Byte.valueOf((byte)6), (PortConfigValue)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)outputMap)))));
                }
            });
            row += 2;
        }
        AbstractValueModel selectionHolderPortStatus = this.getPresentationModel().getModel("status");
        ConverterValueModel portStatusConverterModel = new ConverterValueModel((ValueModel)selectionHolderPortStatus, (BindingConverter)new PortStatusToStringConverter(LightPortStatus.class, "status."));
        this.statusLabel = WizardComponentFactory.createLabel((ValueModel)portStatusConverterModel);
        this.statusLabel.setEnabled(port.isEnabled());
        SelectionInList portStatusSelection = new SelectionInList((Object[])LightPortStatus.ON.getValues());
        ValueHolder portStatusHolder = new ValueHolder(selectionHolderPortStatus.getValue());
        ComboBoxAdapter comboBoxAdapterPortStatus = new ComboBoxAdapter((ListModel)portStatusSelection, (ValueModel)portStatusHolder);
        this.comboPortStatus = new JComboBox();
        this.comboPortStatus.setRenderer(new BidibStatusListRenderer(LightPortStatus.class));
        this.comboPortStatus.setModel(comboBoxAdapterPortStatus);
        LightPortStatus oppositeStatus = (LightPortStatus)PortUtils.getOppositeStatus((BidibStatus)((LightPortStatus)selectionHolderPortStatus.getValue()));
        LOGGER.debug("Set the opposite status in the port status selection: {}", (Object)oppositeStatus);
        this.comboPortStatus.setSelectedItem(oppositeStatus);
        this.btnPortStatus = new JButton(Resources.getString(LightPortTableModel.class, (String)"test"));
        this.btnPortStatus.addActionListener(arg_0 -> this.lambda$doCreateComponent$20((ValueModel)portStatusHolder, arg_0));
        Disposable disp = this.statusEventSubject.throttleLatest(80L, TimeUnit.MILLISECONDS, (Scheduler)SwingScheduler.getInstance(), true).subscribe(portStatus -> this.sendStatusToPort(port, portStatus));
        this.getCompDisp().add(disp);
        dialogBuilder.add(Resources.getString(LightPortTableModel.class, (String)"status") + ":", new Object[0]).xy(1, row);
        dialogBuilder.add((Component)this.statusLabel).xy(3, row);
        dialogBuilder.add((Component)this.comboPortStatus).xy(5, row);
        dialogBuilder.add((Component)this.btnPortStatus).xy(7, row);
        order.add(this.comboPortStatus);
        order.add(this.btnPortStatus);
        JPanel buttonPanel = this.createButtonPanel();
        dialogBuilder.add((Component)buttonPanel).xyw(1, row += 2, 5);
        this.addButtons(buttonPanel, order);
        Disposable dispLocalPortConfigChange = this.getLocalPortConfigChangeEventSubject().buffer(100L, TimeUnit.MILLISECONDS, (Scheduler)SwingScheduler.getInstance()).subscribe(evts -> {
            PortConfigChangeEvent event = null;
            for (PortConfigChangeEvent evt : evts) {
                LOGGER.info("Process event: {}", (Object)evt);
                if (event == null) {
                    event = evt;
                    continue;
                }
                event.getPortConfig().putAll(evt.getPortConfig());
            }
            if (event != null) {
                LOGGER.info("Publish the config change event to the node: {}", event);
                this.getPortConfigChangeEventSubject().onNext(event);
            }
        }, err -> LOGGER.warn("The localPortConfigChangeEventSubject has received an error.", err), () -> LOGGER.info("The localPortConfigChangeEventSubject has completed."));
        this.getCompDisp().add(dispLocalPortConfigChange);
        if (this.getValidationResultModel() != null) {
            LOGGER.debug("Create iconfeedback panel.");
            IconFeedbackPanel cvIconPanel = new IconFeedbackPanel((ValidationResultModel)this.getValidationResultModel(), (JComponent)dialogBuilder.build());
            AbstractPortEditorPanel.PortEditorPanelContainer panel2 = new AbstractPortEditorPanel.PortEditorPanelContainer((PortEditorPanelCallback)this);
            FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]).panel((JPanel)panel2);
            feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
            this.setPanel(feedbackBuilder.build());
        } else {
            this.setPanel(dialogBuilder.build());
        }
        bufferedPortNameModel.addValueChangeListener(evt -> this.triggerValidation());
        if (this.portLevelOffConverterModel != null) {
            this.portLevelOffConverterModel.addValueChangeListener(evt -> this.triggerValidation());
        }
        if (this.portLevelOnConverterModel != null) {
            this.portLevelOnConverterModel.addValueChangeListener(evt -> this.triggerValidation());
        }
        if (this.dimmDownConverterModel != null) {
            this.dimmDownConverterModel.addValueChangeListener(evt -> this.triggerValidation());
        }
        if (this.dimmUpConverterModel != null) {
            this.dimmUpConverterModel.addValueChangeListener(evt -> this.triggerValidation());
        }
        if (this.rgbValueModel != null) {
            this.rgbValueModel.addValueChangeListener(evt -> this.triggerValidation());
        }
        if (this.transitionTimeConverterModel != null) {
            this.transitionTimeConverterModel.addValueChangeListener(evt -> this.triggerValidation());
        }
        if (this.dmxMappingConverterModel != null) {
            this.dmxMappingConverterModel.addValueChangeListener(evt -> this.triggerValidation());
        }
        this.enableComponents();
        this.triggerValidation();
        this.getPanel().setFocusCycleRoot(true);
        this.getPanel().setFocusTraversalPolicy(this.createFocusTransversalPolicy(order));
        return this.getPanel();
    }

    public void requestDefaultFocus() {
        this.portName.requestFocusInWindow();
    }

    protected void propertyChanged(PropertyChangeEvent evt) {
        LOGGER.info("The port property has been changed, propertyName: {}, new value: {}", (Object)evt.getPropertyName(), evt.getNewValue());
        super.propertyChanged(evt);
        SwingUtilities.invokeLater(() -> {
            try {
                switch (evt.getPropertyName()) {
                    case "status": 
                    case "portStatus": {
                        this.updatePortStatusFromOriginalPort();
                        break;
                    }
                    case "portConfigChanged": {
                        break;
                    }
                    case "portTypeChanged": {
                        LOGGER.info("The port type has changed: {}", evt.getNewValue());
                        if (((LightPort)this.getOriginalPort()).getPortType() != LcOutputType.LIGHTPORT) break;
                        LOGGER.info("Current port type is LIGHTPORT.");
                        this.updatePortStatusFromOriginalPort();
                        this.enableComponents();
                        break;
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Update the status failed.", (Throwable)ex);
            }
        });
    }

    private void updatePortStatusFromOriginalPort() {
        AbstractValueModel selectionHolderPortStatus = this.getPresentationModel().getModel("status");
        LightPortStatus status = (LightPortStatus)((LightPort)this.getOriginalPort()).getStatus();
        LOGGER.info("Current status of original port: {}", (Object)status);
        selectionHolderPortStatus.setValue((Object)status);
        if (this.comboPortStatus != null) {
            LightPortStatus oppositeStatus = (LightPortStatus)PortUtils.getOppositeStatus((BidibStatus)((LightPortStatus)selectionHolderPortStatus.getValue()));
            LOGGER.info("Set the opposite status in the port status selection: {}", (Object)oppositeStatus);
            this.comboPortStatus.setSelectedItem(oppositeStatus);
        }
    }

    protected ValidationResult validate(LightPort port) {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.getPresentationModel(), "validation");
        if (this.portLevelOffConverterModel != null && this.portLevelOffConverterModel.getValue() == null) {
            support.addError("portLevelOff_key", "not_empty_for_write");
        } else if (this.portLevelOffText != null && this.portLevelOffText.isShowHint()) {
            support.add(Severity.INFO, "portLevelOff_key", "validRange;0..255");
        }
        if (this.portLevelOnConverterModel != null && this.portLevelOnConverterModel.getValue() == null) {
            support.addError("portLevelOn_key", "not_empty_for_write");
        } else if (this.portLevelOnText != null && this.portLevelOnText.isShowHint()) {
            support.add(Severity.INFO, "portLevelOn_key", "validRange;0..255");
        }
        if (this.dimmDownConverterModel != null && this.dimmDownConverterModel.getValue() == null) {
            support.addError("dimmDown_key", "not_empty_for_write");
        } else if (this.dimmDownText != null && this.dimmDownText.isShowHint()) {
            support.add(Severity.INFO, "dimmDown_key", "validRange;0.." + this.dimmDownText.getMaxRange());
        }
        if (this.dimmUpConverterModel != null && this.dimmUpConverterModel.getValue() == null) {
            support.addError("dimmUp_key", "not_empty_for_write");
        } else if (this.dimmUpText != null && this.dimmUpText.isShowHint()) {
            support.add(Severity.INFO, "dimmUp_key", "validRange;0.." + this.dimmUpText.getMaxRange());
        }
        if (this.rgbValueModel != null && this.rgbValueModel.getValue() == null) {
            support.addError("rgbValue_key", "not_empty_for_write");
        }
        if (this.transitionTimeConverterModel != null && this.transitionTimeConverterModel.getValue() == null) {
            support.addError("transitionTime_key", "not_empty_for_write");
        } else if (this.transitionTimeText != null && this.transitionTimeText.isShowHint()) {
            support.add(Severity.INFO, "transitionTime_key", "validRange;0..255");
        }
        if (this.dmxMappingConverterModel != null && this.dmxMappingConverterModel.getValue() == null) {
            support.addError("dmxMapping_key", "not_empty_for_write");
        } else if (this.dmxMappingText != null && this.dmxMappingText.isShowHint()) {
            support.add(Severity.INFO, "dmxMapping_key", "validRange;1..255");
        }
        ValidationResult validationResult = support.getResult();
        return validationResult;
    }

    private void sendStatusToPort(LightPort port, LightPortStatus portStatus) {
        LOGGER.info("Send the new portStatus to the port: {}", (Object)portStatus);
        this.triggerValidation();
        LightPort lightPort = (LightPort)LightPort.builder().withStatus((BidibStatus)portStatus).withId(port.getId()).build();
        this.getValueCallback().accept(lightPort);
    }

    protected void doEnableComponents(LightPort port) {
        boolean enabled = port.isEnabled();
        this.portName.setEnabled(enabled);
        if (this.portLevelOffText != null) {
            this.portLevelOffText.setEnabled(port.isEnabled() && port.isPortConfigKeySupported(Byte.valueOf((byte)2)));
        }
        if (this.portLevelOffSlider != null) {
            this.portLevelOffSlider.setEnabled(port.isEnabled() && port.isPortConfigKeySupported(Byte.valueOf((byte)2)));
        }
        if (this.portLevelOnText != null) {
            this.portLevelOnText.setEnabled(port.isEnabled() && port.isPortConfigKeySupported(Byte.valueOf((byte)1)));
        }
        if (this.portLevelOnSlider != null) {
            this.portLevelOnSlider.setEnabled(port.isEnabled() && port.isPortConfigKeySupported(Byte.valueOf((byte)1)));
        }
        if (this.dimmDownSlider != null) {
            this.dimmDownSlider.setEnabled(port.isEnabled() && port.isPortConfigKeySupported(Byte.valueOf(this.dimmDownPcfg)));
        }
        if (this.dimmDownText != null) {
            this.dimmDownText.setEnabled(port.isEnabled() && port.isPortConfigKeySupported(Byte.valueOf(this.dimmDownPcfg)));
        }
        if (this.dimmUpSlider != null) {
            this.dimmUpSlider.setEnabled(port.isEnabled() && port.isPortConfigKeySupported(Byte.valueOf(this.dimmUpPcfg)));
        }
        if (this.dimmUpText != null) {
            this.dimmUpText.setEnabled(port.isEnabled() && port.isPortConfigKeySupported(Byte.valueOf(this.dimmDownPcfg)));
        }
        if (this.transitionTimeText != null) {
            this.transitionTimeText.setEnabled(port.isEnabled() && port.isPortConfigKeySupported(Byte.valueOf(BidibLibrary.BIDIB_PCFG_TRANSITION_TIME)));
        }
        if (this.statusLabel != null) {
            this.statusLabel.setEnabled(port.isEnabled());
        }
        if (this.comboPortStatus != null) {
            this.comboPortStatus.setEnabled(port.isEnabled());
        }
        if (this.btnPortStatus != null) {
            this.btnPortStatus.setEnabled(port.isEnabled());
        }
        if (this.rgbColorComboBox != null) {
            this.rgbColorComboBox.setEnabled(port.isEnabled() && port.isPortConfigKeySupported(Byte.valueOf((byte)-128)));
        }
        super.doEnableComponents((Port)port);
    }

    private /* synthetic */ void lambda$doCreateComponent$20(ValueModel portStatusHolder, ActionEvent evt) {
        LightPortStatus portStatus = (LightPortStatus)portStatusHolder.getValue();
        LOGGER.info("The port status has been changed: {}", (Object)portStatus);
        this.statusEventSubject.onNext((Object)portStatus);
    }
}

