/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.ping.model;

import com.jgoodies.binding.beans.Model;
import java.beans.PropertyChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.mvc.ping.model.NodePingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodePingModel
extends Model {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodePingModel.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_NODE_PING_STATUS = "nodePingStatus";
    public static final String PROPERTY_PING_INTERVAL = "pingInterval";
    public static final String PROPERTY_LAST_PING_TIMESTAMP = "lastPingTimestamp";
    public static final String PROPERTY_LAST_PONG_MARKER = "lastPongMarker";
    public static final String PROPERTY_NODE_LABEL = "nodeLabel";
    public static final String PROPERTY_ADDITIONAL_FILL_BYTES_COUNT = "additionalFillBytesCount";
    public static final String PROPERTY_ADDITIONAL_TOTAL_BYTES_COUNT = "additionalTotalBytesCount";
    public static final String PROPERTY_ADDITIONAL_PAYLOAD_START_VALUE = "additionalPayloadStartValue";
    public static final String PROPERTY_IDENTIFY_PROCESSING_WAIT_DURATION = "identifyProcessingWaitDuration";
    private final NodeInterface node;
    private String nodeLabel;
    private NodePingState nodePingState;
    private Integer pingInterval;
    private long lastPingTimestamp;
    private int lastPongMarker = -1;
    private int data;
    private int additionalFillBytesCount;
    private int additionalTotalBytesCount;
    private int additionalPayloadStartValue = 176;
    private byte[] additionalPayload;
    private int identifyProcessingWaitDuration;
    private PropertyChangeListener propertyChangeListener;
    private final Object preparePayloadLock = new Object();

    public NodePingModel(NodeInterface node) {
        this.node = node;
        LOGGER.info("Create new NodePingModel for node: {}", (Object)node);
    }

    public void registerNode() {
        this.propertyChangeListener = new /* Unavailable Anonymous Inner Class!! */;
        this.node.addPropertyChangeListener("label", this.propertyChangeListener);
        this.node.addPropertyChangeListener("node.userName", this.propertyChangeListener);
    }

    public void freeNode() {
        this.node.removePropertyChangeListener("label", this.propertyChangeListener);
        this.node.removePropertyChangeListener("node.userName", this.propertyChangeListener);
    }

    public NodeInterface getNode() {
        return this.node;
    }

    public NodePingState getNodePingState() {
        return this.nodePingState;
    }

    public void setNodePingState(NodePingState nodePingState) {
        NodePingState oldValue = this.nodePingState;
        this.nodePingState = nodePingState;
        this.firePropertyChange(PROPERTY_NODE_PING_STATUS, (Object)oldValue, (Object)this.nodePingState);
    }

    public void setNodeLabel(String nodeLabel) {
        String oldValue = this.nodeLabel;
        this.nodeLabel = nodeLabel;
        this.firePropertyChange(PROPERTY_NODE_LABEL, (Object)oldValue, (Object)this.nodeLabel);
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public Integer getPingInterval() {
        return this.pingInterval;
    }

    public void setPingInterval(Integer pingInterval) {
        Integer oldValue = this.pingInterval;
        this.pingInterval = pingInterval;
        this.firePropertyChange(PROPERTY_PING_INTERVAL, (Object)oldValue, (Object)this.pingInterval);
    }

    public long getLastPingTimestamp() {
        return this.lastPingTimestamp;
    }

    public void setLastPingTimestamp(long lastPingTimestamp) {
        long oldValue = this.lastPingTimestamp;
        this.lastPingTimestamp = lastPingTimestamp;
        SwingUtils.executeInEDT(() -> this.firePropertyChange(PROPERTY_LAST_PING_TIMESTAMP, oldValue, this.lastPingTimestamp));
    }

    public int getLastPongMarker() {
        return this.lastPongMarker;
    }

    public void setLastPongMarker(int lastPongMarker) {
        int oldValue = this.lastPongMarker;
        this.lastPongMarker = lastPongMarker;
        SwingUtils.executeInEDT(() -> this.firePropertyChange(PROPERTY_LAST_PONG_MARKER, oldValue, this.lastPongMarker));
    }

    public int getAdditionalFillBytesCount() {
        return this.additionalFillBytesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdditionalFillBytesCount(int additionalFillBytesCount) {
        int oldValue = this.additionalFillBytesCount;
        this.additionalFillBytesCount = additionalFillBytesCount;
        Object object = this.preparePayloadLock;
        synchronized (object) {
            this.prepareAdditionalPayload(this.additionalTotalBytesCount, this.additionalFillBytesCount);
        }
        this.firePropertyChange(PROPERTY_ADDITIONAL_FILL_BYTES_COUNT, oldValue, this.additionalFillBytesCount);
    }

    private void prepareAdditionalPayload(int additionalTotalBytesCount, int additionalFillBytesCount) {
        if (additionalTotalBytesCount > 0 && additionalFillBytesCount == 0) {
            additionalFillBytesCount = 16;
        }
        if (additionalFillBytesCount > 0) {
            this.additionalPayload = new byte[additionalFillBytesCount];
            for (int index = 0; index < additionalFillBytesCount; ++index) {
                this.additionalPayload[index] = (byte)(this.additionalPayloadStartValue + index & 0xFF);
            }
        } else {
            this.additionalPayload = null;
        }
    }

    public int getAdditionalTotalBytesCount() {
        return this.additionalTotalBytesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdditionalTotalBytesCount(int additionalTotalBytesCount) {
        int oldValue = this.additionalTotalBytesCount;
        this.additionalTotalBytesCount = additionalTotalBytesCount;
        Object object = this.preparePayloadLock;
        synchronized (object) {
            this.prepareAdditionalPayload(this.additionalTotalBytesCount, this.additionalFillBytesCount);
        }
        this.firePropertyChange(PROPERTY_ADDITIONAL_TOTAL_BYTES_COUNT, oldValue, this.additionalTotalBytesCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdditionalPayloadStartValue(int additionalPayloadStartValue) {
        int oldValue = this.additionalPayloadStartValue;
        this.additionalPayloadStartValue = additionalPayloadStartValue;
        if (oldValue != additionalPayloadStartValue) {
            Object object = this.preparePayloadLock;
            synchronized (object) {
                this.prepareAdditionalPayload(this.additionalTotalBytesCount, this.additionalFillBytesCount);
            }
        }
        this.firePropertyChange(PROPERTY_ADDITIONAL_PAYLOAD_START_VALUE, oldValue, this.additionalPayloadStartValue);
    }

    public int getAdditionalPayloadStartValue() {
        return this.additionalPayloadStartValue;
    }

    public void setData(int data) {
        this.data = data;
    }

    public int getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getNextIncData() {
        int data = ++this.data;
        LOGGER.info("Next inc data: {} .. {}", (Object)this.data, (Object)data);
        if (data > 255) {
            this.data = data = 0;
            LOGGER.info("Adjusted data: {}", (Object)this.data);
        }
        Object object = this.preparePayloadLock;
        synchronized (object) {
            if (this.additionalPayload == null) {
                return new byte[]{(byte)(data & 0xFF)};
            }
            return ByteUtils.prepend((byte)((byte)(data & 0xFF)), (byte[])this.additionalPayload);
        }
    }

    public int getIdentifyProcessingWaitDuration() {
        return this.identifyProcessingWaitDuration;
    }

    public void setIdentifyProcessingWaitDuration(int identifyProcessingWaitDuration) {
        int oldValue = this.identifyProcessingWaitDuration;
        this.identifyProcessingWaitDuration = identifyProcessingWaitDuration;
        this.firePropertyChange(PROPERTY_IDENTIFY_PROCESSING_WAIT_DURATION, oldValue, this.identifyProcessingWaitDuration);
    }

    public boolean equals(Object obj) {
        NodePingModel other;
        return obj instanceof NodePingModel && this.node.equals((other = (NodePingModel)obj).getNode());
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String prepareNodeLabel() {
        String productString;
        String nodeLabel = this.node.getLabel();
        if (StringUtils.isBlank((CharSequence)nodeLabel) && StringUtils.isNotBlank((CharSequence)(productString = this.node.getNode().getStoredString(0)))) {
            nodeLabel = productString;
        }
        return nodeLabel;
    }

    public String toString() {
        return this.node.toString();
    }
}

