package org.bidib.wizard.mvc.netdebug.model;

import javax.swing.SwingUtilities;

import org.bidib.jbidibc.netbidib.client.NetBidibClient;

import com.jgoodies.binding.beans.Model;

public class NetDebugModel extends Model {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_SELECTED_HOST = "selectedHost";

    public static final String PROPERTY_SELECTED_PORT = "selectedPort";

    public static final String PROPERTY_CONNECTED = "connected";

    public static final String PROPERTY_DISCONNECTED = "disconnected";

    public static final String PROPERTY_TRANSFER_IN_PROGRESS = "transferInProgress";

    public static final String PROPERTY_TRANSMIT_ENABLED = "transmitEnabled";

    public static final String PROPERTY_SEND_TEXT = "sendText";

    private String selectedHost = "localhost";

    private Integer selectedPort = NetBidibClient.NET_BIDIB_PORT_NUMBER;

    private boolean connected;

    private boolean transferInProgress;

    private String sendText;

    public NetDebugModel() {

    }

    /**
     * @return the selectedHost
     */
    public String getSelectedHost() {
        return selectedHost;
    }

    /**
     * @param selectedHost
     *            the selectedHost to set
     */
    public void setSelectedHost(String selectedHost) {
        String oldValue = this.selectedHost;
        this.selectedHost = selectedHost;

        firePropertyChange(PROPERTY_SELECTED_HOST, oldValue, selectedHost);
    }

    /**
     * @return the selectedPort
     */
    public Integer getSelectedPort() {
        return selectedPort;
    }

    /**
     * @param selectedPort
     *            the selectedPort to set
     */
    public void setSelectedPort(Integer selectedPort) {
        Integer oldValue = this.selectedPort;
        this.selectedPort = selectedPort;

        firePropertyChange(PROPERTY_SELECTED_PORT, oldValue, selectedPort);
    }

    /**
     * @return the connected
     */
    public boolean isConnected() {
        return connected;
    }

    /**
     * @param connected
     *            the connected to set
     */
    public void setConnected(boolean connected) {
        boolean oldTransmitEnabled = isTransmitEnabled();
        boolean oldValue = this.connected;
        this.connected = connected;

        if (SwingUtilities.isEventDispatchThread()) {
            firePropertyChange(PROPERTY_CONNECTED, oldValue, connected);
            firePropertyChange(PROPERTY_DISCONNECTED, !oldValue, !connected);
            firePropertyChange(PROPERTY_TRANSMIT_ENABLED, oldTransmitEnabled, isTransmitEnabled());
        }
        else {
            SwingUtilities.invokeLater(() -> {
                firePropertyChange(PROPERTY_CONNECTED, oldValue, connected);
                firePropertyChange(PROPERTY_DISCONNECTED, !oldValue, !connected);
                firePropertyChange(PROPERTY_TRANSMIT_ENABLED, oldTransmitEnabled, isTransmitEnabled());
            });
        }
    }

    /**
     * @return the disconnected state
     */
    public boolean isDisconnected() {
        return !connected;
    }

    /**
     * @param disconnected
     *            the connected to set
     */
    public void setDisconnected(boolean disconnected) {
        setConnected(!disconnected);
    }

    /**
     * @return the transferInProgress
     */
    public boolean isTransferInProgress() {
        return transferInProgress;
    }

    /**
     * @param transferInProgress
     *            the transferInProgress to set
     */
    public void setTransferInProgress(boolean transferInProgress) {
        boolean oldTransmitEnabled = isTransmitEnabled();
        boolean oldValue = this.transferInProgress;
        this.transferInProgress = transferInProgress;

        if (SwingUtilities.isEventDispatchThread()) {
            firePropertyChange(PROPERTY_TRANSFER_IN_PROGRESS, oldValue, transferInProgress);
            firePropertyChange(PROPERTY_TRANSMIT_ENABLED, oldTransmitEnabled, isTransmitEnabled());
        }
        else {
            SwingUtilities.invokeLater(() -> {
                firePropertyChange(PROPERTY_TRANSFER_IN_PROGRESS, oldValue, transferInProgress);
                firePropertyChange(PROPERTY_TRANSMIT_ENABLED, oldTransmitEnabled, isTransmitEnabled());
            });
        }
    }

    public boolean isTransmitEnabled() {
        return isConnected() && !isTransferInProgress();
    }

    /**
     * @return the sendText
     */
    public String getSendText() {
        return sendText;
    }

    /**
     * @param sendText
     *            the sendText to set
     */
    public void setSendText(String sendText) {
        String oldValue = this.sendText;
        this.sendText = sendText;
        firePropertyChange(PROPERTY_SEND_TEXT, oldValue, sendText);
    }

}
