package org.bidib.wizard.mvc.preferences.view.panel;

import org.bidib.wizard.mvc.preferences.model.PairingStoreEntryModel;

import com.jgoodies.binding.adapter.AbstractTableAdapter;
import com.jgoodies.binding.list.SelectionInList;

public class PairingStoreTableModel extends AbstractTableAdapter<PairingStoreEntryModel> {

    private static final long serialVersionUID = 1L;

    private static final int COLUMN_UID = 0;

    private static final int COLUMN_REQUESTOR = 1;

    private static final int COLUMN_PRODUCT_NAME = 2;

    private static final int COLUMN_USER_NAME = 3;

    private static final int COLUMN_PROTOCOL_VERSION = 4;

    private static final int COLUMN_PAIRED = 5;

    private static final int COLUMN_LASTSEEN = 6;

    public PairingStoreTableModel(final SelectionInList<PairingStoreEntryModel> pairingSelection,
        String... columnNames) {
        super(pairingSelection, columnNames);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {

        PairingStoreEntryModel pairing = getRow(rowIndex);

        switch (columnIndex) {
            case COLUMN_UID:
                return pairing.getUid();
            case COLUMN_REQUESTOR:
                return pairing.getRequestorName();
            case COLUMN_PRODUCT_NAME:
                return pairing.getProductName();
            case COLUMN_USER_NAME:
                return pairing.getUserName();
            case COLUMN_PROTOCOL_VERSION:
                return pairing.getProtocolVersion();
            case COLUMN_PAIRED:
                return pairing.isPaired();
            case COLUMN_LASTSEEN:
                return pairing.getLastSeen();
            default:
                break;
        }

        return null;
    }

}
