package org.bidib.wizard.mvc.main.view.exchange;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;

import org.assertj.core.api.Assertions;
import org.bidib.jbidibc.core.schema.BidibFactory;
import org.bidib.jbidibc.core.schema.bidib2.BiDiB;
import org.bidib.jbidibc.core.schema.bidib2.ConfigurationVariable;
import org.bidib.wizard.utils.NodeUtilsTest;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeExchangeHelperTest {

    private static final Logger LOGGER = LoggerFactory.getLogger(NodeExchangeHelperTest.class);

    @Test
    void transformOneDmxToV2() throws URISyntaxException, FileNotFoundException {

        URL urlTarget = NodeUtilsTest.class.getResource("/nodes/OnDMX_760051EB_197973245_20240117_090108.nodex");
        File bidibFile = new File(urlTarget.toURI());
        final BiDiB bidib = BidibFactory.loadBiDiBFile(bidibFile);

        final org.bidib.jbidibc.core.schema.bidib2.Node importNode = bidib.getNodes().getNode().get(0);
        LOGGER.info("Transform the bidib instance, schemaNode: {}", importNode.getProductName());

        final List<ConfigurationVariable> configurationVariables =
            importNode.getConfigurationVariables().getConfigurationVariable();
        int sourceCvCount = configurationVariables.size();
        LOGGER.info("Number of CV in source: {}", sourceCvCount);

        final NodeExchangeHelper helper = new NodeExchangeHelper();
        helper.transformOneDmxToV2(importNode);

        final List<ConfigurationVariable> configurationVariablesAfterTransformation =
            importNode.getConfigurationVariables().getConfigurationVariable();
        int targetCvCount = configurationVariablesAfterTransformation.size();
        LOGGER.info("Number of CV in target: {}, source: {}", targetCvCount, sourceCvCount);

        Assertions.assertThat(sourceCvCount).isEqualTo(targetCvCount);
    }

    @Test
    void transformOneDmxToV2With2ConfiguredDimmers() throws URISyntaxException, FileNotFoundException {

        URL urlTarget = NodeUtilsTest.class.getResource("/nodes/OnDMX_760051EB_1_02_72_2.nodex");
        File bidibFile = new File(urlTarget.toURI());
        final BiDiB bidib = BidibFactory.loadBiDiBFile(bidibFile);

        final org.bidib.jbidibc.core.schema.bidib2.Node importNode = bidib.getNodes().getNode().get(0);
        LOGGER.info("Transform the bidib instance, schemaNode: {}", importNode.getProductName());

        final List<ConfigurationVariable> configurationVariables =
            importNode.getConfigurationVariables().getConfigurationVariable();
        int sourceCvCount = configurationVariables.size();
        LOGGER.info("Number of CV in source: {}", sourceCvCount);

        final NodeExchangeHelper helper = new NodeExchangeHelper();
        helper.transformOneDmxToV2(importNode);

        final List<ConfigurationVariable> configurationVariablesAfterTransformation =
            importNode.getConfigurationVariables().getConfigurationVariable();
        int targetCvCount = configurationVariablesAfterTransformation.size();
        LOGGER.info("Number of CV in target: {}, source: {}", targetCvCount, sourceCvCount);

        Assertions.assertThat(sourceCvCount).isEqualTo(targetCvCount);
    }
}
