/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.logger.view;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.core.logger.BidibLogsAppender;
import org.bidib.wizard.mvc.common.view.text.CopyAllAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogsPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogsPane.class);
    private final JScrollPane logsPane;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private final JTextArea logsArea;
    private BidibLogsAppender bidibAppender;
    private Disposable loggingDisposable;
    private final JPopupMenu popupMenu;
    private JCheckBoxMenuItem autoScrollsItem;
    private JMenuItem clearItem;

    public LogsPane() {
        this.logsPane = new /* Unavailable Anonymous Inner Class!! */;
        this.logsArea = new /* Unavailable Anonymous Inner Class!! */;
        this.logsArea.setEditable(false);
        this.logsArea.setFont(new Font("Monospaced", 0, 11));
        this.logsPane.getViewport().add((Component)this.logsArea, null);
        this.addObserverToBidibLogAppender();
        this.logsPane.setAutoscrolls(true);
        this.popupMenu = new /* Unavailable Anonymous Inner Class!! */;
        this.prepareMenuItems(this.popupMenu);
        this.logsArea.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void prepareMenuItems(JPopupMenu menu) {
        this.autoScrollsItem = new JCheckBoxMenuItem(Resources.getString(this.getClass(), (String)"autoScrolls"));
        this.autoScrollsItem.setSelected(true);
        this.autoScrollsItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem((Object)menu, (JMenuItem)this.autoScrollsItem);
        this.clearItem = new JMenuItem(Resources.getString(this.getClass(), (String)"clear"));
        this.clearItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem((Object)menu, this.clearItem);
        JMenuItem copyAllToClipboard = new JMenuItem(Resources.getString(this.getClass(), (String)"copyAllToClipboard"));
        copyAllToClipboard.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem((Object)menu, copyAllToClipboard);
    }

    private void addMenuItem(Object menu, JMenuItem menuItem) {
        if (menu instanceof JMenu) {
            ((JMenu)menu).add(menuItem);
        } else if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).add(menuItem);
        }
    }

    private void fireCopyAllToClipboard() {
        LOGGER.info("Copy all content to clipboard.");
        ActionEvent copyAll = new ActionEvent(this.logsArea, 0, "copy-all-to-clipboard");
        CopyAllAction action = new CopyAllAction();
        action.actionPerformed(copyAll);
    }

    public JScrollPane get() {
        return this.logsPane;
    }

    private void addObserverToBidibLogAppender() {
        String appenderName = "BidibLogsAppender";
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (Logger logger : context.getLoggerList()) {
            Appender appender = ((AppenderAttachable)logger).getAppender(appenderName);
            if (!(appender instanceof BidibLogsAppender)) continue;
            this.bidibAppender = (BidibLogsAppender)appender;
            break;
        }
        if (this.bidibAppender == null) {
            LoggerFactory.getLogger(LogsPane.class).error("Can't find appender with name: {}", (Object)appenderName);
        } else {
            this.loggingDisposable = this.bidibAppender.getLoggingSubject().subscribe(le -> this.publishLoggingEvent(le));
        }
    }

    protected void publishLoggingEvent(ILoggingEvent log) {
        SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void close() {
        if (this.bidibAppender != null) {
            LOGGER.info("Remove observer from appender.");
            try {
                this.loggingDisposable.dispose();
                this.loggingDisposable = null;
            }
            catch (Exception ex) {
                LOGGER.warn("Remove observer from appender failed.", (Throwable)ex);
            }
            this.bidibAppender = null;
        }
    }
}

