/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jgoodies.forms.FormsSetup;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideToggleButton;
import eu.hansolo.steelseries.gauges.Radial1Vertical;
import eu.hansolo.steelseries.tools.Section;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.BoosterNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.model.status.BoosterStatus;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.listener.StatusListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoosterPanel
implements TabVisibilityProvider,
TabPanelProvider,
TabComponentCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterPanel.class);
    private static final String ENCODED_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:50dlu:grow";
    private Collection<StatusListener> statusListeners = new LinkedList();
    private final JPanel contentPanel;
    private final MainModel mainModel;
    private Radial1Vertical ampereMeter;
    private Radial1Vertical thermoMeter;
    private Radial1Vertical voltMeter;
    private final JideToggleButton boosterStatusButton;
    private final JTextField boosterStatusText;
    private final JideSplitButton commandStationStatusButton;
    private final JTextField commandStationStatusText;
    private NodeInterface selectedNode;
    private final ImageIcon iconBoosterOn;
    private final ImageIcon iconBoosterOff;
    private TimeSeries series;
    private JFreeChart chart;
    private DisabledPanel disabledChartPanel;
    private int maximumItemCount = 500;
    private JLabel boosterStatusLabel;
    private ValueMarker maxBoosterCurrentMarker;
    private int DEFAULT_MAXCURRENT_LIMIT = 4000;

    public BoosterPanel(MainModel model) {
        this.mainModel = model;
        this.iconBoosterOff = ImageUtils.createImageIcon(BoosterPanel.class, (String)"/icons/booster/boosterOff_00.png");
        this.iconBoosterOn = ImageUtils.createImageIcon(BoosterPanel.class, (String)"/icons/booster/boosterOn_80.png");
        this.boosterStatusButton = this.createBoosterStatusButton();
        this.boosterStatusText = this.addStatusText();
        this.boosterStatusText.setToolTipText(Resources.getString(BoosterPanel.class, (String)"booster-status-tooltip"));
        this.commandStationStatusButton = this.createCommandStationStatusButton();
        this.setStatusButtonState(this.commandStationStatusButton, CommandStationStatus.OFF);
        this.commandStationStatusText = new JTextField(20);
        this.commandStationStatusText.setEditable(false);
        this.commandStationStatusText.setToolTipText(Resources.getString(BoosterPanel.class, (String)"cs-status-tooltip"));
        boolean debugDialog = false;
        Object panel = debugDialog ? new /* Unavailable Anonymous Inner Class!! */ : new /* Unavailable Anonymous Inner Class!! */;
        FormBuilder dialogBuilder = FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows("p", new Object[0]).panel((JPanel)panel);
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.contentPanel = new /* Unavailable Anonymous Inner Class!! */;
        SwingUtilities.invokeLater(() -> {
            LOGGER.info("Create the meter for current, temp and voltage.");
            this.ampereMeter = this.addAmpereMeter();
            this.thermoMeter = this.addThermoMeter();
            this.voltMeter = this.addVoltMeter();
            dialogBuilder.add(Resources.getString(BoosterPanel.class, (String)"cs"), new Object[0]).xy(1, 1);
            dialogBuilder.add((Component)this.commandStationStatusText).xy(3, 1);
            dialogBuilder.add((Component)this.commandStationStatusButton).xy(5, 1);
            this.boosterStatusLabel = DefaultComponentFactory.getInstance().createLabel(Resources.getString(BoosterPanel.class, (String)"booster"));
            dialogBuilder.add((Component)this.boosterStatusLabel).xy(7, 1);
            dialogBuilder.add((Component)this.boosterStatusText).xy(9, 1);
            dialogBuilder.add((Component)this.boosterStatusButton).xy(11, 1);
            dialogBuilder.appendRows("5dlu", new Object[0]);
            dialogBuilder.appendRows("fill:150dlu:none", new Object[0]);
            LOGGER.info("Prepare the meter panel for current, temp and voltage.");
            JPanel meterPanel = new JPanel();
            meterPanel.setLayout(new BoxLayout(meterPanel, 2));
            meterPanel.add((Component)this.ampereMeter);
            meterPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            meterPanel.add((Component)this.thermoMeter);
            meterPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            meterPanel.add((Component)this.voltMeter);
            dialogBuilder.add((Component)meterPanel).xyw(1, 3, 11);
            dialogBuilder.appendRows("5dlu", new Object[0]);
            dialogBuilder.appendRows("fill:100dlu:grow", new Object[0]);
            LOGGER.info("Create the TimeSeries for the booster current.");
            this.series = new TimeSeries((Comparable)((Object)"Current"));
            TimeSeriesCollection dataset = new TimeSeriesCollection(this.series);
            this.series.setMaximumItemCount(this.maximumItemCount);
            this.chart = this.createChart((XYDataset)dataset);
            ChartPanel chartPanel = new ChartPanel(this.chart);
            this.disabledChartPanel = new DisabledPanel((Container)chartPanel);
            this.disabledChartPanel.setEnabled(false);
            dialogBuilder.add((Component)this.disabledChartPanel).xyw(1, 5, 13);
            JPanel innerContentPanel = dialogBuilder.build();
            JScrollPane scrollPaneBoosterPanel = new JScrollPane();
            scrollPaneBoosterPanel.setViewportView(innerContentPanel);
            scrollPaneBoosterPanel.setOpaque(FormsSetup.getOpaqueDefault());
            scrollPaneBoosterPanel.getViewport().setOpaque(FormsSetup.getOpaqueDefault());
            this.contentPanel.add((Component)scrollPaneBoosterPanel, "Center");
            this.contentPanel.setBorder((Border)Paddings.TABBED_DIALOG);
            this.contentPanel.setOpaque(FormsSetup.getOpaqueDefault());
            LOGGER.info("Update the component state.");
            this.updateComponentState();
        });
    }

    public JPanel getComponent() {
        return this.contentPanel;
    }

    public Object getCreator() {
        return this;
    }

    private JFreeChart createChart(XYDataset dataset) {
        Color backgroundColor = UIManager.getColor("Chart.background");
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)Resources.getString(BoosterPanel.class, (String)"boosterCurrent"), (String)Resources.getString(BoosterPanel.class, (String)"time"), (String)(Resources.getString(BoosterPanel.class, (String)"current") + " [mA]"), (XYDataset)dataset, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)backgroundColor);
        chart.getTitle().setPaint((Paint)UIManager.getColor("Chart.title.foreground"));
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)backgroundColor);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        ValueAxis xaxis = plot.getDomainAxis();
        xaxis.setAutoRange(true);
        xaxis.setTickLabelsVisible(false);
        ValueAxis yaxis = plot.getRangeAxis();
        yaxis.setRange(0.0, 5000.0);
        Font titleFont = UIManager.getDefaults().getFont("Label.font");
        chart.getTitle().setFont(titleFont.deriveFont(1));
        xaxis.setLabelFont(titleFont);
        yaxis.setLabelFont(titleFont);
        xaxis.setLabelPaint((Paint)UIManager.getColor("Chart.title.foreground"));
        yaxis.setLabelPaint((Paint)UIManager.getColor("Chart.title.foreground"));
        xaxis.setTickLabelPaint((Paint)UIManager.getColor("Chart.title.foreground"));
        xaxis.setTickMarkPaint((Paint)UIManager.getColor("Chart.title.foreground"));
        yaxis.setTickLabelPaint((Paint)UIManager.getColor("Chart.title.foreground"));
        yaxis.setTickMarkPaint((Paint)UIManager.getColor("Chart.title.foreground"));
        XYLineAndShapeRenderer r1 = new XYLineAndShapeRenderer();
        r1.setSeriesPaint(0, (Paint)UIManager.getColor("Chart.current.line"));
        r1.setSeriesShapesVisible(0, false);
        plot.setRenderer(0, (XYItemRenderer)r1);
        return chart;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof BoosterPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void commandStationStatusChanged(CommandStationStatus status) {
        LOGGER.info("Status of command station has changed: {}", (Object)status);
        this.setStatusButtonState(this.commandStationStatusButton, status);
        this.setStatusText(this.commandStationStatusText, status);
    }

    public void boosterStateChanged(BoosterStatus status) {
        LOGGER.info("Status of command station has changed: {}", (Object)status);
        this.setStatusButtonState(this.boosterStatusButton, status);
        this.setStatusText(this.boosterStatusText, status);
    }

    public void boosterCurrentChanged(Integer current, long timestamp) {
        LOGGER.debug("Booster current has changed: {}", (Object)current);
        if (current != null && current >= 0) {
            this.ampereMeter.setEnabled(true);
            this.ampereMeter.setValueAnimated((double)current.intValue());
        } else {
            LOGGER.info("The current value is no longer valid.");
            this.ampereMeter.setValue(0.0);
            this.ampereMeter.setEnabled(false);
        }
        if (current != null) {
            try {
                this.series.add((RegularTimePeriod)new Millisecond(new Date(timestamp)), (Number)current);
            }
            catch (Exception ex) {
                LOGGER.warn("Add current value to timeseries failed.", (Throwable)ex);
            }
        }
    }

    public void boosterMaximumCurrentChanged(Integer maximumCurrent) {
        LOGGER.debug("Booster maximum current has changed: {}", (Object)maximumCurrent);
        if (maximumCurrent != null && maximumCurrent > 0) {
            int upperLimit = maximumCurrent + 1000;
            this.ampereMeter.setMaxValue((double)upperLimit);
            Section[] sections = new Section[]{new Section(0.0, (double)(maximumCurrent - 500), Color.GREEN), new Section((double)(maximumCurrent - 500), (double)maximumCurrent.intValue(), Color.ORANGE), new Section((double)maximumCurrent.intValue(), (double)upperLimit, Color.RED)};
            this.ampereMeter.setSections(sections);
            BoosterNodeInterface boosterNode = this.selectedNode.getBoosterNode();
            if (boosterNode != null && boosterNode.getBoosterCurrent() != null) {
                this.ampereMeter.setValue((double)boosterNode.getBoosterCurrent().intValue());
            } else {
                this.ampereMeter.setValue(0.0);
            }
            if (maximumCurrent > this.DEFAULT_MAXCURRENT_LIMIT) {
                this.chart.getXYPlot().getRangeAxis().setRange(0.0, (double)upperLimit);
            } else {
                this.chart.getXYPlot().getRangeAxis().setRange(0.0, (double)(this.DEFAULT_MAXCURRENT_LIMIT + 1000));
            }
            if (this.maxBoosterCurrentMarker != null) {
                this.chart.getXYPlot().removeRangeMarker((Marker)this.maxBoosterCurrentMarker);
            }
            this.maxBoosterCurrentMarker = new ValueMarker((double)maximumCurrent.intValue(), (Paint)Color.RED, (Stroke)new BasicStroke(0.5f));
            this.chart.getXYPlot().addRangeMarker((Marker)this.maxBoosterCurrentMarker);
        } else {
            this.ampereMeter.setMaxValue(0.1);
        }
    }

    public void temperatureChanged(Integer temperature) {
        if (temperature != null) {
            this.thermoMeter.setValueAnimated((double)temperature.intValue());
        } else {
            this.thermoMeter.setValueAnimated(0.0);
        }
    }

    public void voltageChanged(Integer voltage) {
        if (voltage != null && voltage > 0) {
            this.voltMeter.setValueAnimated((double)voltage.intValue() / 10.0);
        } else {
            this.voltMeter.setValueAnimated(0.0);
        }
    }

    private JideToggleButton createBoosterStatusButton() {
        JideToggleButton statusButton = new JideToggleButton();
        statusButton.setButtonStyle(1);
        statusButton.setIcon((Icon)this.iconBoosterOff);
        Dimension dim = statusButton.getPreferredSize();
        statusButton.setPreferredSize(dim);
        statusButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setStatusButtonState(statusButton, BoosterStatus.OFF);
        return statusButton;
    }

    private JideSplitButton createCommandStationStatusButton() {
        JideSplitButton statusButton = new JideSplitButton(Resources.getString(this.getClass(), (String)"cs-go"));
        statusButton.setButtonStyle(1);
        statusButton.setButtonEnabled(true);
        statusButton.setEnabled(true);
        Dimension dim = statusButton.getPreferredSize();
        statusButton.setPreferredSize(new Dimension(150, dim.height));
        statusButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JMenuItem csGoItem = new JMenuItem(Resources.getString(this.getClass(), (String)"cs-go"));
        csGoItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        statusButton.add(csGoItem);
        JMenuItem csGoIgnWdItem = new JMenuItem(Resources.getString(this.getClass(), (String)"cs-goIgnWd"));
        csGoIgnWdItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        statusButton.add(csGoIgnWdItem);
        JMenuItem csSoftStopItem = new JMenuItem(Resources.getString(this.getClass(), (String)"cs-softStop"));
        csSoftStopItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        statusButton.add(csSoftStopItem);
        JMenuItem csOffItem = new JMenuItem(Resources.getString(this.getClass(), (String)"cs-off"));
        csOffItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        statusButton.add(csOffItem);
        statusButton.setEnabled(false);
        this.setStatusButtonState(statusButton, CommandStationStatus.OFF);
        return statusButton;
    }

    private JTextField addStatusText() {
        JTextField statusText = new JTextField();
        statusText.setEditable(false);
        statusText.setColumns(20);
        BoosterStatus boosterStatus = null;
        if (this.selectedNode != null && this.selectedNode.getBoosterNode() != null) {
            boosterStatus = this.selectedNode.getBoosterNode().getBoosterStatus();
        }
        this.setStatusText(statusText, boosterStatus);
        JPopupMenu popup = new JPopupMenu("Reload status");
        JMenuItem mi = new JMenuItem(Resources.getString(this.getClass(), (String)"booster-query-status"));
        mi.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        popup.add(mi);
        statusText.add(popup);
        statusText.setComponentPopupMenu(popup);
        return statusText;
    }

    public void addStatusListener(StatusListener l) {
        this.statusListeners.add(l);
    }

    private Radial1Vertical addAmpereMeter() {
        Radial1Vertical ampereMeter = new Radial1Vertical();
        ampereMeter.setPreferredSize(new Dimension(160, 160));
        ampereMeter.setFrameVisible(true);
        ampereMeter.setLcdDecimals(0);
        ampereMeter.setLcdUnitStringVisible(false);
        ampereMeter.setLedVisible(false);
        ampereMeter.setSectionsVisible(true);
        ampereMeter.setTitle(Resources.getString(this.getClass(), (String)"current"));
        ampereMeter.setTrackVisible(false);
        ampereMeter.setUnitString("mA");
        return ampereMeter;
    }

    private Radial1Vertical addThermoMeter() {
        Radial1Vertical thermoMeter = new Radial1Vertical();
        thermoMeter.setPreferredSize(new Dimension(160, 160));
        thermoMeter.setFrameVisible(true);
        thermoMeter.setLcdDecimals(0);
        thermoMeter.setLcdUnitStringVisible(false);
        thermoMeter.setLedVisible(false);
        thermoMeter.setMaxValue(100.0);
        thermoMeter.setSectionsVisible(true);
        thermoMeter.setTitle(Resources.getString(this.getClass(), (String)"temperature"));
        thermoMeter.setTrackVisible(false);
        thermoMeter.setUnitString("\u00b0C");
        Section[] sections = new Section[]{new Section(0.0, 70.0, Color.GREEN), new Section(70.0, 90.0, Color.ORANGE), new Section(90.0, thermoMeter.getMaxValue(), Color.RED)};
        thermoMeter.setSections(sections);
        return thermoMeter;
    }

    private Radial1Vertical addVoltMeter() {
        Radial1Vertical voltMeter = new Radial1Vertical();
        voltMeter.setPreferredSize(new Dimension(160, 160));
        voltMeter.setFrameVisible(true);
        voltMeter.setLcdDecimals(0);
        voltMeter.setLcdUnitStringVisible(false);
        voltMeter.setLedVisible(false);
        voltMeter.setMaxValue(30.0);
        voltMeter.setSectionsVisible(true);
        voltMeter.setTitle(Resources.getString(this.getClass(), (String)"voltage"));
        voltMeter.setTrackVisible(false);
        voltMeter.setUnitString("V");
        Section[] sections = new Section[]{new Section(0.0, 10.0, Color.RED), new Section(10.0, 11.0, Color.ORANGE), new Section(11.0, 22.0, Color.GREEN), new Section(22.0, 23.0, Color.ORANGE), new Section(23.0, voltMeter.getMaxValue(), Color.RED)};
        voltMeter.setSections(sections);
        return voltMeter;
    }

    private void fireSwitchedOn() {
        for (StatusListener l : this.statusListeners) {
            l.switchedOn();
        }
    }

    private void fireSwitchedOff() {
        for (StatusListener l : this.statusListeners) {
            l.switchedOff();
        }
    }

    private void fireQueryBoosterState() {
        for (StatusListener l : this.statusListeners) {
            l.queryBoosterState();
        }
    }

    private void fireSwitchedCommandStationOn(boolean ignoreWatchDog) {
        LOGGER.info("Set the command station ON.");
        for (StatusListener l : this.statusListeners) {
            l.switchedCommandStationOn(ignoreWatchDog);
        }
    }

    private void fireSwitchedCommandStationStop() {
        LOGGER.info("Set the command station STOP.");
        for (StatusListener l : this.statusListeners) {
            l.switchedCommandStationStop();
        }
    }

    private void fireSwitchedCommandStationSoftStop() {
        LOGGER.info("Set the command station SOFT STOP.");
        for (StatusListener l : this.statusListeners) {
            l.switchedCommandStationSoftStop();
        }
    }

    private void fireSwitchedCommandStationOff() {
        LOGGER.info("Set the command station OFF.");
        for (StatusListener l : this.statusListeners) {
            l.switchedCommandStationOff();
        }
    }

    private void setStatusButtonState(JideToggleButton statusButton, BoosterStatus status) {
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (status != null) {
            boolean wasEnabled = statusButton.isEnabled();
            if (selectedNode != null) {
                boolean bl = wasEnabled = wasEnabled && NodeUtils.hasBoosterFunctions((long)selectedNode.getUniqueId());
            }
            if (BoosterStatus.isOffState((BoosterStatus)status)) {
                statusButton.setSelected(false);
                statusButton.setIcon((Icon)this.iconBoosterOff);
            } else {
                statusButton.setSelected(true);
                statusButton.setIcon((Icon)this.iconBoosterOn);
            }
            LOGGER.info("Set boosterStatus button enabled: {}", (Object)wasEnabled);
            statusButton.setEnabled(wasEnabled);
        } else if (selectedNode != null && NodeUtils.hasBoosterFunctions((long)selectedNode.getUniqueId())) {
            statusButton.setEnabled(true);
        } else {
            statusButton.setSelected(false);
            statusButton.setEnabled(false);
        }
    }

    private void setStatusButtonState(JideSplitButton statusButton, CommandStationStatus status) {
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (status != null) {
            boolean wasEnabled = statusButton.isEnabled();
            if (selectedNode != null) {
                boolean bl = wasEnabled = wasEnabled && NodeUtils.hasCommandStationFunctions((long)selectedNode.getUniqueId());
            }
            if (wasEnabled) {
                if (CommandStationState.isOffState((CommandStationState)status.getType())) {
                    statusButton.setText(Resources.getString(this.getClass(), (String)"cs-go"));
                } else {
                    statusButton.setText(Resources.getString(this.getClass(), (String)"cs-stop"));
                }
            }
            LOGGER.info("Set the command station status button enabled: {}", (Object)wasEnabled);
            statusButton.setEnabled(wasEnabled);
        } else if (selectedNode != null && NodeUtils.hasCommandStationFunctions((long)selectedNode.getUniqueId())) {
            LOGGER.debug("Set the status button enabled because the node has command station functions.");
            statusButton.setEnabled(true);
        } else {
            LOGGER.debug("Set the status button disabled because the node has no command station functions.");
            statusButton.setEnabled(false);
        }
    }

    private void setStatusText(JTextField statusText, BoosterStatus status) {
        statusText.setText(status != null ? Resources.getString(BoosterStatus.class, (String)status.name().toLowerCase()) : "");
    }

    private void setStatusText(JTextField statusText, CommandStationStatus status) {
        LOGGER.info("Set the new status of the command station: {}", (Object)status);
        statusText.setText(status != null ? Resources.getString(CommandStationStatus.class, (String)status.name().toLowerCase()) : "");
    }

    public void nodeChanged() {
        this.updateComponentState();
    }

    private void updateComponentState() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (this.selectedNode != null && this.selectedNode.equals((Object)node)) {
            LOGGER.debug("Node is selected already: {}", (Object)node);
            return;
        }
        boolean isBooster = node != null ? NodeUtils.hasBoosterFunctions((long)node.getUniqueId()) : false;
        boolean isCommandStation = node != null ? NodeUtils.hasCommandStationFunctions((long)node.getUniqueId()) : false;
        this.series.clear();
        this.selectedNode = isBooster || isCommandStation ? node : null;
        LOGGER.debug("The selected node has booster functions: {}, has command station functions: {}, node: {}", new Object[]{isBooster, isCommandStation, node});
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateComponentsVisibilityAndEnabledState(isBooster, isCommandStation);
        } else {
            SwingUtilities.invokeLater(() -> this.updateComponentsVisibilityAndEnabledState(isBooster, isCommandStation));
        }
    }

    private void updateComponentsVisibilityAndEnabledState(boolean isBooster, boolean isCommandStation) {
        this.boosterStatusText.setVisible(isBooster);
        this.boosterStatusLabel.setVisible(isBooster);
        this.boosterStatusButton.setVisible(isBooster);
        this.boosterStatusButton.setEnabled(isBooster);
        this.ampereMeter.setEnabled(isBooster);
        this.ampereMeter.setVisible(isBooster);
        this.voltMeter.setEnabled(isBooster);
        this.voltMeter.setVisible(isBooster);
        this.thermoMeter.setEnabled(isBooster);
        this.thermoMeter.setVisible(isBooster);
        this.disabledChartPanel.setEnabled(isBooster);
        this.disabledChartPanel.setVisible(isBooster);
        this.commandStationStatusButton.setEnabled(isCommandStation);
        this.commandStationStatusButton.setVisible(isCommandStation);
    }

    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = NodeUtils.hasCommandStationFunctions((long)node.getUniqueId()) || NodeUtils.hasBoosterFunctions((long)node.getUniqueId());
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }
}

