/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel.renderer;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.main.view.panel.renderer.AccessoryListRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessoryListRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryListRenderer.class);
    private ImageIcon pendingChangesIcon = ImageUtils.createImageIcon(AccessoryListRenderer.class, (String)"/icons/write.png");
    private ImageIcon permanentlyStoredIcon = ImageUtils.createImageIcon(AccessoryListRenderer.class, (String)"/icons/16x16/lock.png");
    private ImageIcon errorIcon = ImageUtils.createImageIcon(AccessoryListRenderer.class, (String)"/icons/accessory-error.png");

    @Override
    public Component getTableCellRendererComponent(JTable list, Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
        Component renderer = super.getTableCellRendererComponent(list, value, isSelected, cellHasFocus, row, column);
        if (value instanceof Accessory) {
            Accessory accessory = (Accessory)value;
            switch (1.$SwitchMap$org$bidib$wizard$api$model$AccessorySaveState[accessory.getAccessorySaveState().ordinal()]) {
                case 1: {
                    this.setIcon((Icon)this.pendingChangesIcon);
                    break;
                }
                case 2: {
                    this.setIcon((Icon)this.permanentlyStoredIcon);
                    break;
                }
                default: {
                    LOGGER.error("Unknown accessory save state detected: {}", (Object)accessory.getAccessorySaveState());
                }
            }
            if (accessory.hasError()) {
                this.setIcon((Icon)this.errorIcon);
                this.setToolTipText("The accessory has an error.");
            } else if (accessory.hasExecutionStateError()) {
                this.setIcon((Icon)this.errorIcon);
                this.setToolTipText("The accessory has an excution error: " + accessory.getAccessoryState().getErrorInformation());
            } else {
                this.setToolTipText(null);
            }
            String text = null;
            text = StringUtils.isNotBlank((CharSequence)accessory.getLabel()) ? String.format("%1$02d : %2$s", accessory.getId(), accessory.getLabel()) : (accessory.getId() > -1 ? String.format("%1$02d :", accessory.getId()) : " ");
            this.setText(text);
        }
        return renderer;
    }
}

