/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.statusbar;

import com.jidesoft.status.ButtonStatusBarItem;
import com.jidesoft.swing.JideToggleButton;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.mvc.main.model.StatusModel;
import org.bidib.wizard.mvc.main.view.panel.listener.StatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusButtonStatusBarItem
extends ButtonStatusBarItem {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusButtonStatusBarItem.class);
    private Collection<StatusListener> statusListeners = new LinkedList();
    private JideToggleButton onButton;
    private final StatusModel model;

    public StatusButtonStatusBarItem(StatusModel model) {
        this.model = model;
        this.onButton.setSelected(model.isRunning());
        this.updateButton(model.isRunning());
        this.model.addStatusListener((org.bidib.wizard.api.model.listener.StatusListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected AbstractButton createButton() {
        this.onButton = new JideToggleButton();
        this.onButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.onButton;
    }

    public String getItemName() {
        return "StatusButtonPanel";
    }

    private void updateButton(boolean running) {
        if (running) {
            this.onButton.setText(Resources.getString(StatusButtonStatusBarItem.class, (String)"on"));
            this.onButton.setToolTipText(Resources.getString(StatusButtonStatusBarItem.class, (String)"on-tooltip"));
        } else {
            this.onButton.setText(Resources.getString(StatusButtonStatusBarItem.class, (String)"off"));
            this.onButton.setToolTipText(Resources.getString(StatusButtonStatusBarItem.class, (String)"off-tooltip"));
        }
    }

    public void setTitleBorder() {
        this.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(this.getClass(), (String)"title") + ":"));
    }

    public void setButtonHeight(int height) {
        LOGGER.info("Set the button height: {}", (Object)height);
        this.onButton.setPreferredSize(new Dimension(60, height));
    }

    public JideToggleButton getButton() {
        return this.onButton;
    }

    public void addStatusListener(StatusListener l) {
        this.statusListeners.add(l);
    }

    private void fireSwitchedOff() {
        LOGGER.info("Switch model time off");
        for (StatusListener l : this.statusListeners) {
            l.switchedOff();
        }
    }

    private void fireSwitchedOn() {
        LOGGER.info("Switch model time on");
        for (StatusListener l : this.statusListeners) {
            l.switchedOn();
        }
    }

    public void setEnabled(boolean enabled) {
        LOGGER.info("Change the button enabled: {}", (Object)enabled);
        super.setEnabled(enabled);
        this.onButton.setEnabled(enabled);
    }
}

