/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pom.controller;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.CommandStationPom;
import org.bidib.jbidibc.messages.enums.PomAddressTypeEnum;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.enums.PomProgState;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.service.node.BoosterService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.client.common.view.WindowUtils;
import org.bidib.wizard.core.model.connection.MessageAdapter;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.mvc.common.DialogRegistry;
import org.bidib.wizard.mvc.common.view.RegisteredDialog;
import org.bidib.wizard.mvc.pom.controller.PomProgrammerController;
import org.bidib.wizard.mvc.pom.controller.listener.PomProgrammerControllerListener;
import org.bidib.wizard.mvc.pom.model.CurrentAddressBeanModel;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.bidib.wizard.mvc.pom.view.PomProgrammerView;
import org.bidib.wizard.mvc.pom.view.listener.PomProgrammerViewListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PomProgrammerController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomProgrammerController.class);
    private final Collection<PomProgrammerControllerListener> listeners = new LinkedList();
    private final JFrame parent;
    private final CommandStationNodeInterface node;
    private final int x;
    private final int y;
    private final PomProgrammerModel model = new PomProgrammerModel();
    private PomProgrammerView view;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private BoosterService boosterService;
    @Autowired
    private CommandStationService commandStationService;
    private MessageAdapter messageAdapter;
    private static AtomicBoolean singleton = new AtomicBoolean();
    private final DialogRegistry dialogRegistry;

    public PomProgrammerController(CommandStationNodeInterface node, DialogRegistry dialogRegistry, JFrame parent, int x, int y) {
        this.parent = parent;
        this.dialogRegistry = dialogRegistry;
        this.node = node;
        this.x = x;
        this.y = y;
    }

    public static boolean isOpened() {
        return singleton.get();
    }

    private void setOpened(boolean opened) {
        singleton.set(opened);
    }

    public void addPomProgrammerControllerListener(PomProgrammerControllerListener l) {
        this.listeners.add(l);
    }

    private void fireClose() {
        for (PomProgrammerControllerListener l : this.listeners) {
            l.close();
        }
        this.setOpened(false);
    }

    private void fireSendRequest(PomAddressData decoderAddress, PomOperation operation, int cvNumber, int cvValue) {
        LOGGER.info("Send CV request, decoder addr: {}, operation: {}, cvNumber: {}, value: {}", new Object[]{decoderAddress, operation, cvNumber, cvValue});
        CommandStationPom opCode = CommandStationPom.valueOf((byte)ByteUtils.getLowByte((int)operation.getType()));
        this.model.clearCvValue();
        LOGGER.info("Prepared opCode: {}", (Object)opCode);
        for (PomProgrammerControllerListener l : this.listeners) {
            l.sendRequest(this.node, decoderAddress, opCode, cvNumber, cvValue);
        }
    }

    public void start(DockingDesktop desktop, AddressData initialAddress) {
        this.messageAdapter = new /* Unavailable Anonymous Inner Class!! */;
        this.messageAdapter.setNode(this.node.getNode());
        this.messageAdapter.start();
        CurrentAddressBeanModel currentAddressBeanModel = new CurrentAddressBeanModel();
        if (initialAddress != null) {
            LOGGER.info("Set the provided initial address: {}", (Object)initialAddress);
            currentAddressBeanModel.setDccAddress(Integer.valueOf(initialAddress.getAddress()));
            AddressTypeEnum addressTypeEnum = initialAddress.getType();
            PomAddressTypeEnum addressType = null;
            switch (5.$SwitchMap$org$bidib$jbidibc$messages$enums$AddressTypeEnum[addressTypeEnum.ordinal()]) {
                case 1: {
                    addressType = PomAddressTypeEnum.ACCESSORY;
                    break;
                }
                case 2: {
                    addressType = PomAddressTypeEnum.EXTENDED_ACCESSORY;
                    break;
                }
                default: {
                    addressType = PomAddressTypeEnum.LOCOMOTIVE;
                }
            }
            currentAddressBeanModel.setAddressType(addressType);
        }
        if (currentAddressBeanModel.getDccAddress() != null && CollectionUtils.isNotEmpty((Collection)this.dialogRegistry.getDialogRegistry())) {
            String searchKey = PomProgrammerView.prepareKey((Integer)currentAddressBeanModel.getDccAddress());
            RegisteredDialog existingDialog = (RegisteredDialog)IterableUtils.find((Iterable)this.dialogRegistry.getDialogRegistry(), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
            if (existingDialog != null) {
                LOGGER.info("Found existing dialog: {}", (Object)existingDialog);
                try {
                    if (SystemUtils.IS_OS_WINDOWS) {
                        WindowUtils.bringWindowToFront((Window)existingDialog.getWindow());
                    } else {
                        existingDialog.getWindow().toFront();
                    }
                    return;
                }
                catch (Exception ex) {
                    LOGGER.warn("Bring the existing dialog to front failed.");
                }
            } else {
                LOGGER.info("No existing dialog found.");
            }
        }
        this.view = new PomProgrammerView(this.model, currentAddressBeanModel);
        this.view.addPomProgrammerViewListener((PomProgrammerViewListener)new /* Unavailable Anonymous Inner Class!! */);
        LOGGER.info("Initialize the view.");
        this.setOpened(true);
        this.view.showDialog(this.parent, this.x, this.y);
        LOGGER.info("Register the LocoDialog in the dialog registry: {}", (Object)this.view);
        this.dialogRegistry.getDialogRegistry().add(this.view);
        LOGGER.info("The POM programmer dialog is now displayed.");
    }

    private void updatePomProgState(PomProgState pomProgState, PomAddressData decoderAddress, int cvNumber, int cvValue) {
        this.model.updatePomProgResult(pomProgState, decoderAddress, cvNumber, cvValue);
    }

    private void unregisterView(RegisteredDialog view) {
        block5: {
            if (view != null) {
                try {
                    if (!CollectionUtils.isNotEmpty((Collection)this.dialogRegistry.getDialogRegistry())) break block5;
                    String searchKey = view.getKey();
                    RegisteredDialog existingDialog = (RegisteredDialog)IterableUtils.find((Iterable)this.dialogRegistry.getDialogRegistry(), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
                    if (existingDialog != null) {
                        LOGGER.info("Found existing dialog to unregister: {}", (Object)existingDialog);
                        this.dialogRegistry.getDialogRegistry().remove(existingDialog);
                        LOGGER.info("Registry after remove: {}", (Object)this.dialogRegistry);
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Unregister view failed: {}", (Object)view, (Object)ex);
                }
            } else {
                LOGGER.info("No view available to unregister.");
            }
        }
    }
}

