package org.bidib.wizard.mvc.main.view.panel.renderer;

import org.bidib.jbidibc.messages.enums.LoadTypeEnum;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.LoadTypeAware;
import org.bidib.wizard.mvc.main.view.table.ConfigurablePortComboBoxRenderer;

public final class LoadTypeComboBoxRenderer<P extends LoadTypeAware>
    extends ConfigurablePortComboBoxRenderer<LoadTypeEnum> {
    private static final long serialVersionUID = 1L;

    public LoadTypeComboBoxRenderer(int portInstanceColumn, LoadTypeEnum[] items, byte... pcfgType) {
        super(portInstanceColumn, items, pcfgType);

        setRenderer(new LoadTypeCellRenderer());
    }

    @Override
    protected Object getCurrentValue(ConfigurablePort<?> port) {
        LoadTypeEnum value = ((P) port).getLoadType();
        // filter out UNKNOWN value
        if (LoadTypeEnum.UNKNOWN == value) {
            value = null;
        }
        return value;
    }
}