package org.bidib.wizard.mvc.pom.model.command;

import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.enums.PomProgState;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;

public class PomOperationCommand<M extends ProgCommandAwareBeanModel> {
    private PomAddressData decoderAddress;

    private PomOperation pomOperation;

    private int cvNumber;

    private int cvValue;

    private Integer cvValueResult;

    private PomProgState progStateResult;

    private int retryCount;

    public PomOperationCommand(PomAddressData decoderAddress, PomOperation pomOperation, int cvNumber, int cvValue) {
        this.decoderAddress = decoderAddress;
        this.pomOperation = pomOperation;
        this.cvNumber = cvNumber;
        this.cvValue = cvValue;
    }

    /**
     * @return the decoderAddress
     */
    public PomAddressData getDecoderAddress() {
        return decoderAddress;
    }

    /**
     * @param decoderAddress
     *            the decoderAddress to set
     */
    public void setDecoderAddress(PomAddressData decoderAddress) {
        this.decoderAddress = decoderAddress;
    }

    /**
     * @return the pomOperation
     */
    public PomOperation getPomOperation() {
        return pomOperation;
    }

    /**
     * @param pomOperation
     *            the pomOperation to set
     */
    public void setPomOperation(PomOperation pomOperation) {
        this.pomOperation = pomOperation;
    }

    /**
     * @return the cvNumber
     */
    public int getCvNumber() {
        return cvNumber;
    }

    /**
     * @param cvNumber
     *            the cvNumber to set
     */
    public void setCvNumber(int cvNumber) {
        this.cvNumber = cvNumber;
    }

    /**
     * @return the cvValue
     */
    public int getCvValue() {
        return cvValue;
    }

    /**
     * @param cvValue
     *            the cvValue to set
     */
    public void setCvValue(int cvValue) {
        this.cvValue = cvValue;
    }

    /**
     * @return the cvValueResult
     */
    public Integer getCvValueResult() {
        return cvValueResult;
    }

    /**
     * @param cvValueResult
     *            the cvValueResult to set
     */
    public void setCvValueResult(Integer cvValueResult) {
        this.cvValueResult = cvValueResult;
    }

    /**
     * @return the progStateResult
     */
    public PomProgState getProgStateResult() {
        return progStateResult;
    }

    /**
     * @param progStateResult
     *            the progStateResult to set
     */
    public void setProgStateResult(PomProgState progStateResult) {
        this.progStateResult = progStateResult;
    }

    /**
     * @return the retryCount
     */
    public int getRetryCount() {
        return retryCount;
    }

    /**
     * @param retryCount
     *            the retryCount to set
     */
    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    /**
     * @return the retryCount
     */
    public int decrementRetryCount() {
        retryCount--;
        return retryCount;
    }

    public void postExecute(final M progCommandAwareBeanModel) {
        // do nothing
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(getClass().getSimpleName());
        sb.append(", decoderAddress=");
        sb.append(decoderAddress).append("ptOperation=");
        sb
            .append(pomOperation).append(",cvNumber=").append(cvNumber).append(",cvValue=0x")
            .append(ByteUtils.byteToHex(cvValue));
        if (cvValueResult != null) {
            sb.append(",cvValueResult=").append(ByteUtils.byteToHex(cvValueResult));
        }
        if (progStateResult != null) {
            sb.append(",progStateResult=").append(progStateResult);
        }
        sb.append(",retryCount=").append(retryCount);
        return sb.toString();
    }
}
