package org.bidib.wizard.mvc.stepcontrol.controller;

import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.mvc.main.model.listener.AccessoryRequestListener;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect;

import com.jgoodies.common.collect.ArrayListModel;

public interface StepControlControllerInterface extends AccessoryRequestListener {

    static final int ACCESSORY_ID_CONTROLLING = 0;

    static final int ACCESSORY_ID_OPERATING = 1;

    static final int ACCESSORY_ID_SOUND = 2;

    static final int ASPECT_ID_OPERATING = 1;

    static final int ASPECT_ID_HOMING = 2;

    static final int MAX_CONFIGURED_ASPECTS = 48;

    /**
     * Trigger load the CV values of the step control.
     */
    void triggerLoadCvValues();

    /**
     * @return the list model of aspects
     */
    ArrayListModel<StepControlAspect> getConfigureAspectsListModel();

    /**
     * Set the new value of the motor port.
     * 
     * @param motorPort
     *            the motor port
     */
    void setMotorPortValue(final MotorPort motorPort);

    /**
     * @param portId
     *            the sound port to trigger
     * @param soundPortStatus
     *            the sound port status
     */
    void triggerSoundPort(final int portId, final SoundPortStatus soundPortStatus);

    /**
     * Set the sound active or mute.
     * 
     * @param soundActive
     *            the sound active flag
     */
    void setSoundActive(boolean soundActive);

    // /**
    // * Activate the aspect of the accessory.
    // *
    // * @param accessory
    // * the accessory
    // * @param aspectNumber
    // * the aspect number
    // */
    // void activateAspect(final Accessory accessory, int aspectNumber);
}
