package org.bidib.wizard.mvc.stepcontrol.view;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import org.bidib.wizard.model.stepcontrol.TurnTableType;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlModel;

public class AspectCellRenderer extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    private final StepControlModel stepControlModel;

    public AspectCellRenderer(final StepControlModel stepControlModel) {
        this.stepControlModel = stepControlModel;
    }

    @Override
    public Component getTableCellRendererComponent(
            JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {

        Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

        if (stepControlModel.getTurnTableType() == TurnTableType.round) {
            setValue(prepareRowString(row, table.getRowCount()));
        }
        else {
            setValue(Integer.toString(row));
        }
        return renderer;
    }

    protected String prepareRowString(int rowNumber, int totalRowCount) {

        String s = String.format("%d - %d", rowNumber, rowNumber + totalRowCount);
        return s;
    }
}
