/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.accessory.view.panel;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.util.PropertyValidationSupport;
import com.jgoodies.validation.view.ValidationComponentUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AccessoryAcknowledge;
import org.bidib.jbidibc.messages.enums.AccessoryAddressingEnum;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.enums.TimingControlEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.mvc.accessory.model.AccessoryBeanModel;
import org.bidib.wizard.mvc.accessory.model.AccessoryModel;
import org.bidib.wizard.mvc.accessory.view.panel.AccessoryValidationResultModel;
import org.bidib.wizard.mvc.accessory.view.panel.RCN213Converter;
import org.bidib.wizard.mvc.accessory.view.panel.listener.AccessoryResultListener;
import org.bidib.wizard.mvc.accessory.view.panel.listener.DccAccessoryRequestListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public abstract class AbstractAccessoryPanel<T extends AccessoryBeanModel>
implements AccessoryResultListener {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 10dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "p, 3dlu, p";
    private final List<DccAccessoryRequestListener> listeners = new LinkedList();
    protected AccessoryValidationResultModel accessoryValidationModel;
    private ValueModel addressValueModel;
    private ValueModel switchTimeValueModel;
    private JComponent[] addressingButtons;
    private JComponent[] baseUnitButtons;
    private static final String NEWLINE = "\n";
    private JTextArea loggerArea;
    protected boolean activeTab;
    private static final int MIN_ADDRESS = 0;
    private static final int MIN_SWITCHTIME = 1;
    private static final int MAX_SWITCHTIME = 127;

    public AbstractAccessoryPanel(AccessoryModel accessoryModel) {
    }

    protected abstract T getAccessoryBeanModel();

    public JPanel createPanel() {
        Object panel;
        FormBuilder builder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            builder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            builder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        builder.border((Border)Paddings.DIALOG);
        this.accessoryValidationModel = new AccessoryValidationResultModel();
        this.addressValueModel = new PropertyAdapter((Object)this.getAccessoryBeanModel(), "dccAddress", true);
        ConverterValueModel addressConverterModel = new ConverterValueModel(this.addressValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField addressText = new JTextField();
        InputValidationDocument addressDocument = new InputValidationDocument(4, "0123456789");
        addressText.setDocument((Document)addressDocument);
        addressText.setColumns(4);
        Bindings.bind((JTextField)addressText, (ValueModel)addressConverterModel, (boolean)false);
        builder.add(Resources.getString(AbstractAccessoryPanel.class, (String)"dcc-address"), new Object[0]).xy(1, 1);
        builder.add((Component)addressText).xy(3, 1);
        ValidationComponentUtils.setMandatory((JComponent)addressText, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)addressText, (Object[])new Object[]{"validation.address_key"});
        JLabel addressingLabel = new JLabel(Resources.getString(AbstractAccessoryPanel.class, (String)"addressing"));
        builder.add((Component)addressingLabel).xy(5, 1);
        addressingLabel.setHorizontalAlignment(11);
        PropertyAdapter addressingModel = new PropertyAdapter((Object)this.getAccessoryBeanModel(), "accessoryAddressing", true);
        this.addressingButtons = new JComponent[AccessoryAddressingEnum.values().length];
        int index = 0;
        int column = 7;
        for (AccessoryAddressingEnum accessoryAddressing : AccessoryAddressingEnum.values()) {
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)addressingModel, (Object)accessoryAddressing, (String)Resources.getString(AccessoryAddressingEnum.class, (String)accessoryAddressing.getKey()));
            radio.setToolTipText(Resources.getString(AccessoryAddressingEnum.class, (String)(accessoryAddressing.getKey() + ".tooltip")));
            this.addressingButtons[index++] = radio;
            builder.add((Component)radio).xy(column, 1);
            column += 2;
        }
        PropertyAdapter directAddressValueModel = new PropertyAdapter((Object)this.getAccessoryBeanModel(), "dccAddress", true);
        ConverterValueModel directAddressConverterModel = new ConverterValueModel((ValueModel)directAddressValueModel, (BindingConverter)new RCN213Converter((ValueModel)addressingModel, (Format)new DecimalFormat("#")));
        JTextField directAddressText = new JTextField();
        directAddressText.setColumns(4);
        Bindings.bind((JTextField)directAddressText, (ValueModel)directAddressConverterModel, (boolean)false);
        builder.add((Component)directAddressText).xy(11, 1);
        directAddressText.setEditable(false);
        directAddressText.setEnabled(false);
        this.switchTimeValueModel = new PropertyAdapter((Object)this.getAccessoryBeanModel(), "switchTime", true);
        ConverterValueModel switchTimeConverterModel = new ConverterValueModel(this.switchTimeValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField switchTimeText = new JTextField();
        InputValidationDocument switchTimeDocument = new InputValidationDocument(3, "0123456789");
        switchTimeText.setDocument((Document)switchTimeDocument);
        switchTimeText.setColumns(3);
        Bindings.bind((JTextField)switchTimeText, (ValueModel)switchTimeConverterModel, (boolean)false);
        builder.add(Resources.getString(AbstractAccessoryPanel.class, (String)"switchTime"), new Object[0]).xy(1, 3);
        builder.add((Component)switchTimeText).xy(3, 3);
        ValidationComponentUtils.setMandatory((JComponent)switchTimeText, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)switchTimeText, (Object[])new Object[]{"validation.switchtime_key"});
        JLabel timeBaseUnit = new JLabel(Resources.getString(AbstractAccessoryPanel.class, (String)"timeBaseUnit"));
        builder.add((Component)timeBaseUnit).xy(5, 3);
        timeBaseUnit.setHorizontalAlignment(11);
        PropertyAdapter modeModel = new PropertyAdapter((Object)this.getAccessoryBeanModel(), "timeBaseUnit", true);
        this.baseUnitButtons = new JComponent[TimeBaseUnitEnum.values().length];
        index = 0;
        column = 7;
        for (TimeBaseUnitEnum baseUnit : TimeBaseUnitEnum.values()) {
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)modeModel, (Object)baseUnit, (String)Resources.getString(TimeBaseUnitEnum.class, (String)baseUnit.getKey()));
            this.baseUnitButtons[index++] = radio;
            builder.add((Component)radio).xy(column, 3);
            column += 2;
        }
        int[] rowHolder = new int[]{3};
        this.addSpecificComponents(builder, rowHolder);
        int currentRow = rowHolder[0];
        currentRow += 2;
        this.loggerArea = new JTextArea(10, 45);
        this.loggerArea.setFont(UIManager.getDefaults().getFont("Label.font"));
        JScrollPane scrollLog = new JScrollPane();
        scrollLog.getViewport().add(this.loggerArea);
        builder.appendRows("3dlu, fill:100dlu:grow", new Object[0]);
        builder.add((Component)scrollLog).xyw(1, currentRow, 11);
        this.getAccessoryBeanModel().addPropertyChangeListener("dccAddress", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.getAccessoryBeanModel().addPropertyChangeListener("accessoryAddressing", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.getAccessoryBeanModel().addPropertyChangeListener("switchTime", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addSpecificValidation();
        this.LOGGER.debug("Create iconfeedback panel.");
        IconFeedbackPanel cvIconPanel = new IconFeedbackPanel((ValidationResultModel)this.accessoryValidationModel, (JComponent)builder.build());
        FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]).panel((JPanel)new /* Unavailable Anonymous Inner Class!! */);
        feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
        JPanel panel2 = feedbackBuilder.build();
        this.triggerValidation();
        return panel2;
    }

    protected abstract void addSpecificComponents(FormBuilder var1, int[] var2);

    protected abstract void addSpecificValidation();

    public void addAccessoryRequestListener(DccAccessoryRequestListener listener) {
        this.listeners.add(listener);
    }

    protected List<DccAccessoryRequestListener> getAccessoryRequestListeners() {
        return this.listeners;
    }

    protected void sendRequest(AddressData dccAddress, Integer aspect, Integer switchTime, TimeBaseUnitEnum timeBaseUnit, TimingControlEnum timingControl) {
        this.disableInputElements();
        for (DccAccessoryRequestListener listener : this.getAccessoryRequestListeners()) {
            listener.sendRequest((AccessoryResultListener)this, dccAddress, aspect, switchTime, timeBaseUnit, timingControl);
        }
    }

    public void signalAcknowledgeChanged(AccessoryAcknowledge acknowledge) {
        if (!this.isActive()) {
            this.LOGGER.info("Do not process result because this is not the active tab.");
            return;
        }
        this.LOGGER.info("Accessory acknowledge has changed: {}", (Object)acknowledge);
        if (acknowledge != null) {
            this.addLogText("Received acknowledge: {}", new Object[]{acknowledge});
            this.enableInputElements();
        }
    }

    public void setActive(boolean active) {
        this.LOGGER.info("Set the active flag: {}", (Object)active);
        this.activeTab = active;
    }

    public boolean isActive() {
        return this.activeTab;
    }

    protected void disableInputElements() {
    }

    protected void enableInputElements() {
    }

    public void clearLogArea() {
        if (this.loggerArea != null) {
            this.loggerArea.setText(null);
        }
    }

    public void addLogText(String logLine, Object ... args) {
        this.LOGGER.info("Add text to loggerArea, logLine: {}, args: {}", (Object)logLine, (Object)args);
        if (args != null) {
            logLine = MessageFormatter.arrayFormat((String)logLine, (Object[])args).getMessage();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS - ");
        StringBuilder message = new StringBuilder(sdf.format(new Date()));
        message.append(logLine).append(NEWLINE);
        if (SwingUtilities.isEventDispatchThread()) {
            this.loggerArea.append(message.toString());
            this.loggerArea.setCaretPosition(this.loggerArea.getDocument().getLength());
        } else {
            SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected abstract int getMaxAddress();

    private ValidationResult validate() {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.getAccessoryBeanModel(), "validation");
        if (this.getAccessoryBeanModel().getDccAddress() == null) {
            support.addError("address_key", "not_empty");
        } else if (this.getAccessoryBeanModel().getDccAddress() < 0 || this.getAccessoryBeanModel().getDccAddress() > this.getMaxAddress()) {
            support.addError("address_key", "invalid_value;min=0,max=" + this.getMaxAddress());
        }
        if (this.getAccessoryBeanModel().getSwitchTime() == null) {
            support.addError("switchtime_key", "not_empty");
        } else if (this.getAccessoryBeanModel().getSwitchTime() < 1 || this.getAccessoryBeanModel().getSwitchTime() > 127) {
            support.addError("switchtime_key", "invalid_value;min=1,max=127");
        }
        ValidationResult validationResult = support.getResult();
        this.LOGGER.info("Prepared validationResult: {}", (Object)validationResult);
        return validationResult;
    }

    protected abstract void validateSpecificPanel(PropertyValidationSupport var1);

    protected void triggerValidation() {
        ValidationResult validationResult = this.validate();
        this.accessoryValidationModel.setResult(validationResult);
    }
}

