/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.accessory.view.panel;

import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessoryValidationResultModel
extends DefaultValidationResultModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryValidationResultModel.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_VALID_STATE = "validState";
    public static final String PROPERTY_VALID_STATE_NO_WARN_OR_ERRORS = "validStateNoWarnOrErrors";
    private boolean validState;
    private boolean validStateNoWarnOrErrors;

    public void setResult(ValidationResult newResult) {
        boolean oldValidState = this.getResult().isEmpty();
        boolean newValidState = newResult.isEmpty();
        boolean oldValidStateNoWarnErrors = !this.getResult().hasWarnings() && !this.getResult().hasErrors();
        boolean newValidStateNoWarnErrors = !newResult.hasWarnings() && !newResult.hasErrors();
        super.setResult(newResult);
        this.validState = newValidState;
        this.validStateNoWarnOrErrors = newValidStateNoWarnErrors;
        LOGGER.info("Current validState: {}, validStateNoWarnOrErrors: {}", (Object)this.validState, (Object)this.validStateNoWarnOrErrors);
        this.firePropertyChange(PROPERTY_VALID_STATE, oldValidState, newValidState);
        this.firePropertyChange(PROPERTY_VALID_STATE_NO_WARN_OR_ERRORS, oldValidStateNoWarnErrors, newValidStateNoWarnErrors);
    }

    public void setValidState(boolean valid) {
        if (valid && !this.validStateNoWarnOrErrors) {
            LOGGER.warn("Could not set the valid state because the validStateNoWarnOrErrors is set to false!");
            return;
        }
        boolean oldValidState = this.validState;
        this.validState = valid;
        this.firePropertyChange(PROPERTY_VALID_STATE, oldValidState, this.validState);
    }

    public boolean getValidState() {
        return this.validState;
    }

    public boolean getValidStateNoWarnOrErrors() {
        return this.validStateNoWarnOrErrors;
    }
}

