/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.converter;

import com.jgoodies.binding.value.BindingConverter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToLocalDateTimeConverter
implements BindingConverter<LocalDateTime, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringToLocalDateTimeConverter.class);
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");

    public String targetValue(LocalDateTime sourceValue) {
        if (sourceValue != null) {
            return this.dateTimeFormatter.format(sourceValue);
        }
        return null;
    }

    public LocalDateTime sourceValue(String targetValue) {
        if (StringUtils.isNotBlank((CharSequence)targetValue)) {
            try {
                return LocalDateTime.parse(targetValue, this.dateTimeFormatter);
            }
            catch (Exception ex) {
                LOGGER.warn("Parse string to LocalDateTime failed, value: {}, message: {}", (Object)targetValue, (Object)ex.getMessage());
            }
        }
        return null;
    }
}

