/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.icon;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import org.bidib.wizard.mvc.common.view.icon.AnimatedIcon;

public class PendularMovingIcon
implements AnimatedIcon {
    private Icon icon;
    private double degrees;

    public PendularMovingIcon(Icon icon, double degrees) {
        this.icon = icon;
        this.degrees = degrees;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public double getDegrees() {
        return this.degrees;
    }

    public void setDegrees(double degrees) {
        if (degrees > 359.0) {
            degrees = 359.0;
        }
        if (degrees < 0.0) {
            degrees = 0.0;
        }
        this.degrees = degrees;
    }

    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            int cWidth = (int)(this.degrees > 0.0 ? this.degrees * 85.0 / 360.0 : 0.0);
            int cHeight = (int)(this.degrees > 0.0 ? this.degrees * 50.0 / 360.0 : 0.0);
            int xAdjustment = -3;
            int yAdjustment = -45;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.icon.paintIcon(c, g2, xAdjustment + cWidth, -cHeight - yAdjustment);
        }
        finally {
            g2.dispose();
        }
    }
}

