/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.bidib.jbidibc.messages.utils.CollectionUtils;
import org.bidib.wizard.darrylbu.util.SwingUtils;
import org.bidib.wizard.mvc.common.view.layout.OverlapLayout;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;

public class DisabledPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static DisabledEventQueue queue = new DisabledEventQueue();
    private static Map<Container, List<JComponent>> containers = new HashMap();
    private JComponent glassPane;

    public DisabledPanel(Container container) {
        this(container, null);
    }

    public DisabledPanel(Container container, Color disabledColor) {
        this.setLayout((LayoutManager)new OverlapLayout());
        this.add((Component)container);
        this.glassPane = new GlassPane(this);
        this.add((Component)this.glassPane);
        if (disabledColor != null) {
            this.glassPane.setBackground(disabledColor);
        }
    }

    public Color getDisabledColor() {
        return this.glassPane.getBackground();
    }

    public void setDisabledColor(Color disabledColor) {
        this.glassPane.setBackground(disabledColor);
    }

    public JComponent getGlassPane() {
        return this.glassPane;
    }

    public void setGlassPane(JComponent glassPane) {
        this.glassPane = glassPane;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.glassPane.setVisible(false);
            this.setFocusCycleRoot(false);
            queue.removePanel(this);
        } else {
            this.glassPane.setVisible(true);
            this.setFocusCycleRoot(true);
            queue.addPanel(this);
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public static void disable(Container container) {
        List components = SwingUtils.getDescendantsOfType(JComponent.class, (Container)container, (boolean)true);
        ArrayList<JComponent> enabledComponents = (ArrayList<JComponent>)containers.get(container);
        if (enabledComponents == null) {
            enabledComponents = new ArrayList<JComponent>();
        }
        for (JComponent component : components) {
            if (!component.isEnabled()) continue;
            enabledComponents.add(component);
            component.setEnabled(false);
        }
        if (CollectionUtils.hasElements(enabledComponents)) {
            containers.put(container, enabledComponents);
        }
    }

    public static void enable(Container container) {
        List enabledComponents = (List)containers.get(container);
        if (enabledComponents != null) {
            for (JComponent component : enabledComponents) {
                component.setEnabled(true);
            }
            containers.remove(container);
        }
    }

    public void setDisabledOverlayComponent(JComponent comp) {
        if (this.glassPane instanceof GlassPane) {
            ((GlassPane)this.glassPane).setDisabledOverlayComponent(comp);
        }
    }
}

