/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.text;

import java.awt.event.KeyListener;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListModelEditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListModelEditor.class);

    public void open(DefaultListModel listModel) {
        LOGGER.info("Open editor for listModel: {}", (Object)listModel);
        DefaultTableModel tableModel = this.createTableModel(listModel);
        JTable table = new JTable(tableModel);
        table.setToolTipText("Move: PgUp/PgDown; Edit: Double-Click or Insert/Delete");
        table.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        int result = JOptionPane.showConfirmDialog(null, table, "Change History", 2);
        if (result == 0) {
            this.updatelistModel(listModel, tableModel);
        }
    }

    private DefaultTableModel createTableModel(DefaultListModel listModel) {
        Object[][] tableRowData = new String[listModel.size()][1];
        for (int i = 0; i < listModel.size(); ++i) {
            tableRowData[i][0] = listModel.get(i);
        }
        return new DefaultTableModel(tableRowData, new String[]{""});
    }

    private void updatelistModel(DefaultListModel listModel, DefaultTableModel tableModel) {
        listModel.removeAllElements();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            Object cellText = tableModel.getValueAt(i, 0);
            if (cellText == null || cellText.equals("")) continue;
            listModel.addElement(cellText);
        }
    }
}

