/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.features.view.panel;

import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.StyleModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.bidib.jbidibc.core.schema.BidibFactory;
import org.bidib.jbidibc.core.schema.bidib2.DocumentationType;
import org.bidib.jbidibc.core.schema.bidib2.FeatureCode;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.utils.ConversionUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.mvc.features.view.panel.FeatureTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureTableModel
extends AbstractTableModel
implements StyleModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureTableModel.class);
    private static final long serialVersionUID = 1L;
    public static final int COLUMN_FEATURE_NAME = 0;
    public static final int COLUMN_FEATURE_ID = 1;
    public static final int COLUMN_FEATURE_VALUE = 2;
    public static final int COLUMN_FEATURE_UNIT = 3;
    private List<FeatureCode> featureCodes;
    private static final String[] _COLUMN_NAMES_ = new String[]{Resources.getString(FeatureTableModel.class, (String)"featureName"), Resources.getString(FeatureTableModel.class, (String)"featureId"), Resources.getString(FeatureTableModel.class, (String)"value"), Resources.getString(FeatureTableModel.class, (String)"unit")};
    private List<Feature> features = new LinkedList();
    private String lang;
    private final CellStyle cellStyle = new CellStyle();

    public FeatureTableModel() {
        this.featureCodes = BidibFactory.getFeatureCodes();
        this.lang = XmlLocaleUtils.getXmlLocale();
        LOGGER.info("Fetched the lang for feature description: {}", (Object)this.lang);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 2;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 2) {
            return Integer.class;
        }
        return super.getColumnClass(columnIndex);
    }

    public void updateRow(Feature feature) {
        if (this.features.contains(feature)) {
            LOGGER.debug("Feature is already in list and will be removed: {}", (Object)feature);
            this.features.remove(feature);
        }
        Feature copy = new Feature(feature.getType(), feature.getValue());
        this.features.add(copy);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return _COLUMN_NAMES_.length;
    }

    @Override
    public String getColumnName(int column) {
        return _COLUMN_NAMES_[column];
    }

    @Override
    public int getRowCount() {
        return this.features.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Feature feature = (Feature)this.features.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.getFeatureName(feature);
            }
            case 1: {
                return feature.getFeatureName();
            }
            case 3: {
                return this.getFeatureUnit(feature);
            }
        }
        return feature;
    }

    private String getFeatureName(Feature feature) {
        String featureName;
        FeatureCode featureCode = (FeatureCode)IterableUtils.find((Iterable)this.featureCodes, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        if (featureCode != null && StringUtils.isNotEmpty((CharSequence)(featureName = this.getDocumentationText(featureCode.getDocumentation(), this.lang)))) {
            return featureName;
        }
        return feature.getFeatureName();
    }

    private String getFeatureDescription(Feature feature) {
        String featureName;
        FeatureCode featureCode = (FeatureCode)IterableUtils.find((Iterable)this.featureCodes, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        if (featureCode != null && StringUtils.isNotEmpty((CharSequence)(featureName = this.getDocumentationDescription(featureCode.getDocumentation(), this.lang)))) {
            return featureName;
        }
        return feature.getFeatureName();
    }

    private String getFeatureUnit(Feature feature) {
        String featureUnit;
        FeatureCode featureCode;
        if (feature.getFeatureEnum() != null) {
            switch (4.$SwitchMap$org$bidib$jbidibc$messages$enums$FeatureEnum[feature.getFeatureEnum().ordinal()]) {
                case 1: {
                    return String.format("%d mA", ConversionUtils.convertCurrent((int)feature.getValue()));
                }
            }
        }
        if ((featureCode = (FeatureCode)IterableUtils.find((Iterable)this.featureCodes, (Predicate)new /* Unavailable Anonymous Inner Class!! */)) != null && StringUtils.isNotEmpty((CharSequence)(featureUnit = featureCode.getUnit()))) {
            return featureUnit;
        }
        return null;
    }

    private String getDocumentationText(List<DocumentationType> descriptions, String lang) {
        if (descriptions != null) {
            for (DocumentationType description : descriptions) {
                if (!lang.equals(description.getLanguage())) continue;
                return description.getText();
            }
        }
        return null;
    }

    private String getDocumentationDescription(List<DocumentationType> descriptions, String lang) {
        if (descriptions != null) {
            for (DocumentationType description : descriptions) {
                if (!lang.equals(XmlLocaleUtils.stripMainLanguage((String)description.getLanguage()))) continue;
                return description.getDescription();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Feature feature = (Feature)this.features.get(rowIndex);
        switch (columnIndex) {
            case 2: {
                this.setFeatureValue(feature, value);
                break;
            }
        }
    }

    private void setFeatureValue(Feature feature, Object value) {
        if (value instanceof String) {
            try {
                feature.setValue(Integer.parseInt((String)value));
            }
            catch (Exception ex) {
                LOGGER.warn("Set the new feature value from string failed.", (Throwable)ex);
            }
        } else if (value instanceof Integer) {
            feature.setValue(((Integer)value).intValue());
        }
    }

    public Feature getRowAt(int rowIndex) {
        Feature feature = (Feature)this.features.get(rowIndex);
        return feature;
    }

    public void clear() {
        this.features.clear();
        this.fireTableDataChanged();
    }

    public List<Feature> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public CellStyle getCellStyleAt(int rowIndex, int columnIndex) {
        if (columnIndex < 2) {
            Feature feature = this.getRowAt(rowIndex);
            String toolTipText = this.getFeatureDescription(feature);
            toolTipText = WordUtils.wrap((String)toolTipText, (int)100, (String)"<br/>", (boolean)true);
            this.cellStyle.setToolTipText("<html>" + toolTipText + "</html>");
            return this.cellStyle;
        }
        return null;
    }

    public boolean isCellStyleOn() {
        return true;
    }
}

