/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.features.view.panel;

import com.jidesoft.grid.RowStripeTableStyleProvider;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableStyleProvider;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.wizard.mvc.features.model.FeaturesModel;
import org.bidib.wizard.mvc.features.model.listener.FeatureListener;
import org.bidib.wizard.mvc.features.view.panel.FeatureAwareEditor;
import org.bidib.wizard.mvc.features.view.panel.FeatureAwareRenderer;
import org.bidib.wizard.mvc.features.view.panel.FeatureTableModel;
import org.bidib.wizard.mvc.features.view.panel.listener.FeaturesWriteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesPanel.class);
    private final Set<FeaturesWriteListener> listeners = new LinkedHashSet();
    private FeatureTableModel featureTableModel;
    private SortableTable table;
    private final FeaturesModel model;
    int featuresAdded = 0;

    public FeaturesPanel(FeaturesModel model) {
        this.model = model;
        this.featureTableModel = new FeatureTableModel();
        this.table = new SortableTable((TableModel)this.featureTableModel);
        this.table.getColumnModel().getColumn(2).setCellEditor((TableCellEditor)new FeatureAwareEditor());
        this.table.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)new FeatureAwareRenderer());
        RowStripeTableStyleProvider tableStyleProvider = new RowStripeTableStyleProvider(new Color[]{UIManager.getColor("tableRowStripe.background"), UIManager.getColor("tableRowStripe.alternativeBackground")});
        this.table.setTableStyleProvider((TableStyleProvider)tableStyleProvider);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.table.setRowHeight(this.table.getRowHeight() + 4);
        this.add((Component)this.table);
        model.addFeatureListener((FeatureListener)new /* Unavailable Anonymous Inner Class!! */);
        this.table.sortColumn(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(400);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.showFeatures((Collection)model.getFeatures());
    }

    public void addFeaturesWriteListener(FeaturesWriteListener listener) {
        this.listeners.add(listener);
    }

    public void showFeatures(Collection<Feature> features) {
        LOGGER.debug("Show features: {}", features);
        this.featureTableModel.clear();
        for (Feature feature : features) {
            LOGGER.debug("Add feature: {}", (Object)feature);
            this.showFeature(feature);
        }
    }

    public JTable getTable() {
        return this.table;
    }

    private void showFeature(Feature feature) {
        LOGGER.debug("Show feature: {}", (Object)feature);
        this.featureTableModel.updateRow(feature);
    }

    public void writeFeatures() {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
        }
        List features = this.featureTableModel.getFeatures();
        Collection featuresToWrite = this.model.prepareUpdateFeatures((Collection)features);
        this.fireWrite(featuresToWrite);
        this.model.setFeatures(featuresToWrite);
    }

    private void fireWrite(Collection<Feature> features) {
        for (FeaturesWriteListener l : this.listeners) {
            l.write(features);
        }
    }
}

