/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.locolist.view;

import com.jgoodies.binding.list.SelectionInList;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.mvc.locolist.controller.listener.LocoTableControllerListener;
import org.bidib.wizard.mvc.locolist.model.LocoTableModel;
import org.bidib.wizard.mvc.locolist.view.wizard.PushToMouseWizard;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoListMenu
extends BasicPopupMenu {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoListMenu.class);
    private JMenuItem pushToMouseItem;
    private JMenuItem openLocoDialog;
    private JMenuItem openPomDialog;
    private JMenuItem deleteLocoItem;
    private final SelectionInList<LocoListModel> locoSelection;
    private final LocoTableControllerListener locoTableController;
    private final LocoTableModel locoTableModel;
    private final Component parent;

    public LocoListMenu(Component parent, LocoTableControllerListener locoTableController, SelectionInList<LocoListModel> locoSelection, LocoTableModel locoTableModel) {
        this.parent = parent;
        this.locoTableController = locoTableController;
        this.locoSelection = locoSelection;
        this.locoTableModel = locoTableModel;
        this.openLocoDialog = new JMenuItem(Resources.getString(LocoListMenu.class, (String)"openLocoDialog") + " ...");
        this.openLocoDialog.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.openLocoDialog);
        this.openPomDialog = new JMenuItem(Resources.getString(LocoListMenu.class, (String)"openPomDialog") + " ...");
        this.openPomDialog.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.openPomDialog);
        this.pushToMouseItem = new JMenuItem(Resources.getString(this.getClass(), (String)"pushToMouse") + " ...");
        this.pushToMouseItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.pushToMouseItem);
        this.addSeparator();
        this.deleteLocoItem = new JMenuItem(Resources.getString(this.getClass(), (String)"deleteLoco") + " ...");
        this.deleteLocoItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.deleteLocoItem);
    }

    private void fireOpenLocoDialog(LocoListModel locoModel) {
        this.locoTableController.openLocoDialog(locoModel);
    }

    private void fireOpenPomDialog(LocoListModel locoModel) {
        this.locoTableController.openPomDialog(locoModel);
    }

    private void firePushToMouse() {
        PushToMouseWizard nodeScriptWizard = new PushToMouseWizard();
        nodeScriptWizard.showWizard(this.locoTableController, this.locoTableModel);
    }

    private void fireDeleteLoco(LocoListModel locoModel) {
        boolean delete = TaskDialogs.ask((Window)JOptionPane.getFrameForComponent(this.parent), (String)Resources.getString(LocoListMenu.class, (String)"deleteLoco"), (String)Resources.getString(LocoListMenu.class, (String)"deleteLocoText", (Object[])new Object[]{locoModel.getAddress()}));
        if (delete) {
            this.locoTableController.deleteLoco(locoModel);
        }
    }
}

