/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.mvc.main.model.BacklightPortTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.BacklightPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class BacklightPortPanelController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BacklightPortPanelController.class);
    private final MainModel mainModel;
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    private BacklightPortListPanel backlightPortListPanel;
    private final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject = PublishSubject.create();
    private CompositeDisposable compDisp;

    public BacklightPortPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
        this.compDisp = new CompositeDisposable();
    }

    public BacklightPortListPanel createPanel(TabVisibilityListener tabVisibilityListener) {
        BacklightPortTableModel tableModel = new BacklightPortTableModel();
        tableModel.setPortListener((PortModelListener)new /* Unavailable Anonymous Inner Class!! */);
        this.backlightPortListPanel = new BacklightPortListPanel(this, tableModel, this.mainModel, tabVisibilityListener, this.portConfigChangeEventSubject);
        this.backlightPortListPanel.setPortListener((PortListener)new /* Unavailable Anonymous Inner Class!! */);
        this.mainModel.addNodeListListener((NodeListListener)new /* Unavailable Anonymous Inner Class!! */);
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null) {
            this.addBacklightPortModelListener(selectedNode);
        }
        return this.backlightPortListPanel;
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.mainModel.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels() {
        try {
            long uniqueId = this.mainModel.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save backlight labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.backlightPortListPanel != null) {
            SwingUtilities.invokeLater(() -> this.backlightPortListPanel.refreshView());
        }
    }

    private void addBacklightPortModelListener(NodeInterface selectedNode) {
        LOGGER.info("Add backlight port model listener for node: {}", (Object)selectedNode);
        Disposable disp = this.portConfigChangeEventSubject.subscribe(evt -> {
            LOGGER.info("Received event: {}", evt);
            PortTypeAware port = evt.getPort();
            try {
                BacklightPort backlightPort = new BacklightPort();
                backlightPort.setId(port.getPortNumber().intValue());
                LOGGER.info("Prepared backlight port: {}", (Object)backlightPort);
                this.switchingNodeService.setPortConfig("main", selectedNode.getSwitchingNode(), (Port)backlightPort, null, evt.getPortConfig());
            }
            catch (Exception ex) {
                LOGGER.warn("Set the backlight port config failed.", (Throwable)ex);
                selectedNode.setNodeHasError(true);
                selectedNode.setReasonData("Set the backlight port config failed.");
            }
        });
        this.compDisp.add(disp);
    }
}

