/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.exchange.NodeExchangeHelper;
import org.bidib.wizard.mvc.main.view.panel.FlagListPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class FlagPanelController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlagPanelController.class);
    private final MainModel mainModel;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    private FlagListPanel flagListPanel;

    public FlagPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
    }

    public FlagListPanel createFlagListPanel() {
        this.flagListPanel = new FlagListPanel(this, this.mainModel);
        return this.flagListPanel;
    }

    public void setFlagLabel(int flagId, String label) {
        LOGGER.info("Set the flag label: {}", (Object)label);
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            try {
                NodeLabels nodeLabels = this.getNodeLabels();
                BidibLabelUtils.replaceFlagLabel((NodeLabels)nodeLabels, (int)flagId, (String)label);
                this.saveLabels();
            }
            catch (Exception ex) {
                LOGGER.warn("Save feedback labels failed.", (Throwable)ex);
                String labelPath = ex.getMessage();
                JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.message", (Object[])new Object[]{labelPath}), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.title"), 0);
                throw new RuntimeException(ex);
            }
        } else {
            LOGGER.warn("No node selected, labels are not stored.");
        }
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.mainModel.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels() {
        try {
            long uniqueId = this.mainModel.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save accessory labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.flagListPanel != null) {
            SwingUtilities.invokeLater(() -> this.flagListPanel.refreshView());
        }
    }
}

