/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.SwitchingNodeInterface;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.script.Scripting;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.script.DefaultScriptContext;
import org.bidib.wizard.common.script.common.WaitCommand;
import org.bidib.wizard.common.script.engine.ScriptEngine;
import org.bidib.wizard.common.script.switching.PortScripting;
import org.bidib.wizard.common.script.switching.SoundPortCommand;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.mvc.main.controller.wrapper.NodePortWrapper;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.SoundPortTableModel;
import org.bidib.wizard.mvc.main.view.panel.SoundPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class SoundPortPanelController
implements PortScripting {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoundPortPanelController.class);
    private final MainModel mainModel;
    private SoundPortListPanel soundPortListPanel;
    private final Map<NodeInterface, NodePortWrapper> testToggleRegistry = new LinkedHashMap();
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private ConsoleService consoleService;
    private final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject = PublishSubject.create();
    private CompositeDisposable compDisp;

    public SoundPortPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
        this.compDisp = new CompositeDisposable();
    }

    public SoundPortListPanel createPanel(TabVisibilityListener tabVisibilityListener) {
        SoundPortTableModel tableModel = new SoundPortTableModel();
        tableModel.setPortListener((PortModelListener)new /* Unavailable Anonymous Inner Class!! */);
        SoundPortListPanel soundPortListPanel = new SoundPortListPanel(this, tableModel, this.mainModel, tabVisibilityListener, this.portConfigChangeEventSubject);
        soundPortListPanel.setPortListener((PortListener)new /* Unavailable Anonymous Inner Class!! */);
        this.mainModel.addNodeListListener((NodeListListener)new /* Unavailable Anonymous Inner Class!! */);
        this.soundPortListPanel = soundPortListPanel;
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null) {
            this.addSoundPortModelListener(selectedNode);
        }
        return soundPortListPanel;
    }

    public void addTestToggleTask(NodeInterface node, Port<?> port) {
        LOGGER.info("Add test toggle task for node: {}, port: {}", (Object)node, port);
        NodePortWrapper nodePortWrapper = (NodePortWrapper)this.testToggleRegistry.remove(node);
        ScriptEngine scriptEngine = null;
        if (nodePortWrapper != null) {
            scriptEngine = nodePortWrapper.removePort(port);
        }
        if (scriptEngine != null) {
            LOGGER.info("Found a node scripting engine in the registry: {}", (Object)scriptEngine);
            try {
                scriptEngine.stopScript(Long.valueOf(2000L));
            }
            catch (Exception ex) {
                LOGGER.warn("Stop script failed.", (Throwable)ex);
            }
        }
        DefaultScriptContext context = new DefaultScriptContext();
        context.register("selectedNode", (Object)node);
        context.register("mainModel", (Object)this.mainModel);
        scriptEngine = new ScriptEngine((Scripting)this, (ApplicationContext)context);
        LinkedList<Object> scriptCommands = new LinkedList<Object>();
        SoundPortCommand spc = new SoundPortCommand(this.consoleService);
        spc.parse("sound " + port.getId() + " PLAY");
        scriptCommands.add(spc);
        WaitCommand wc = new WaitCommand(this.consoleService);
        wc.parse("wait 2000");
        scriptCommands.add(wc);
        spc = new SoundPortCommand(this.consoleService);
        spc.parse("sound " + port.getId() + " STOP");
        scriptCommands.add(spc);
        wc = new WaitCommand(this.consoleService);
        wc.parse("wait 2000");
        scriptCommands.add(wc);
        LOGGER.info("Prepared list of commands: {}", scriptCommands);
        scriptEngine.setScriptCommands(scriptCommands);
        scriptEngine.setScriptRepeating(true);
        if (nodePortWrapper == null) {
            LOGGER.info("Create new NodePortWrapper for node: {}", (Object)node);
            nodePortWrapper = new NodePortWrapper(node);
        }
        LOGGER.info("Put script engine in registry for node: {}", (Object)node);
        nodePortWrapper.addPort(port, scriptEngine);
        this.testToggleRegistry.put(node, nodePortWrapper);
        scriptEngine.startScript();
    }

    public void stopTestToggleTask(NodeInterface node, Port<?> port) {
        LOGGER.info("Stop test toggle task for node: {}, port: {}", (Object)node, port);
        NodePortWrapper nodePortWrapper = (NodePortWrapper)this.testToggleRegistry.get(node);
        if (nodePortWrapper != null) {
            HashSet toRemove = new HashSet();
            if (port != null) {
                toRemove.add(port);
            } else {
                toRemove.addAll(nodePortWrapper.getKeySet());
            }
            for (Port port2 : toRemove) {
                ScriptEngine engine = nodePortWrapper.removePort(port2);
                if (engine != null) {
                    LOGGER.info("Found a node scripting engine in the registry: {}", (Object)engine);
                    try {
                        engine.stopScript(Long.valueOf(2000L));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Stop script failed.", (Throwable)ex);
                    }
                    continue;
                }
                LOGGER.warn("No scripting engine found for node: {}", (Object)node);
            }
            if (nodePortWrapper.isEmpty()) {
                LOGGER.info("No more ports registered for node: {}", (Object)node);
                this.testToggleRegistry.remove(node);
            }
        }
    }

    public void sendPortStatusAction(SwitchingNodeInterface node, LcOutputType lcOutputType, int port, BidibStatus portStatus) {
        LOGGER.info("Sound action on the port: {}, portStatus: {}", (Object)port, (Object)portStatus);
        try {
            SwitchingNodeInterface selectedNode = node != null ? node : this.mainModel.getSelectedNode().getSwitchingNode();
            SoundPortStatus soundPortStatus = (SoundPortStatus)portStatus;
            SoundPort soundPortPort = new SoundPort();
            soundPortPort.setId(port);
            soundPortPort.setStatus((BidibStatus)soundPortStatus);
            this.switchingNodeService.setPortStatus("main", selectedNode, (Port)soundPortPort);
        }
        catch (Exception ex) {
            LOGGER.warn("Activate sound port failed.", (Throwable)ex);
        }
    }

    public void sendPortValueAction(SwitchingNodeInterface node, LcOutputType lcOutputType, int port, int portValue) {
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.mainModel.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels() {
        try {
            long uniqueId = this.mainModel.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save backlight labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.soundPortListPanel != null) {
            SwingUtilities.invokeLater(() -> this.soundPortListPanel.refreshView());
        }
    }

    private void addSoundPortModelListener(NodeInterface selectedNode) {
        LOGGER.info("Add sound port model listener for node: {}", (Object)selectedNode);
        Disposable disp = this.portConfigChangeEventSubject.subscribe(evt -> {
            LOGGER.info("Received event: {}", evt);
            PortTypeAware port = evt.getPort();
            try {
                SoundPort soundPort = new SoundPort();
                soundPort.setId(port.getPortNumber().intValue());
                LOGGER.info("Prepared sound port: {}", (Object)soundPort);
                this.switchingNodeService.setPortConfig("main", selectedNode.getSwitchingNode(), (Port)soundPort, null, evt.getPortConfig());
            }
            catch (Exception ex) {
                LOGGER.warn("Set the soundport config failed.", (Throwable)ex);
                selectedNode.setNodeHasError(true);
                selectedNode.setReasonData("Set the soundport config failed.");
            }
        });
        this.compDisp.add(disp);
    }
}

