/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import java.util.List;
import java.util.Objects;
import javax.swing.table.DefaultTableModel;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Flag;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroSaveState;
import org.bidib.wizard.api.model.function.AccessoryOkayFunction;
import org.bidib.wizard.api.model.function.BacklightPortAction;
import org.bidib.wizard.api.model.function.Delayable;
import org.bidib.wizard.api.model.function.FlagFunction;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.api.model.function.InputFunction;
import org.bidib.wizard.api.model.function.MacroFunction;
import org.bidib.wizard.api.model.function.MotorPortAction;
import org.bidib.wizard.api.model.function.PortAware;
import org.bidib.wizard.api.model.function.RandomDelayFunction;
import org.bidib.wizard.api.model.function.ServoMoveQueryFunction;
import org.bidib.wizard.api.model.function.ServoPortAction;
import org.bidib.wizard.api.model.listener.MacroListener;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.status.AccessoryOkayStatus;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.MacroStatus;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.table.Reorderable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroTableModel
extends DefaultTableModel
implements MacroListener,
Reorderable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroTableModel.class);
    private static final long serialVersionUID = 1L;
    public static final int COLUMN_STEP = 0;
    public static final int COLUMN_DELAY = 1;
    public static final int COLUMN_PORT_TYPE = 2;
    public static final int COLUMN_ACTION = 3;
    public static final int COLUMN_PORT_NUMBER = 4;
    public static final int COLUMN_EXTRA = 5;
    private String[] columnNames;
    private Macro macro;
    private final MainModel model;

    public MacroTableModel(MainModel model) {
        this.model = model;
        this.initialize();
        this.setColumnIdentifiers((Object[])this.columnNames);
    }

    protected void initialize() {
        this.columnNames = new String[]{Resources.getString(this.getClass(), (String)"step"), Resources.getString(this.getClass(), (String)"delay"), Resources.getString(this.getClass(), (String)"portType"), Resources.getString(this.getClass(), (String)"action"), Resources.getString(this.getClass(), (String)"portNumber"), Resources.getString(this.getClass(), (String)"extra")};
    }

    private void addRow(Function<? extends BidibStatus> function, int functionIndex) {
        Object[] rowData = new Object[this.columnNames.length];
        for (int column = 0; column < this.columnNames.length; ++column) {
            rowData[column] = this.getRowData(column, function, functionIndex);
        }
        this.addRow(rowData);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Object.class;
            }
            case 3: {
                return Object.class;
            }
            case 4: {
                return Object.class;
            }
            case 5: {
                return Integer.class;
            }
        }
        return String.class;
    }

    private Object getRowData(int column, Function<? extends BidibStatus> function, int functionIndex) {
        Object result = null;
        switch (column) {
            case 0: {
                result = Integer.toString(functionIndex + 1);
                break;
            }
            case 1: {
                if (function == null) break;
                if (function instanceof Delayable) {
                    result = ((Delayable)function).getDelay();
                    break;
                }
                if (!(function instanceof RandomDelayFunction)) break;
                result = ((RandomDelayFunction)function).getMaximumValue();
                break;
            }
            case 2: {
                result = function;
                break;
            }
            case 3: {
                if (function == null) break;
                result = function.getAction();
                break;
            }
            case 4: {
                if (function == null) break;
                LOGGER.info("Current function: {}", function);
                if (function instanceof AccessoryOkayFunction) {
                    result = ((AccessoryOkayFunction)function).getInput();
                    break;
                }
                if (function instanceof InputFunction) {
                    result = ((InputFunction)function).getInput();
                    break;
                }
                if (function instanceof MacroFunction) {
                    result = this.model.getMacros().get(((MacroFunction)function).getMacroId());
                    break;
                }
                if (function instanceof FlagFunction) {
                    result = ((FlagFunction)function).getFlag();
                    break;
                }
                if (!(function instanceof PortAware)) break;
                result = ((PortAware)function).getPort();
                break;
            }
            case 5: {
                if (function == null) break;
                if (function instanceof ServoPortAction) {
                    result = ((ServoPortAction)function).getValue();
                    break;
                }
                if (function instanceof BacklightPortAction) {
                    result = ((BacklightPortAction)function).getValue();
                    break;
                }
                if (!(function instanceof MotorPortAction)) break;
                result = ((MotorPortAction)function).getValue();
            }
        }
        return result;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = super.getValueAt(row, column);
        if (result != null && column == 5) {
            MotorPort port;
            Function function = this.macro.getFunction(row);
            if (function instanceof ServoPortAction) {
                ServoPort port2 = (ServoPort)((ServoPortAction)function).getPort();
                if (port2 != null) {
                    result = ServoPort.getRelativeValue((int)Integer.parseInt(result.toString()));
                }
            } else if (function instanceof BacklightPortAction) {
                BacklightPort port3 = (BacklightPort)((BacklightPortAction)function).getPort();
                if (port3 != null) {
                    result = BacklightPort.getRelativeValue((int)Integer.parseInt(result.toString()));
                }
            } else if (function instanceof MotorPortAction && (port = (MotorPort)((MotorPortAction)function).getPort()) != null) {
                result = Integer.parseInt(result.toString());
            }
        }
        return result;
    }

    private void insertRow(int row, Function<? extends BidibStatus> function, int functionIndex) {
        Object[] rowData = new Object[this.columnNames.length];
        for (int column = 0; column < this.columnNames.length; ++column) {
            rowData[column] = this.getRowData(column, function, functionIndex);
        }
        this.insertRow(row, rowData);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        boolean editable = true;
        switch (column) {
            case 5: {
                ServoPort port;
                Function function = this.macro.getFunction(row);
                if (!(function instanceof ServoPortAction) || (port = (ServoPort)((ServoPortAction)function).getPort()) != null) break;
                editable = false;
                break;
            }
        }
        return editable;
    }

    private void renumberSteps() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            Object rowData = this.getRowData(0, (Function)this.getValueAt(row, 2), row);
            rowData = Integer.toString(row + 1);
            this.setValueAt(rowData, row, 0);
        }
    }

    public void setMacro(Macro macro) {
        LOGGER.debug("Set the macro: {}", (Object)macro);
        this.setRowCount(0);
        if (this.macro != null) {
            this.macro.removeMacroListener((MacroListener)this);
        }
        this.macro = macro;
        if (macro != null) {
            for (int index = 0; index < macro.getFunctionCount(); ++index) {
                this.addRow(macro.getFunction(index), index);
            }
            macro.addMacroListener((MacroListener)this);
        }
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        boolean valueChanged = false;
        switch (column) {
            case 1: {
                Function function = this.macro.getFunction(row);
                if (function instanceof Delayable) {
                    int delayValue = Integer.parseInt(value.toString());
                    if (delayValue != ((Delayable)function).getDelay()) {
                        ((Delayable)function).setDelay(delayValue);
                        valueChanged = true;
                    }
                    super.setValueAt(value, row, column);
                    break;
                }
                if (!(function instanceof RandomDelayFunction)) break;
                int maxValue = Integer.parseInt(value.toString());
                if (maxValue != ((RandomDelayFunction)function).getMaximumValue()) {
                    ((RandomDelayFunction)function).setMaximumValue(maxValue);
                    valueChanged = true;
                }
                super.setValueAt(value, row, column);
                break;
            }
            case 2: {
                if (value != null && (this.macro.getFunction(row) == null || value.getClass() != this.macro.getFunction(row).getClass())) {
                    try {
                        Function function = (Function)((Function)value).clone();
                        this.macro.replaceFunction(row, function);
                        for (int col = this.columnNames.length - 1; col > 0; --col) {
                            super.setValueAt(this.getRowData(col, function, row), row, col);
                        }
                        valueChanged = true;
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Set new functions for selected port type failed.");
                        throw new RuntimeException(e);
                    }
                }
                LOGGER.info("Port type has not been changed.");
                break;
            }
            case 3: {
                Function function = this.macro.getFunction(row);
                if (function != null) {
                    if (Objects.equals(value, function.getAction())) break;
                    LOGGER.info("The macro action has been changed: {}", value);
                    BidibStatus macroStatus = (BidibStatus)value;
                    function.setAction(macroStatus);
                    if (function instanceof AccessoryOkayFunction) {
                        if (AccessoryOkayStatus.NO_FEEDBACK.equals((Object)((AccessoryOkayFunction)function).getAction())) {
                            ((AccessoryOkayFunction)function).setInput((InputPort)null);
                            super.setValueAt(null, row, column + 1);
                        } else {
                            Object currentValue = this.getValueAt(row, column + 1);
                            ((AccessoryOkayFunction)function).setInput((InputPort)currentValue);
                            super.setValueAt(currentValue, row, column + 1);
                        }
                    } else if (function instanceof ServoMoveQueryFunction) {
                        Object currentValue = this.getValueAt(row, column + 1);
                        ((ServoMoveQueryFunction)function).setPort((ServoPort)currentValue);
                        super.setValueAt(currentValue, row, column + 1);
                    } else if (function instanceof MacroFunction) {
                        if (MacroStatus.END.equals((Object)((MacroFunction)function).getAction())) {
                            ((MacroFunction)function).setMacroId(0);
                            super.setValueAt(null, row, column + 1);
                        } else {
                            Object currentValue = this.getValueAt(row, column + 1);
                            if (currentValue instanceof Macro) {
                                ((MacroFunction)function).setMacroId(((Macro)currentValue).getId());
                            } else {
                                ((MacroFunction)function).setMacroId(0);
                            }
                            super.setValueAt(currentValue, row, column + 1);
                        }
                    }
                    super.setValueAt(value, row, column);
                    valueChanged = true;
                    break;
                }
                LOGGER.info("No function available.");
                break;
            }
            case 4: {
                Function function = this.macro.getFunction(row);
                if (function instanceof AccessoryOkayFunction) {
                    if (Objects.equals(((AccessoryOkayFunction)function).getInput(), value)) break;
                    ((AccessoryOkayFunction)function).setInput((InputPort)value);
                    super.setValueAt(value, row, column);
                    valueChanged = true;
                    break;
                }
                if (function instanceof InputFunction) {
                    if (Objects.equals(((InputFunction)function).getInput(), value)) break;
                    ((InputFunction)function).setInput((InputPort)value);
                    super.setValueAt(value, row, column);
                    valueChanged = true;
                    break;
                }
                if (function instanceof MacroFunction) {
                    List macros = this.model.getMacros();
                    int index = macros.indexOf(value);
                    if (Objects.equals(((MacroFunction)function).getMacroId(), index)) break;
                    LOGGER.info("Set the macro at index: {}", (Object)index);
                    ((MacroFunction)function).setMacroId(index);
                    super.setValueAt(value, row, column);
                    valueChanged = true;
                    break;
                }
                if (function instanceof FlagFunction) {
                    FlagFunction flagFunction = (FlagFunction)function;
                    if (Objects.equals(flagFunction.getFlag(), value)) break;
                    flagFunction.setFlag((Flag)value);
                    super.setValueAt(value, row, column);
                    valueChanged = true;
                    break;
                }
                if (!(function instanceof PortAware) || Objects.equals(((PortAware)function).getPort(), value)) break;
                ((PortAware)function).setPort((Port)value);
                super.setValueAt(value, row, column);
                valueChanged = true;
                break;
            }
            case 5: {
                MotorPort port;
                Function function = this.macro.getFunction(row);
                if (function instanceof ServoPortAction) {
                    ServoPort port2 = (ServoPort)((ServoPortAction)function).getPort();
                    if (port2 == null) break;
                    int intValue = ServoPort.getAbsoluteValue((int)Integer.parseInt(value.toString()));
                    int oldValue = ((ServoPortAction)function).getValue();
                    if (oldValue == intValue) break;
                    ((ServoPortAction)function).setValue(intValue);
                    super.setValueAt(intValue, row, column);
                    valueChanged = true;
                    break;
                }
                if (function instanceof BacklightPortAction) {
                    BacklightPort port3 = (BacklightPort)((BacklightPortAction)function).getPort();
                    if (port3 == null) break;
                    int intValue = BacklightPort.getAbsoluteValue((int)Integer.parseInt(value.toString()));
                    int oldValue = ((BacklightPortAction)function).getValue();
                    if (oldValue == intValue) break;
                    ((BacklightPortAction)function).setValue(intValue);
                    super.setValueAt(intValue, row, column);
                    valueChanged = true;
                    break;
                }
                if (!(function instanceof MotorPortAction) || (port = (MotorPort)((MotorPortAction)function).getPort()) == null) break;
                int intValue = Integer.parseInt(value.toString());
                int oldValue = ((MotorPortAction)function).getValue();
                if (oldValue == intValue) break;
                ((MotorPortAction)function).setValue(intValue);
                super.setValueAt(intValue, row, column);
                valueChanged = true;
                break;
            }
            default: {
                super.setValueAt(value, row, column);
            }
        }
        if (valueChanged) {
            LOGGER.info("The current value was changed, set the pending changes state.");
            this.macro.setMacroSaveState(MacroSaveState.PENDING_CHANGES);
        }
    }

    public void functionsAdded(int macroId, int row, Function<? extends BidibStatus>[] functions) {
        LOGGER.info("functions were added, macroId: {}, row: {}", (Object)macroId, (Object)row);
        SwingUtils.executeInEDT(() -> {
            if (this.macro == null || macroId != this.macro.getId()) {
                LOGGER.info("Functions of other macro were added.");
                return;
            }
            if (functions != null) {
                for (int index = 0; index < functions.length; ++index) {
                    this.insertRow(row + index, functions[index], row);
                }
            } else {
                this.insertRow(row, (Function)null, row);
            }
            this.renumberSteps();
        });
    }

    public void functionRemoved(int macroId, int row) {
        SwingUtils.executeInEDT(() -> {
            if (this.macro == null || macroId != this.macro.getId()) {
                LOGGER.info("Functions of other macro were removed.");
                return;
            }
            this.removeRow(row);
            this.renumberSteps();
        });
    }

    public void functionsRemoved(int macroId) {
        SwingUtils.executeInEDT(() -> {
            if (this.macro == null || macroId != this.macro.getId()) {
                LOGGER.info("Functions of other macro were removed.");
                return;
            }
            this.setRowCount(0);
        });
    }

    public void reorder(int fromIndex, int toIndex, int rowCount) {
        LOGGER.info("reorder, fromIndex: {}, toIndex: {}, rowCount: {}", new Object[]{fromIndex, toIndex, rowCount});
        if (fromIndex < toIndex) {
            for (int row = 0; row < rowCount; ++row) {
                LOGGER.info("I. Move row: {}, fromIndex: {}, toIndex: {}", new Object[]{row, fromIndex, toIndex});
                this.macro.moveFunction(fromIndex, toIndex);
            }
        } else {
            for (int row = 0; row < rowCount; ++row) {
                LOGGER.info("II. Move row: {}, fromIndex: {}, toIndex: {}", new Object[]{row, fromIndex, toIndex});
                this.macro.moveFunction(fromIndex + (rowCount - 1), toIndex);
            }
        }
        this.renumberSteps();
    }

    private void moveRow(int srcRow, int targetRow, Function<? extends BidibStatus> function) {
        Object[] rowData = new Object[this.columnNames.length];
        int functionIndex = 0;
        for (int column = 0; column < this.columnNames.length; ++column) {
            rowData[column] = this.getRowData(column, function, functionIndex);
        }
        LOGGER.info("Remove srcRow: {}, targetRow: {}, rowData: {}", new Object[]{srcRow, targetRow, rowData});
        this.removeRow(srcRow);
        if (targetRow > srcRow) {
            this.insertRow(targetRow, rowData);
        } else {
            this.insertRow(targetRow, rowData);
        }
    }

    public void functionMoved(int macroId, int fromIndex, int toIndex, Function<? extends BidibStatus> fromFunction) {
        SwingUtils.executeInEDT(() -> {
            LOGGER.info("functionMoved, macroId: {}, fromIndex: {}, toIndex: {}, fromFunction: {}", new Object[]{macroId, fromIndex, toIndex, Function.getDebugString((Function)fromFunction)});
            if (this.macro == null || macroId != this.macro.getId()) {
                LOGGER.info("Functions of other macro were moved.");
                return;
            }
            this.moveRow(fromIndex, toIndex, fromFunction);
        });
    }
}

