/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.ThreadedMatcherEditor;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.FeedbackPosition;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.mvc.main.controller.FeedbackPositionPanelController;
import org.bidib.wizard.mvc.main.model.FeedbackPositionModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.FeedbackPositionListPanel;
import org.bidib.wizard.mvc.main.view.panel.glazed.DecodersSelect;
import org.bidib.wizard.mvc.main.view.panel.glazed.FeedbackPositionComparator;
import org.bidib.wizard.mvc.main.view.panel.glazed.FeedbackPositionTableFormat;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackPositionListPanel
implements TabVisibilityProvider,
TabPanelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPositionListPanel.class);
    private static final int EXTRA_VERTICAL_SPACE = 4;
    private final FeedbackPositionPanelController controller;
    private final FeedbackPositionModel feedbackPositionModel;
    private final TabVisibilityListener tabVisibilityListener;
    private DecodersSelect decodersSelect;
    private static final String ENCODED_FILTER_PANEL_COLUMN_SPECS = "70dlu:grow";
    private static final String ENCODED_FILTER_PANEL_ROW_SPECS = "pref, $lg, fill:50dlu:grow, $lg, pref, $lg, pref";
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "fill:50dlu:grow";
    private JPanel contentPanel;
    private final AdvancedTableModel<FeedbackPosition> positionsTableModel;
    private JEditorPane editor;

    public FeedbackPositionListPanel(FeedbackPositionPanelController controller, FeedbackPositionModel feedbackPositionModel, MainModel model, TabVisibilityListener tabVisibilityListener) {
        Object panel;
        Object panel2;
        this.controller = controller;
        this.feedbackPositionModel = feedbackPositionModel;
        this.tabVisibilityListener = tabVisibilityListener;
        LOGGER.debug("Create new FeedbackPositionListPanel.");
        FormBuilder dialogBuilderFilter = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel2 = new FormDebugPanel();
            dialogBuilderFilter = FormBuilder.create().columns(ENCODED_FILTER_PANEL_COLUMN_SPECS, new Object[0]).rows(ENCODED_FILTER_PANEL_ROW_SPECS, new Object[0]).panel((JPanel)panel2);
        } else {
            panel2 = new JPanel(new BorderLayout());
            dialogBuilderFilter = FormBuilder.create().columns(ENCODED_FILTER_PANEL_COLUMN_SPECS, new Object[0]).rows(ENCODED_FILTER_PANEL_ROW_SPECS, new Object[0]).panel((JPanel)panel2);
        }
        FormBuilder dialogBuilder = null;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        EventList feedbackPositionEventList = feedbackPositionModel.getPositionsEventList();
        SortedList sortedFeedbackPositions = new SortedList(feedbackPositionEventList, (Comparator)new FeedbackPositionComparator());
        this.decodersSelect = new DecodersSelect((EventList)sortedFeedbackPositions);
        FilterList filteredFeedbackPositions = new FilterList((EventList)sortedFeedbackPositions, (MatcherEditor)new ThreadedMatcherEditor((MatcherEditor)this.decodersSelect));
        this.positionsTableModel = GlazedListsSwing.eventTableModelWithThreadProxyList((EventList)filteredFeedbackPositions, (TableFormat)new FeedbackPositionTableFormat());
        1 positionsJTable = new /* Unavailable Anonymous Inner Class!! */;
        positionsJTable.getColumnModel().getColumn(4).setCellRenderer((TableCellRenderer)new TimestampCellRenderer());
        positionsJTable.setRowAutoResizes(false);
        positionsJTable.setRowHeight(positionsJTable.getRowHeight() + 4);
        this.editor = new JEditorPane("text/html", this.getEmptyTableText());
        this.editor.setOpaque(false);
        this.editor.setEditable(false);
        this.editor.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        positionsJTable.setLayout((LayoutManager)new GridBagLayout());
        positionsJTable.add((Component)this.editor);
        this.positionsTableModel.addTableModelListener(e -> {
            boolean visible = this.positionsTableModel.getRowCount() == 0;
            this.editor.setVisible(visible);
        });
        TableComparatorChooser tableSorter = TableComparatorChooser.install((JTable)positionsJTable, (SortedList)sortedFeedbackPositions, (Object)TableComparatorChooser.MULTIPLE_COLUMN_MOUSE);
        tableSorter.fromString("column 4 reversed");
        JScrollPane positionsTableScrollPane = new JScrollPane((Component)positionsJTable);
        JList decodersJList = this.decodersSelect.getJList();
        JScrollPane decodersListScrollPane = new JScrollPane(decodersJList);
        JButton clearButton = new JButton(Resources.getString(FeedbackPositionListPanel.class, (String)"label.clear"));
        clearButton.setToolTipText(Resources.getString(FeedbackPositionListPanel.class, (String)"tooltip.clear"));
        clearButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        dialogBuilderFilter.add((Component)new JLabel(Resources.getString(FeedbackPositionListPanel.class, (String)"label.decoder"))).xy(1, 1);
        dialogBuilderFilter.add((Component)decodersListScrollPane).xy(1, 3);
        dialogBuilderFilter.add((Component)clearButton).xy(1, 5);
        dialogBuilder.add((Component)dialogBuilderFilter.build()).xy(1, 1);
        dialogBuilder.add((Component)positionsTableScrollPane).xy(3, 1);
        this.contentPanel = dialogBuilder.build();
        BasicPopupMenu popupMenu = new BasicPopupMenu();
        JMenuItem clearPositionTable = new JMenuItem(Resources.getString(this.getClass(), (String)"clear_table"));
        clearPositionTable.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        popupMenu.add(clearPositionTable);
        positionsJTable.setComponentPopupMenu((JPopupMenu)popupMenu);
        this.contentPanel.setName(this.getName());
    }

    protected void fireClearPositionTable() {
        this.feedbackPositionModel.getPositionsEventList().clear();
    }

    public JPanel getComponent() {
        return this.contentPanel;
    }

    private String getEmptyTableText() {
        return Resources.getString(FeedbackPositionListPanel.class, (String)"emptyTable");
    }

    public String getName() {
        return Resources.getString(this.getClass(), (String)"name");
    }

    public boolean isTabVisible() {
        NodeInterface node = this.feedbackPositionModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = this.hasFeedbackPositions((Collection)node.getNode().getFeatures());
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    public void listChanged() {
        LOGGER.info("List has changed, remove all rows and add rows again.");
        this.tabVisibilityListener.setTabVisible((Component)this.contentPanel, this.isTabVisible());
    }

    private boolean hasFeedbackPositions(Collection<Feature> features) {
        Feature feedbackPositions = Feature.findFeature(features, (int)FeatureEnum.FEATURE_BM_POSITION_ON.getNumber());
        return feedbackPositions != null && feedbackPositions.getValue() > 0;
    }
}

