/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel.renderer;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.main.view.panel.renderer.MacroListRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroListRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroListRenderer.class);
    private ImageIcon bidibErrorIcon = ImageUtils.createImageIcon(MacroListRenderer.class, (String)"/icons/error-leaf.png");
    private ImageIcon pendingChangesIcon = ImageUtils.createImageIcon(MacroListRenderer.class, (String)"/icons/16x16/write.png");
    private ImageIcon savedChangesIcon = ImageUtils.createImageIcon(MacroListRenderer.class, (String)"/icons/16x16/savetonode.png");
    private ImageIcon permanentlyStoredIcon = ImageUtils.createImageIcon(MacroListRenderer.class, (String)"/icons/16x16/lock.png");
    private ImageIcon notLoadedFromNodeIcon = ImageUtils.createImageIcon(MacroListRenderer.class, (String)"/icons/16x16/loadfromnode.png");

    @Override
    public Component getTableCellRendererComponent(JTable list, Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
        Component renderer = super.getTableCellRendererComponent(list, value, isSelected, cellHasFocus, row, column);
        if (value instanceof Macro) {
            Macro macro = (Macro)value;
            if (macro.isContainsError()) {
                LOGGER.info("The current macro contains an error: {}", (Object)macro);
                this.setIcon((Icon)this.bidibErrorIcon);
            } else {
                switch (1.$SwitchMap$org$bidib$wizard$api$model$MacroSaveState[macro.getMacroSaveState().ordinal()]) {
                    case 1: {
                        this.setIcon((Icon)this.notLoadedFromNodeIcon);
                        break;
                    }
                    case 2: {
                        this.setIcon((Icon)this.pendingChangesIcon);
                        break;
                    }
                    case 3: {
                        this.setIcon((Icon)this.savedChangesIcon);
                        break;
                    }
                    case 4: {
                        this.setIcon((Icon)this.permanentlyStoredIcon);
                        break;
                    }
                    default: {
                        LOGGER.error("Unknown macro save state detected: {}", (Object)macro.getMacroSaveState());
                    }
                }
            }
            String text = null;
            text = StringUtils.isNotBlank((CharSequence)macro.getLabel()) ? String.format("%1$02d : %2$s", macro.getId(), macro.getLabel()) : (macro.getId() > -1 ? String.format("%1$02d :", macro.getId()) : " ");
            this.setText(text);
        }
        return renderer;
    }
}

