/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.listener.ButtonListener;
import org.bidib.wizard.client.common.view.renderer.BidibStatusListRenderer;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortComboBoxWithButtonEditor<E extends BidibStatus>
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PortComboBoxWithButtonEditor.class);
    private final Collection<ButtonListener> buttonListeners = new LinkedList();
    private final JPanel panel = new JPanel();
    protected final JComboBox<E> comboBox;
    private final JButton button;
    private int row;
    private int column;

    public PortComboBoxWithButtonEditor(E[] items, String buttonText, Class<?> resourceClazz) {
        this(items, buttonText, Resources.trimWizardPackage((String)resourceClazz.getName()));
    }

    public PortComboBoxWithButtonEditor(E[] items, String buttonText, String resourceClazz) {
        this.comboBox = new JComboBox<BidibStatus>((BidibStatus[])items.clone());
        this.comboBox.setRenderer(new BidibStatusListRenderer(resourceClazz));
        this.button = new JButton(buttonText);
        this.button.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.panel.setLayout(new GridBagLayout());
        this.panel.setFocusCycleRoot(true);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 2, 2);
        c.weightx = 1.0;
        this.panel.add((Component)this.comboBox, c);
        c.anchor = 24;
        ++c.gridx;
        c.weightx = 0.0;
        this.panel.add((Component)this.button, c);
    }

    public void addButtonListener(ButtonListener l) {
        this.buttonListeners.add(l);
    }

    private void fireButtonPressed() {
        for (ButtonListener l : this.buttonListeners) {
            l.buttonPressed(this.row, this.column, this.getCellEditorValue());
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.comboBox.getSelectedItem();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.row = row;
        this.column = column;
        if (value instanceof ConfigurablePort) {
            ConfigurablePort port = (ConfigurablePort)value;
            this.setSelectedValue((Port)port);
        } else if (value instanceof BidibStatus) {
            this.setSelectedValue((BidibStatus)value);
        } else {
            LOGGER.warn("Invalid value: {}", value);
        }
        if (isSelected) {
            this.panel.setForeground(table.getSelectionForeground());
            this.panel.setBackground(table.getSelectionBackground());
        } else {
            this.panel.setForeground(table.getForeground());
            this.panel.setBackground(table.getBackground());
            this.comboBox.setForeground(table.getForeground());
            this.comboBox.setBackground(table.getBackground());
            this.button.setForeground(table.getForeground());
            this.button.setBackground(table.getBackground());
        }
        return this.panel;
    }

    protected void setSelectedValue(Port<? extends BidibStatus> port) {
        this.comboBox.setSelectedItem(port.getStatus());
    }

    protected void setSelectedValue(E status) {
        this.comboBox.setSelectedItem(status);
    }

    static /* synthetic */ void access$000(PortComboBoxWithButtonEditor x0) {
        x0.fireEditingStopped();
    }
}

