/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pom.model.command;

import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pom.model.RailcomProgBeanModel;
import org.bidib.wizard.mvc.pom.model.command.PomOperationCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomRailcomConfigCommand
extends PomOperationCommand<RailcomProgBeanModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomRailcomConfigCommand.class);
    private Boolean channel1;
    private Boolean channel2;
    private Boolean channelUsage;
    private Boolean railcomPlus;

    public PomRailcomConfigCommand(PomAddressData decoderAddress, PomOperation pomOperation, int cvNumber, int cvValue) {
        super(decoderAddress, pomOperation, cvNumber, cvValue);
    }

    public void setCvValueResult(Integer cvValueResult) {
        super.setCvValueResult(cvValueResult);
        if (cvValueResult != null) {
            this.setChannel1(ByteUtils.getBit((int)cvValueResult, (int)0) == 0 ? Boolean.FALSE : Boolean.TRUE);
            this.setChannel2(ByteUtils.getBit((int)cvValueResult, (int)1) == 0 ? Boolean.FALSE : Boolean.TRUE);
            this.setChannelUsage(ByteUtils.getBit((int)cvValueResult, (int)2) == 0 ? Boolean.FALSE : Boolean.TRUE);
            this.setRailcomPlus(ByteUtils.getBit((int)cvValueResult, (int)7) == 0 ? Boolean.FALSE : Boolean.TRUE);
        }
    }

    public void setChannel1(Boolean channel1) {
        this.channel1 = channel1;
    }

    public Boolean getChannel1() {
        return this.channel1;
    }

    public void setChannel2(Boolean channel2) {
        this.channel2 = channel2;
    }

    public Boolean getChannel2() {
        return this.channel2;
    }

    public Boolean getChannelUsage() {
        return this.channelUsage;
    }

    public void setChannelUsage(Boolean channelUsage) {
        this.channelUsage = channelUsage;
    }

    public Boolean getRailcomPlus() {
        return this.railcomPlus;
    }

    public void setRailcomPlus(Boolean railcomPlus) {
        this.railcomPlus = railcomPlus;
    }

    public void postExecute(RailcomProgBeanModel railcomProgBeanModel) {
        super.postExecute((ProgCommandAwareBeanModel)railcomProgBeanModel);
        if (this.channel1 != null) {
            LOGGER.debug("Set the channel1: {}", (Object)this.channel1);
            railcomProgBeanModel.setChannel1(this.channel1.booleanValue());
        }
        if (this.channel2 != null) {
            LOGGER.debug("Set the channel2: {}", (Object)this.channel2);
            railcomProgBeanModel.setChannel2(this.channel2.booleanValue());
        }
        if (this.channelUsage != null) {
            LOGGER.info("Set the channelUsage: {}", (Object)this.channelUsage);
            railcomProgBeanModel.setChannelUsage(this.channelUsage.booleanValue());
        }
        if (this.railcomPlus != null) {
            LOGGER.debug("Set the railcomPlus: {}", (Object)this.railcomPlus);
            railcomProgBeanModel.setRailcomPlus(this.railcomPlus.booleanValue());
        }
    }
}

