/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pom.view.panel;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.validation.ValidationMessage;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.AddressMode;
import org.bidib.jbidibc.messages.enums.PomAddressTypeEnum;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.CollectionUtils;
import org.bidib.jbidibc.messages.utils.CvUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.mvc.pom.model.AddressProgBeanModel;
import org.bidib.wizard.mvc.pom.model.CurrentAddressBeanModel;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pom.model.command.PomAddressModeCommand;
import org.bidib.wizard.mvc.pom.model.command.PomAddressPanelChangeAddressCommand;
import org.bidib.wizard.mvc.pom.model.command.PomAddressValueCommand;
import org.bidib.wizard.mvc.pom.view.panel.AbstractPomPanel;
import org.bidib.wizard.mvc.pom.view.panel.AddressPanel;
import org.bidib.wizard.mvc.pom.view.panel.PomValidationResultModel;

public class AddressPanel
extends AbstractPomPanel<AddressProgBeanModel> {
    private final AddressProgBeanModel addressProgBeanModel = new AddressProgBeanModel();
    private ValueModel addressValueModel;
    private JTextField address;
    private InputValidationDocument addressDocument;
    private JComponent[] modeButtons;
    private PomValidationResultModel addressValidationModel;
    private static final int MIN_SHORT_ADDRESS = 1;
    private static final int MAX_SHORT_ADDRESS = 127;
    private static final int MIN_LONG_ADDRESS = 128;
    private static final int MAX_LONG_ADDRESS = 10239;

    public AddressPanel(PomProgrammerModel cvProgrammerModel, CurrentAddressBeanModel currentAddressBeanModel) {
        super(cvProgrammerModel, currentAddressBeanModel);
        this.setProgCommandAwareBeanModel((ProgCommandAwareBeanModel)this.addressProgBeanModel);
    }

    protected void postConstruct() {
        if (this.currentAddressBeanModel.getDccAddress() != null) {
            int dccAddress = this.currentAddressBeanModel.getDccAddress();
            if (dccAddress > 1 && dccAddress < 128) {
                this.addressProgBeanModel.setAddress(Integer.valueOf(dccAddress));
                this.addressProgBeanModel.setAddressMode(AddressMode.SHORT);
            } else if (dccAddress > 127 && dccAddress < 10239) {
                this.addressProgBeanModel.setAddress(Integer.valueOf(dccAddress));
                this.addressProgBeanModel.setAddressMode(AddressMode.LONG);
            }
        }
    }

    protected void createWorkerPanel(FormBuilder builder, int[] rowHolder, PomValidationResultModel parentValidationModel) {
        int row = rowHolder[0];
        builder.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"address-message"))).xyw(1, row, 7);
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add(Resources.getString(this.getClass(), (String)"address-mode"), new Object[0]).xy(1, row += 2);
        PropertyAdapter modeModel = new PropertyAdapter((Object)this.addressProgBeanModel, "addressMode", true);
        this.modeButtons = new JComponent[AddressMode.values().length];
        int index = 0;
        int column = 3;
        for (AddressMode mode : AddressMode.values()) {
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)modeModel, (Object)mode, (String)Resources.getString(AddressMode.class, (String)mode.getKey()));
            this.modeButtons[index++] = radio;
            builder.add((Component)radio).xy(column, row);
            column += 2;
        }
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add(Resources.getString(this.getClass(), (String)"address"), new Object[0]).xy(1, row += 2);
        this.addressValueModel = new PropertyAdapter((Object)this.addressProgBeanModel, "address", true);
        ConverterValueModel addressConverterModel = new ConverterValueModel(this.addressValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.address = new JTextField();
        this.addressDocument = new InputValidationDocument(5, "0123456789");
        this.address.setDocument((Document)this.addressDocument);
        this.address.setColumns(5);
        Bindings.bind((JTextField)this.address, (ValueModel)addressConverterModel, (boolean)false);
        builder.add((Component)this.address).xy(3, row);
        ValidationComponentUtils.setMandatory((JComponent)this.address, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)this.address, (Object[])new Object[]{"validation.address_key", "validation.address_short_key", "validation.address_long_key"});
        this.addressValidationModel = new PomValidationResultModel(parentValidationModel);
        this.addressProgBeanModel.addPropertyChangeListener("addressMode", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addressProgBeanModel.addPropertyChangeListener("address", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        row += 2;
        builder.appendRows("p, 3dlu", new Object[0]);
        this.readButtonEnabled = new ValueHolder(false);
        this.readButton.setEnabled(false);
        this.readButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.writeButtonEnabled = new ValueHolder(false);
        this.writeButton.setEnabled(false);
        this.writeButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel progActionButtons = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{this.readButton, this.writeButton}).build();
        builder.add((Component)progActionButtons).xyw(1, row, 7);
        rowHolder[0] = row;
    }

    protected ValidationResultModel getValidationResultModel() {
        return this.addressValidationModel;
    }

    private ValidationResult validate() {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.addressProgBeanModel, "validation");
        if (AddressMode.SHORT.equals((Object)this.addressProgBeanModel.getAddressMode())) {
            if (this.addressProgBeanModel.getAddress() == null) {
                support.addWarning("address_key", "not_empty_for_write");
            } else if (this.addressProgBeanModel.getAddress() < 1 || this.addressProgBeanModel.getAddress() > 127) {
                support.addError("address_short_key", "invalid_value;min=1,max=127");
            }
        } else if (this.addressProgBeanModel.getAddress() == null) {
            support.addWarning("address_key", "not_empty_for_write");
        } else if (this.addressProgBeanModel.getAddress() < 128 || this.addressProgBeanModel.getAddress() > 10239) {
            support.addError("address_long_key", "invalid_value;min=128,max=10239");
        }
        ValidationResult validationResult = support.getResult();
        this.LOGGER.info("Prepared validationResult: {}", (Object)validationResult);
        return validationResult;
    }

    protected void triggerValidation() {
        ValidationMessage message;
        ValidationResult validationResult = this.validate();
        this.addressValidationModel.setResult(validationResult);
        this.LOGGER.debug("Set the writeButtonEnabled, validStateNoWarnOrErrors: {}, validState: {}", (Object)this.addressValidationModel.getValidStateNoWarnOrErrors(), (Object)this.addressValidationModel.getValidState());
        this.writeButtonEnabled.setValue((Object)this.addressValidationModel.getValidStateNoWarnOrErrors());
        this.readButtonEnabled.setValue((Object)this.addressValidationModel.getValidState());
        if (!this.addressValidationModel.getValidState() && !this.addressValidationModel.getResult().hasErrors() && CollectionUtils.hasElements((Collection)this.addressValidationModel.getResult().getWarnings()) && "validation.address_key".equals((message = (ValidationMessage)this.addressValidationModel.getResult().getWarnings().get(0)).key())) {
            this.readButtonEnabled.setValue((Object)true);
        }
    }

    protected void disableInputElements() {
        this.LOGGER.info("+++ disableInputElements");
        this.address.setEnabled(false);
        for (JComponent comp : this.modeButtons) {
            comp.setEnabled(false);
        }
        super.disableInputElements();
    }

    protected void enableInputElements() {
        this.LOGGER.info("+++ enableInputElements");
        this.address.setEnabled(true);
        for (JComponent comp : this.modeButtons) {
            comp.setEnabled(true);
        }
        this.triggerValidation();
    }

    private void fireWrite() {
        this.disableInputElements();
        this.LOGGER.info("Prepare the write request for model: {}", (Object)this.addressProgBeanModel);
        this.addressProgBeanModel.getExecutedProgCommands().clear();
        List progCommands = this.addressProgBeanModel.getProgCommands();
        progCommands.clear();
        int address = this.addressProgBeanModel.getAddress();
        int lowAddress = (int)(192L + Math.round((double)(address / 256) - 0.5));
        int highAddress = address - (lowAddress - 192) * 256;
        int directDccAddress = this.currentAddressBeanModel.getDccAddress();
        this.LOGGER.info("Prepared DCC address: {}", (Object)directDccAddress);
        PomAddressData addressData = new PomAddressData(directDccAddress, this.currentAddressBeanModel.getAddressType());
        this.LOGGER.info("Prepared addressData to write: {}", (Object)addressData);
        switch (5.$SwitchMap$org$bidib$jbidibc$messages$enums$AddressMode[this.addressProgBeanModel.getAddressMode().ordinal()]) {
            case 1: {
                progCommands.add(new PomAddressValueCommand(addressData, PomOperation.WR_BYTE, 17, ByteUtils.getIntLowByteValue((int)lowAddress), PomAddressValueCommand.ValueType.low));
                progCommands.add(new PomAddressValueCommand(addressData, PomOperation.WR_BYTE, 18, ByteUtils.getIntLowByteValue((int)highAddress), PomAddressValueCommand.ValueType.high));
                progCommands.add(new PomAddressModeCommand(addressData, PomOperation.WR_BIT, 29, CvUtils.preparePomBitCvValue((int)5, (int)1)));
                break;
            }
            default: {
                PomAddressModeCommand queryLongAddrEnabledCommand = new PomAddressModeCommand(addressData, PomOperation.RD_BIT, 29, CvUtils.preparePomBitCvValue((int)5, (int)1));
                progCommands.add(queryLongAddrEnabledCommand);
                LinkedList<Object> progCommandsSuccess = new LinkedList<Object>();
                progCommandsSuccess.add(new PomAddressValueCommand(addressData, PomOperation.WR_BYTE, 1, ByteUtils.getIntLowByteValue((int)address), PomAddressValueCommand.ValueType.low));
                progCommandsSuccess.add(new PomAddressModeCommand(addressData, PomOperation.WR_BIT, 29, CvUtils.preparePomBitCvValue((int)5, (int)0)));
                queryLongAddrEnabledCommand.setProgCommandsSuccess(progCommandsSuccess);
                LinkedList<PomAddressValueCommand> progCommandsFailure = new LinkedList<PomAddressValueCommand>();
                queryLongAddrEnabledCommand.setProgCommandsFailure(progCommandsFailure);
                PomAddressValueCommand writeShortAddrCommand = new PomAddressValueCommand(addressData, PomOperation.WR_BYTE, 1, ByteUtils.getIntLowByteValue((int)address), PomAddressValueCommand.ValueType.low);
                progCommandsFailure.add(writeShortAddrCommand);
                LinkedList<PomAddressPanelChangeAddressCommand> progCommandsReadNewAddressFailure = new LinkedList<PomAddressPanelChangeAddressCommand>();
                writeShortAddrCommand.setProgCommandsFailure(progCommandsReadNewAddressFailure);
                LinkedList<PomAddressPanelChangeAddressCommand> progCommandsReadNewAddressSuccess = new LinkedList<PomAddressPanelChangeAddressCommand>();
                writeShortAddrCommand.setProgCommandsSuccess(progCommandsReadNewAddressSuccess);
                PomAddressData changedAddressData = new PomAddressData(ByteUtils.getIntLowByteValue((int)address), PomAddressTypeEnum.LOCOMOTIVE);
                this.LOGGER.info("Prepare the PomAddressPanelChangeAddressCommand with addressData: {}", (Object)changedAddressData);
                PomAddressPanelChangeAddressCommand changePanelAddressCommand = new PomAddressPanelChangeAddressCommand(changedAddressData, PomOperation.RD_BYTE, 1, (int)ByteUtils.getLowByte((int)0), PomAddressValueCommand.ValueType.low, this.currentAddressBeanModel);
                progCommandsReadNewAddressFailure.add(changePanelAddressCommand);
                progCommandsReadNewAddressSuccess.add(changePanelAddressCommand);
            }
        }
        this.startTimeoutControl(1000);
        this.fireNextCommand();
    }

    private void fireRead() {
        this.disableInputElements();
        this.addressProgBeanModel.setAddress(null);
        this.addressProgBeanModel.getExecutedProgCommands().clear();
        List progCommands = this.addressProgBeanModel.getProgCommands();
        progCommands.clear();
        int directDccAddress = this.currentAddressBeanModel.getDccAddress();
        this.LOGGER.info("Prepared DCC address: {}", (Object)directDccAddress);
        PomAddressData addressData = new PomAddressData(directDccAddress, this.currentAddressBeanModel.getAddressType());
        this.LOGGER.info("Prepared addressData to read: {}", (Object)addressData);
        PomAddressModeCommand readLongCommmand = new PomAddressModeCommand(addressData, PomOperation.RD_BIT, 29, 5, 1);
        progCommands.add(readLongCommmand);
        LinkedList<PomAddressValueCommand> progCommandsSuccess = new LinkedList<PomAddressValueCommand>();
        progCommandsSuccess.add(new PomAddressValueCommand(addressData, PomOperation.RD_BYTE, 17, (int)ByteUtils.getLowByte((int)0), PomAddressValueCommand.ValueType.low));
        progCommandsSuccess.add(new PomAddressValueCommand(addressData, PomOperation.RD_BYTE, 18, (int)ByteUtils.getHighByte((int)0), PomAddressValueCommand.ValueType.high));
        readLongCommmand.setProgCommandsSuccess(progCommandsSuccess);
        LinkedList<PomAddressValueCommand> progCommandsFailure = new LinkedList<PomAddressValueCommand>();
        progCommandsFailure.add(new PomAddressValueCommand(addressData, PomOperation.RD_BYTE, 1, (int)ByteUtils.getLowByte((int)0), PomAddressValueCommand.ValueType.low));
        readLongCommmand.setProgCommandsFailure(progCommandsFailure);
        this.startTimeoutControl(1000);
        this.fireNextCommand();
    }

    protected Object getCurrentOperation() {
        return this.addressProgBeanModel.getCurrentOperation();
    }
}

