/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.position.controller;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.core.schema.bidibbase.BaseLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeProvider;
import org.bidib.wizard.api.model.RfBasisNode;
import org.bidib.wizard.api.model.connection.AbstractMessageEvent;
import org.bidib.wizard.api.model.connection.BidibConnection;
import org.bidib.wizard.api.model.connection.event.OccupancyPositionMessageEvent;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.common.exception.ConnectionException;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.core.model.connection.MessageEventHandler;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.mvc.main.controller.MainControllerInterface;
import org.bidib.wizard.mvc.position.controller.FeedbackPositionController;
import org.bidib.wizard.mvc.position.model.FeedbackPositionModel;
import org.bidib.wizard.mvc.position.model.FeedbackPositionTableModel;
import org.bidib.wizard.mvc.position.model.listener.FeedbackPositionListener;
import org.bidib.wizard.mvc.position.view.FeedbackPositionView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class FeedbackPositionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPositionController.class);
    private FeedbackPositionView feedbackPositionView;
    private FeedbackPositionModel feedbackPositionModel;
    private FeedbackPositionListener feedbackPositionListener;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    private final DockingDesktop desktop;
    private DockableStateChangeListener dockableStateChangeListener;
    private final MainControllerInterface mainController;
    private final Supplier<NodeProvider> nodeProviderSupplier;
    private CompositeDisposable compDispMessages;
    private final Map<Class<? extends AbstractMessageEvent>, MessageEventHandler<AbstractMessageEvent>> messageActionMap = new HashMap();
    private final Object rfBasisNodesLock = new Object();

    public FeedbackPositionController(DockingDesktop desktop, Supplier<NodeProvider> nodeProviderSupplier, MainControllerInterface mainController) {
        LOGGER.info("Create new instance of FeedbackPositionController.");
        this.desktop = desktop;
        this.nodeProviderSupplier = nodeProviderSupplier;
        this.mainController = mainController;
    }

    @PostConstruct
    public void initialize() {
        this.feedbackPositionModel = new FeedbackPositionModel(positionId -> {
            NodeLabels nodeLabels = this.getNodeLabels();
            BaseLabel label = BidibLabelUtils.getFeedbackPositionLabel((NodeLabels)nodeLabels, (int)positionId);
            return label;
        });
        this.prepareMessageMap();
        1 nodeListListener = new /* Unavailable Anonymous Inner Class!! */;
        this.mainController.addNodeListListener((NodeListListener)nodeListListener);
        try {
            this.connectionService.subscribeConnectionStatusChanges(connectionInfo -> {
                if (connectionInfo.getConnectionId().equals("main")) {
                    LOGGER.info("Current state: {}", (Object)connectionInfo.getConnectionState());
                    switch (5.$SwitchMap$org$bidib$api$json$types$ConnectionPhase[connectionInfo.getConnectionState().getActualPhase().ordinal()]) {
                        case 1: {
                            LOGGER.info("The communication was opened.");
                            this.compDispMessages = new CompositeDisposable();
                            this.registerForMessages();
                            break;
                        }
                        case 2: {
                            LOGGER.info("The communication was closed.");
                            if (this.compDispMessages == null) break;
                            this.compDispMessages.dispose();
                            this.compDispMessages = null;
                            break;
                        }
                    }
                }
            }, error -> LOGGER.warn("The connection status change caused an error.", error));
        }
        catch (Exception ex) {
            LOGGER.warn("Register controller as connection status listener failed.", (Throwable)ex);
        }
        try {
            LOGGER.info("Check if the connection is connected already.");
            boolean isConnected = this.connectionService.isConnected("main");
            if (isConnected) {
                LOGGER.info("The connection is connected. Register for messages.");
                if (this.compDispMessages == null) {
                    this.compDispMessages = new CompositeDisposable();
                }
                this.registerForMessages();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Register for messages failed.", (Throwable)ex);
        }
        NodeProvider nodeProvider = (NodeProvider)this.nodeProviderSupplier.get();
        if (nodeProvider != null) {
            for (NodeInterface node : nodeProvider.getNodes()) {
                this.nodeNew(node);
            }
        }
    }

    public void start() {
        String searchKey = "FeedbackPositionView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable view = this.desktop.getContext().getDockableByKey(searchKey);
        if (view != null) {
            LOGGER.info("Select the existing booster table view.");
            DockUtils.selectWindow((Dockable)view);
            return;
        }
        LOGGER.info("Create new FeedbackPositionTableView.");
        FeedbackPositionTableModel tableModel = new FeedbackPositionTableModel();
        this.feedbackPositionView = new FeedbackPositionView(this, this.feedbackPositionModel, tableModel);
        if (this.desktop.getDockables().length > 1) {
            Dockable dock = this.desktop.getDockables()[1].getDockable();
            this.desktop.createTab(dock, (Dockable)this.feedbackPositionView, 1, true);
        } else {
            this.desktop.addDockable((Dockable)this.feedbackPositionView, RelativeDockablePosition.RIGHT);
        }
        this.feedbackPositionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.feedbackPositionModel.addFeedbackPortListener(this.feedbackPositionListener);
        tableModel.setPortListener((PortModelListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dockableStateChangeListener = new /* Unavailable Anonymous Inner Class!! */;
        this.desktop.addDockableStateChangeListener(this.dockableStateChangeListener);
    }

    private void registerForMessages() {
        LOGGER.info("Register for messages from the connection.");
        try {
            BidibConnection connection = this.connectionService.find("main");
            Disposable dispMessages = connection.getSubjectMessages().subscribe(msg -> this.handleBidibMessageEvent(msg));
            this.compDispMessages.add(dispMessages);
        }
        catch (ConnectionException ex) {
            LOGGER.warn("No connection found, register on messages is skipped.", (Throwable)ex);
        }
    }

    private void prepareMessageMap() {
        LOGGER.info("Prepare the message map.");
        this.messageActionMap.put(OccupancyPositionMessageEvent.class, evt -> {
            OccupancyPositionMessageEvent event = (OccupancyPositionMessageEvent)evt;
            LOGGER.info("Process the event: {}", (Object)event);
            switch (5.$SwitchMap$org$bidib$jbidibc$messages$enums$PositionLocationEnum[event.getLocationType().ordinal()]) {
                case 1: {
                    SwingUtilities.invokeLater(() -> {
                        LOGGER.info("Update the position: {}", (Object)event);
                        this.feedbackPositionModel.addPosition(event.getAddress(), event.getDecoderAddress().intValue(), event.getLocationType(), event.getLocationAddress(), null);
                    });
                    break;
                }
                case 2: 
                case 3: {
                    SwingUtilities.invokeLater(() -> {
                        LOGGER.info("Update the position: {}", (Object)event);
                        this.feedbackPositionModel.addPosition(event.getAddress(), event.getDecoderAddress().intValue(), event.getLocationType(), event.getLocationAddress(), event.getExtendedData());
                    });
                    break;
                }
                default: {
                    LOGGER.debug("Do not show position feedback with type: {}", (Object)event.getLocationType());
                }
            }
        });
    }

    private void handleBidibMessageEvent(AbstractMessageEvent event) {
        LOGGER.debug("Handle the message event: {}", (Object)event);
        try {
            MessageEventHandler action = (MessageEventHandler)this.messageActionMap.get(event.getClass());
            if (action != null) {
                action.handleMessageEvent((Object)event);
            } else {
                LOGGER.debug("No message event action configured for event: {}", (Object)event);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Execute the message event action failed, event: {}", (Object)event, (Object)ex);
        }
    }

    protected void nodeLost(NodeInterface node) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nodeNew(NodeInterface node) {
        if (ProductUtils.isRFBasisNode((long)node.getUniqueId())) {
            Object object = this.rfBasisNodesLock;
            synchronized (object) {
                LOGGER.info("Register new RF-Basis Node: {}", (Object)node);
                RfBasisNode rfBasisNode = new RfBasisNode(node);
                this.feedbackPositionModel.addRfBasisNode(rfBasisNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeInterface getSelectedNode() {
        Object object = this.rfBasisNodesLock;
        synchronized (object) {
            RfBasisNode rfBasisNode = this.feedbackPositionModel.getRfBasisNodes().stream().filter(rf -> rf.getNode().getBaseNumber() == 0 || rf.getNode().getBaseNumber() == 1).findFirst().orElse(null);
            if (rfBasisNode != null) {
                return rfBasisNode.getNode();
            }
        }
        return null;
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels() {
        try {
            long uniqueId = this.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save accessory labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.feedbackPositionView != null) {
            SwingUtilities.invokeLater(() -> this.feedbackPositionView.refreshView());
        }
    }
}

