/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.preferences.view.panel;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.time.LocalTime;
import java.util.function.Consumer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.preferences.view.panel.AbstractSettingsPanel;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.model.settings.GlobalSettingsInterface;
import org.bidib.wizard.mvc.common.view.converter.StringToLocalTimeConverter;
import org.bidib.wizard.mvc.preferences.model.PreferencesModel;
import org.bidib.wizard.mvc.preferences.view.panel.TimePanel;

public class TimePanel
extends AbstractSettingsPanel<GlobalSettingsInterface> {
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private final GlobalSettingsInterface globalSettings;
    private JPanel contentPanel;
    private final PreferencesModel model;

    public TimePanel(PreferencesModel model, GlobalSettingsInterface globalSettings, Consumer<Boolean> bufferingCallback) {
        super(bufferingCallback);
        this.model = model;
        this.globalSettings = globalSettings;
    }

    public JPanel createPanel() {
        Object panel;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.preparePresentationModel((Object)this.globalSettings);
        ConverterValueModel timeFactorConverterModel = new ConverterValueModel((ValueModel)this.presentationModel.getBufferedModel("timeFactor"), (BindingConverter)new StringToIntegerConverter(Integer.valueOf(60)));
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"timeFactor") + ":", new Object[0]).xy(1, 1);
        JTextField timeFactor = new JTextField();
        timeFactor.setDocument((Document)new InputValidationDocument(4, "0123456789"));
        Bindings.bind((JTextField)timeFactor, (ValueModel)timeFactorConverterModel, (boolean)false);
        dialogBuilder.add((Component)timeFactor).xy(3, 1);
        BufferedValueModel selectionHolderDayOfWeek = this.presentationModel.getBufferedModel("dayOfWeek");
        SelectionInList dayOfWeekSelection = new SelectionInList((ListModel)this.model.getDayOfWeekList());
        ComboBoxAdapter comboBoxAdapterDayOfWeek = new ComboBoxAdapter((ListModel)dayOfWeekSelection, (ValueModel)selectionHolderDayOfWeek);
        JComboBox comboDayOfWeek = new JComboBox();
        comboDayOfWeek.setRenderer(new DayOfWeekRenderer(this));
        comboDayOfWeek.setModel(comboBoxAdapterDayOfWeek);
        dialogBuilder.add(Resources.getString(TimePanel.class, (String)"dayOfWeek") + ":", new Object[0]).xy(1, 3);
        dialogBuilder.add(comboDayOfWeek).xy(3, 3);
        ConverterValueModel startTimeModel = new ConverterValueModel((ValueModel)this.presentationModel.getBufferedModel("startTime"), (BindingConverter)new StringToLocalTimeConverter());
        InputValidationDocument startTimeValidatingDocument = new InputValidationDocument(4, "0123456789");
        JSpinner startTime = WizardComponentFactory.createSpinnerTemporalEditor((ValueModel)startTimeModel, (boolean)false, (LocalTime)LocalTime.of(0, 0), (LocalTime)LocalTime.of(23, 59), (InputValidationDocument)startTimeValidatingDocument);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"startTime"), new Object[0]).xy(1, 5);
        dialogBuilder.add((Component)startTime).xy(3, 5);
        BufferedValueModel modelTimeEnabledModel = this.presentationModel.getBufferedModel("modelTimeEnabled");
        JCheckBox modelTimeEnabled = WizardComponentFactory.createCheckBox((ValueModel)modelTimeEnabledModel, (String)Resources.getString(this.getClass(), (String)"modelTimeEnabled"));
        dialogBuilder.add((Component)modelTimeEnabled).xyw(1, 7, 5);
        this.contentPanel = dialogBuilder.build();
        this.contentPanel.setOpaque(false);
        return this.contentPanel;
    }
}

