/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pt.view.panel;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.enums.AddressMode;
import org.bidib.jbidibc.messages.enums.PtOperation;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.CvUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.mvc.pt.model.PtProgrammerModel;
import org.bidib.wizard.mvc.pt.view.command.PtAddressModeCommand;
import org.bidib.wizard.mvc.pt.view.command.PtAddressValueCommand;
import org.bidib.wizard.mvc.pt.view.command.PtOperationCommand;
import org.bidib.wizard.mvc.pt.view.panel.AbstractPtPanel;
import org.bidib.wizard.mvc.pt.view.panel.AddressPanel;
import org.bidib.wizard.mvc.pt.view.panel.AddressProgBeanModel;
import org.bidib.wizard.mvc.pt.view.panel.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pt.view.panel.PtValidationResultModel;

public class AddressPanel
extends AbstractPtPanel<AddressProgBeanModel> {
    private final AddressProgBeanModel addressProgBeanModel = new AddressProgBeanModel();
    private ValueModel addressValueModel;
    private JTextField address;
    private InputValidationDocument addressDocument;
    private JComponent[] modeButtons;
    private ValidationResultModel addressValidationModel;
    private static final int MIN_SHORT_ADDRESS = 1;
    private static final int MAX_SHORT_ADDRESS = 127;
    private static final int MIN_LONG_ADDRESS = 128;
    private static final int MAX_LONG_ADDRESS = 10239;

    public AddressPanel(PtProgrammerModel cvProgrammerModel) {
        super(cvProgrammerModel);
        this.setProgCommandAwareBeanModel((ProgCommandAwareBeanModel)this.addressProgBeanModel);
    }

    protected void createWorkerPanel(FormBuilder builder, int[] rowHolder) {
        int row = rowHolder[0];
        builder.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"address-message"))).xyw(1, row, 7);
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add(Resources.getString(this.getClass(), (String)"address-mode"), new Object[0]).xy(1, row += 2);
        PropertyAdapter modeModel = new PropertyAdapter((Object)this.addressProgBeanModel, "addressMode", true);
        this.modeButtons = new JComponent[AddressMode.values().length];
        int index = 0;
        int column = 3;
        for (AddressMode mode : AddressMode.values()) {
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)modeModel, (Object)mode, (String)Resources.getString(AddressMode.class, (String)mode.getKey()));
            this.modeButtons[index++] = radio;
            builder.add((Component)radio).xy(column, row);
            column += 2;
        }
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add(Resources.getString(this.getClass(), (String)"address"), new Object[0]).xy(1, row += 2);
        this.addressValueModel = new PropertyAdapter((Object)this.addressProgBeanModel, "address", true);
        ConverterValueModel addressConverterModel = new ConverterValueModel(this.addressValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.address = new JTextField();
        this.addressDocument = new InputValidationDocument(5, "0123456789");
        this.address.setDocument((Document)this.addressDocument);
        this.address.setColumns(5);
        Bindings.bind((JTextField)this.address, (ValueModel)addressConverterModel, (boolean)false);
        builder.add((Component)this.address).xy(3, row);
        ValidationComponentUtils.setMandatory((JComponent)this.address, (boolean)true);
        ValidationComponentUtils.setMessageKeys((JComponent)this.address, (Object[])new Object[]{"validation.address_key", "validation.address_short_key", "validation.address_long_key"});
        this.addressValidationModel = new PtValidationResultModel();
        this.addressProgBeanModel.addPropertyChangeListener("addressMode", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addressProgBeanModel.addPropertyChangeListener("address", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        row += 2;
        builder.appendRows("p, 3dlu", new Object[0]);
        this.readButtonEnabled = new ValueHolder(false);
        this.readButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.writeButtonEnabled = new ValueHolder(false);
        this.writeButton.setEnabled(false);
        this.writeButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        PropertyConnector.connect((Object)this.addressValidationModel, (String)"validState", (Object)this.writeButton, (String)"enabled");
        JPanel progActionButtons = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{this.readButton, this.writeButton}).build();
        builder.add((Component)progActionButtons).xyw(1, row, 7);
        rowHolder[0] = row;
    }

    protected void doBindButtons() {
        PropertyConnector.connect((Object)this.readButtonEnabled, (String)"value", (Object)this.readButton, (String)"enabled");
        PropertyConnector.connect((Object)this.writeButtonEnabled, (String)"value", (Object)this.writeButton, (String)"enabled");
    }

    protected ValidationResultModel getValidationResultModel() {
        return this.addressValidationModel;
    }

    private ValidationResult validate() {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.addressProgBeanModel, "validation");
        if (AddressMode.SHORT.equals((Object)this.addressProgBeanModel.getAddressMode())) {
            if (this.addressProgBeanModel.getAddress() == null) {
                support.addWarning("address_key", "not_empty_for_write");
            } else if (this.addressProgBeanModel.getAddress() < 1 || this.addressProgBeanModel.getAddress() > 127) {
                support.addError("address_short_key", "invalid_value;min=1,max=127");
            }
        } else if (this.addressProgBeanModel.getAddress() == null) {
            support.addWarning("address_key", "not_empty_for_write");
        } else if (this.addressProgBeanModel.getAddress() < 128 || this.addressProgBeanModel.getAddress() > 10239) {
            support.addError("address_long_key", "invalid_value;min=128,max=10239");
        }
        ValidationResult validationResult = support.getResult();
        this.LOGGER.info("Prepared validationResult: {}", (Object)validationResult);
        return validationResult;
    }

    protected void triggerValidation() {
        ValidationResult validationResult = this.validate();
        this.addressValidationModel.setResult(validationResult);
    }

    protected void disableInputElements() {
        this.LOGGER.info("+++ disableInputElements");
        this.address.setEnabled(false);
        for (JComponent comp : this.modeButtons) {
            comp.setEnabled(false);
        }
        super.disableInputElements();
    }

    protected void enableInputElements() {
        this.LOGGER.info("+++ enableInputElements");
        this.address.setEnabled(true);
        for (JComponent comp : this.modeButtons) {
            comp.setEnabled(true);
        }
        if (this.addressValueModel.getValue() != null) {
            this.writeButtonEnabled.setValue((Object)true);
        }
        this.readButtonEnabled.setValue((Object)true);
    }

    private void fireWrite() {
        this.disableInputElements();
        this.LOGGER.info("Prepare the write request for model: {}", (Object)this.addressProgBeanModel);
        this.addressProgBeanModel.getExecutedProgCommands().clear();
        List progCommands = this.addressProgBeanModel.getProgCommands();
        progCommands.clear();
        int address = this.addressProgBeanModel.getAddress();
        int lowAddress = (int)(192L + Math.round((double)(address / 256) - 0.5));
        int highAddress = address - (lowAddress - 192) * 256;
        switch (5.$SwitchMap$org$bidib$jbidibc$messages$enums$AddressMode[this.addressProgBeanModel.getAddressMode().ordinal()]) {
            case 1: {
                this.LOGGER.info("Prepare address mode commands for long address.");
                progCommands.add(new PtAddressModeCommand(PtOperation.WR_BIT, 29, CvUtils.preparePtBitCvValue((boolean)true, (int)5, (int)1)));
                progCommands.add(new PtAddressValueCommand(PtOperation.WR_BYTE, 17, ByteUtils.getIntLowByteValue((int)lowAddress), PtAddressValueCommand.ValueType.low));
                progCommands.add(new PtAddressValueCommand(PtOperation.WR_BYTE, 18, ByteUtils.getIntLowByteValue((int)highAddress), PtAddressValueCommand.ValueType.high));
                break;
            }
            default: {
                this.LOGGER.info("Prepare address mode commands for short address.");
                progCommands.add(new PtAddressModeCommand(PtOperation.WR_BIT, 29, CvUtils.preparePtBitCvValue((boolean)true, (int)5, (int)0)));
                progCommands.add(new PtAddressValueCommand(PtOperation.WR_BYTE, 1, ByteUtils.getIntLowByteValue((int)address), PtAddressValueCommand.ValueType.low));
            }
        }
        this.ptResultProxyModel.setCommandStationProgState(null);
        this.fireNextCommand();
    }

    private void fireRead() {
        this.disableInputElements();
        this.addressProgBeanModel.setAddress(null);
        this.addressProgBeanModel.getExecutedProgCommands().clear();
        List progCommands = this.addressProgBeanModel.getProgCommands();
        progCommands.clear();
        PtAddressModeCommand readLongCommmand = new PtAddressModeCommand(PtOperation.RD_BIT, 29, CvUtils.preparePtBitCvValue((boolean)false, (int)5, (int)1));
        progCommands.add(readLongCommmand);
        LinkedList<PtAddressValueCommand> progCommandsSuccess = new LinkedList<PtAddressValueCommand>();
        progCommandsSuccess.add(new PtAddressValueCommand(PtOperation.RD_BYTE, 17, (int)ByteUtils.getLowByte((int)0), PtAddressValueCommand.ValueType.low));
        progCommandsSuccess.add(new PtAddressValueCommand(PtOperation.RD_BYTE, 18, (int)ByteUtils.getHighByte((int)0), PtAddressValueCommand.ValueType.high));
        readLongCommmand.setProgCommandsSuccess(progCommandsSuccess);
        LinkedList<PtAddressModeCommand> progCommandsFailure = new LinkedList<PtAddressModeCommand>();
        PtAddressModeCommand readShortCommmand = new PtAddressModeCommand(PtOperation.RD_BIT, 29, CvUtils.preparePtBitCvValue((boolean)false, (int)5, (int)0));
        progCommandsFailure.add(readShortCommmand);
        readShortCommmand.addProgCommandSuccess((PtOperationCommand)new PtAddressValueCommand(PtOperation.RD_BYTE, 1, (int)ByteUtils.getLowByte((int)0), PtAddressValueCommand.ValueType.low));
        readLongCommmand.setProgCommandsFailure(progCommandsFailure);
        this.ptResultProxyModel.setCommandStationProgState(null);
        this.fireNextCommand();
    }

    protected Object getCurrentOperation() {
        return this.addressProgBeanModel.getCurrentOperation();
    }
}

