/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view;

import com.jidesoft.grid.HierarchicalPanel;
import com.jidesoft.grid.HierarchicalTable;
import com.jidesoft.grid.HierarchicalTableComponentFactory;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.table.TableModel;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.exception.VetoChangeException;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.model.stepcontrol.TurnTableType;
import org.bidib.wizard.mvc.common.view.table.CustomCheckBox;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlModel;
import org.bidib.wizard.mvc.stepcontrol.view.AspectCallbackListener;
import org.bidib.wizard.mvc.stepcontrol.view.AspectEditorPanel;
import org.bidib.wizard.mvc.stepcontrol.view.AspectTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AspectTable
extends HierarchicalTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AspectTable.class);
    private static final long serialVersionUID = 1L;
    private final AspectTableModel aspectTableModel;
    private final String emptyTableText;
    private final ImageIcon selectedIcon;
    private final ImageIcon unselectedIcon;
    private final ImageIcon selectedRolloverIcon;
    private final ImageIcon unselectedRolloverIcon;
    private final AspectCallbackListener<StepControlAspect> callbackListener;

    public AspectTable(AspectTableModel tableModel, String emptyTableText, ImageIcon selectedIcon, ImageIcon unselectedIcon, AspectCallbackListener<StepControlAspect> callbackListener) {
        super((TableModel)tableModel);
        this.aspectTableModel = tableModel;
        this.emptyTableText = emptyTableText;
        this.callbackListener = callbackListener;
        this.selectedIcon = selectedIcon;
        this.unselectedIcon = unselectedIcon;
        this.selectedRolloverIcon = AspectTable.addBorderToIcon((ImageIcon)selectedIcon);
        this.unselectedRolloverIcon = AspectTable.addBorderToIcon((ImageIcon)unselectedIcon);
    }

    public TableModel getStyleModel() {
        return this.aspectTableModel;
    }

    public void turnTableTypeChanged(TurnTableType turnTableType) {
        LOGGER.info("The turntable type has changed: {}", (Object)turnTableType);
        this.collapseAllRows();
        this.clearSelection();
    }

    public String getEmptyTableText() {
        return this.emptyTableText;
    }

    private static ImageIcon addBorderToIcon(ImageIcon selectedIcon) {
        ImageIcon borderIcon = ImageUtils.createImageIcon(CustomCheckBox.class, (String)"/icons/stepcontrol/border.png");
        BufferedImage bufImgBorder = ImageUtils.toBufferedImage((Image)borderIcon.getImage());
        BufferedImage bufImgSelected = ImageUtils.toBufferedImage((Image)selectedIcon.getImage());
        BufferedImage combinedImageSelected = new BufferedImage(bufImgBorder.getWidth(), bufImgBorder.getHeight(), 2);
        Graphics2D g = combinedImageSelected.createGraphics();
        g.drawImage((Image)bufImgBorder, 0, 0, null);
        g.drawImage((Image)bufImgSelected, 0, 0, null);
        g.dispose();
        ImageIcon selectedRolloverIcon = new ImageIcon(combinedImageSelected);
        return selectedRolloverIcon;
    }

    public AspectEditorPanel createAspectEditorPanel(AspectCallbackListener<StepControlAspect> aspectCallbackListener, StepControlAspect aspect, StepControlModel stepControlModel, AspectEditorPanel.EditorType editorType) {
        AspectEditorPanel aspectEditorPanel = new AspectEditorPanel(aspectCallbackListener, aspect, this.selectedIcon, this.unselectedIcon, this.selectedRolloverIcon, this.unselectedRolloverIcon, stepControlModel, editorType);
        return aspectEditorPanel;
    }

    public void createComponentFactory(StepControlModel stepControlModel) {
        this.setComponentFactory((HierarchicalTableComponentFactory)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        int selectedRow = this.getSelectedRow();
        LOGGER.info("changeSelection, selectedRow: {}, rowIndex: {}, columnIndex: {}, toggle: {}, extend: {}", new Object[]{selectedRow, rowIndex, columnIndex, toggle, extend});
        boolean editModeIsActive = this.isAnyExpanded();
        if (editModeIsActive && selectedRow != rowIndex && !this.checkAspectEditorIsDirty(selectedRow)) {
            LOGGER.info("Check if aspect editor is dirty failed. Do not change selection.");
            return;
        }
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
    }

    public boolean checkAspectEditorIsDirty(int selectedRow) {
        Component comp;
        int actualRow = this.getSortableTableModel().getActualRowAt(selectedRow);
        Component childComponent = this.getChildComponentAt(actualRow);
        LOGGER.info("The selected row has been changed. Current childComponent: {}", (Object)childComponent);
        boolean isDirty = false;
        AspectEditorPanel aspectEditorPanel = null;
        if (childComponent instanceof HierarchicalPanel && (comp = ((HierarchicalPanel)childComponent).getComponent(0)) instanceof AspectEditorPanel) {
            aspectEditorPanel = (AspectEditorPanel)comp;
            isDirty = aspectEditorPanel.isDirty();
        }
        if (isDirty) {
            String okButtonText = Resources.getString(AspectTable.class, (String)"save");
            String discardButtonText = Resources.getString(AspectTable.class, (String)"discard");
            String cancelButtonText = UIManager.getString("OptionPane.cancelButtonText");
            Object[] options = new Object[]{okButtonText, discardButtonText, cancelButtonText};
            int n = JOptionPane.showOptionDialog((Component)this, Resources.getString(AspectTable.class, (String)"save_changes.message"), Resources.getString(AspectTable.class, (String)"save_changes.title"), 1, 2, null, options, options[0]);
            try {
                if (n == 0) {
                    aspectEditorPanel.applyChanges();
                }
                if (n == 1) {
                    this.callbackListener.discardChanges(() -> ((AspectEditorPanel)aspectEditorPanel).flushBuffer());
                    aspectEditorPanel.cleanup();
                }
                return false;
            }
            catch (VetoChangeException ex) {
                LOGGER.warn("Save changes was vetoed. Do not change the selection.");
                return false;
            }
            catch (Exception ex) {
                LOGGER.warn("Save changes failed.", (Throwable)ex);
                return false;
            }
        } else if (aspectEditorPanel != null) {
            aspectEditorPanel.cleanup();
        }
        return true;
    }

    public void scrollToTop() {
        if (this.getParent() instanceof JViewport) {
            JViewport scrollPane = (JViewport)this.getParent();
            scrollPane.setViewPosition(new Point(0, 0));
        }
    }

    public void collapseRow(int param1) {
    }

    public void collapseAllRows() {
    }
}

