/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.tips.controller;

import com.jidesoft.tipoftheday.TipOfTheDaySource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTipOfTheDaySource
implements TipOfTheDaySource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTipOfTheDaySource.class);
    private Map<Integer, String> tips = new HashMap();
    private int maxTipIndex;
    private int currentTipIndex;

    public FileTipOfTheDaySource(InputStream input) throws IOException {
        Properties props = new Properties();
        props.load(input);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            try {
                Integer key = Integer.valueOf(entry.getKey().toString());
                String value = entry.getValue().toString();
                this.tips.put(key, value);
            }
            catch (Exception ex) {
                LOGGER.warn("Parse tip failed: {}", entry);
            }
        }
        Integer maxIndex = (Integer)this.tips.keySet().stream().max((entry1, entry2) -> entry1 > entry2 ? 1 : -1).get();
        this.maxTipIndex = maxIndex;
        LOGGER.info("Prepared maxTipIndex: {}", (Object)this.maxTipIndex);
    }

    public int getCurrentTipIndex() {
        return this.currentTipIndex;
    }

    public void setCurrentTipIndex(int currentTipIndex) {
        this.currentTipIndex = currentTipIndex;
    }

    public String getNextTip() {
        int prevIndex = this.currentTipIndex;
        do {
            String rawTip;
            ++this.currentTipIndex;
            if (this.currentTipIndex > this.maxTipIndex) {
                this.currentTipIndex = 0;
            }
            if ((rawTip = this.getTip(this.currentTipIndex)) == null) continue;
            return "<html><body>" + rawTip + "</body></html>";
        } while (this.currentTipIndex != prevIndex);
        return null;
    }

    private String getTip(int index) {
        String rawTip = (String)this.tips.get(index);
        return rawTip;
    }

    public String getPreviousTip() {
        int prevIndex = this.currentTipIndex;
        do {
            String rawTip;
            --this.currentTipIndex;
            if (this.currentTipIndex < 0) {
                this.currentTipIndex = this.maxTipIndex;
            }
            if ((rawTip = this.getTip(this.currentTipIndex)) == null) continue;
            return "<html><body>" + rawTip + "</body></html>";
        } while (this.currentTipIndex != prevIndex);
        return null;
    }
}

