/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.startup;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.utils.Lm;
import com.vlsolutions.swing.docking.DockableContainerFactory;
import com.vlsolutions.swing.docking.ui.DockingUISettings;
import java.awt.Color;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.wizard.client.common.boot.SwingApplicationRunner;
import org.bidib.wizard.client.common.nodetree.NodeComparator;
import org.bidib.wizard.client.common.view.BidibDefaultDockableContainerFactory;
import org.bidib.wizard.common.model.settings.ExperimentalSettingsInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.model.settings.types.LookAndFeel;
import org.bidib.wizard.common.node.Node;
import org.bidib.wizard.startup.LookAndFeelConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class LookAndFeelConfigurer
implements SwingApplicationRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(LookAndFeelConfigurer.class);
    @Autowired
    private ExperimentalSettingsInterface experimentalSettings;
    @Autowired
    private WizardSettingsInterface wizardSettings;

    public void run(ApplicationArguments args) {
        LookAndFeel lookAndFeel;
        block33: {
            LOGGER.info("The LookAndFeelConfigurer is executed. Current experimentalSettings: {}", (Object)this.experimentalSettings);
            String language = this.wizardSettings.getLanguage();
            Locale.setDefault(new Locale(language));
            LOGGER.info("Start verify JIDE license.");
            Lm.verifyLicense((String)"Andreas Kuhtz", (String)"BiDiB-Wizard", (String)"T1xTEztBM2Obp3w39SfBqkRoQBicczu");
            LOGGER.info("Verified JIDE license.");
            ObjectConverterManager.initDefaultConverter();
            CellEditorManager.initDefaultEditor();
            CellRendererManager.initDefaultRenderer();
            LookAndFeelFactory.installJideExtension((int)0);
            NodeComparator nodeComparator = new NodeComparator();
            ObjectComparatorManager.registerComparator(Node.class, (Comparator)nodeComparator);
            lookAndFeel = this.experimentalSettings.getLookAndFeel();
            LOGGER.info("Configured lookAndFeel: {}", (Object)lookAndFeel);
            try {
                if (SystemUtils.IS_OS_MAC_OSX) {
                    try {
                        switch (1.$SwitchMap$org$bidib$wizard$common$model$settings$types$LookAndFeel[lookAndFeel.ordinal()]) {
                            case 1: {
                                FlatLaf.registerCustomDefaultsSource((String)"org.bidib.wizard.themes");
                                FlatMacLightLaf.setup();
                                break;
                            }
                            case 2: {
                                FlatLaf.registerCustomDefaultsSource((String)"org.bidib.wizard.themes");
                                FlatMacDarkLaf.setup();
                                break;
                            }
                            default: {
                                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                                break;
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Set cross platform L&F on MacOSX failed.", (Throwable)ex);
                        try {
                            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                        }
                        catch (Exception ex1) {
                            LOGGER.warn("Set cross platform L&F on MacOSX failed.", (Throwable)ex1);
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        }
                    }
                    ColorUIResource tableSelectionBackground = (ColorUIResource)UIManager.get("Table.selectionBackground");
                    tableSelectionBackground = new ColorUIResource(tableSelectionBackground.darker());
                    UIManager.put("Table.selectionBackground", tableSelectionBackground);
                    if (lookAndFeel != LookAndFeel.FlatDark && lookAndFeel != LookAndFeel.FlatLight) {
                        UIManager.put("Table.selectionForeground", new ColorUIResource(Color.blue));
                        UIManager.put("TabbedPane.foreground", UIManager.getColor("Label.foreground"));
                    } else {
                        LOGGER.info("Do not set the Table.selectionForeground to blue for FlatDark L&F.");
                    }
                    LOGGER.info("Tweak the Table.selectionBackground color because the slider thumb has the same color: {}", (Object)tableSelectionBackground);
                    break block33;
                }
                if (SystemUtils.IS_OS_LINUX) {
                    try {
                        switch (1.$SwitchMap$org$bidib$wizard$common$model$settings$types$LookAndFeel[lookAndFeel.ordinal()]) {
                            case 1: {
                                FlatLaf.registerCustomDefaultsSource((String)"org.bidib.wizard.themes");
                                FlatLightLaf.setup();
                                break;
                            }
                            case 2: {
                                FlatLaf.registerCustomDefaultsSource((String)"org.bidib.wizard.themes");
                                FlatDarkLaf.setup();
                                break;
                            }
                            default: {
                                LOGGER.info("Set Nimbus L&F on Linux, system L&F: {}, cross-platform L&F: {}", (Object)UIManager.getSystemLookAndFeelClassName(), (Object)UIManager.getCrossPlatformLookAndFeelClassName());
                                UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
                                break;
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Set Nimbus L&F on Linux failed. Try to set the cross platform L&F.", (Throwable)ex);
                        try {
                            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                            break block33;
                        }
                        catch (Exception ex1) {
                            LOGGER.warn("Set cross platform L&F on Linux failed.", (Throwable)ex1);
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        }
                    }
                    break block33;
                }
                try {
                    switch (1.$SwitchMap$org$bidib$wizard$common$model$settings$types$LookAndFeel[lookAndFeel.ordinal()]) {
                        case 1: {
                            FlatLightLaf.setup();
                            break;
                        }
                        case 2: {
                            FlatDarkLaf.setup();
                            break;
                        }
                        default: {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                            break;
                        }
                    }
                }
                catch (Exception ex1) {
                    LOGGER.warn("Set flat L&F on Windows failed.", (Throwable)ex1);
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                LOGGER.warn("Set the system L&F failed.", (Throwable)ex);
            }
        }
        LOGGER.info("Configure lookAndFeel has finished. Start tweak the UI settings.");
        UIManager.put("StatusBar.rightImage", "/icons/statusbar-right.png");
        if (lookAndFeel == LookAndFeel.FlatDark || lookAndFeel == LookAndFeel.FlatLight) {
            UIManager.put("TabbedPane.showTabSeparators", true);
        } else {
            UIManager.put("tableRowStripe.background", UIManager.getColor("Table.background"));
            UIManager.put("tableRowStripe.alternativeBackground", new Color(209, 224, 239));
            UIManager.put("PortLabel.disabledForeground", UIManager.getColor("Label.disabledForeground"));
            UIManager.put("Hyperlink.foreground", Color.blue.darker());
            UIManager.put("Feedback.background.free", Color.green);
            UIManager.put("Feedback.background.occupied", Color.red);
            UIManager.put("Feedback.background.invalid", Color.orange);
            UIManager.put("Feedback.background.invalid-occupied", new Color(16738056));
            UIManager.put("cvNodeNode.background", new Color(10734579));
            UIManager.put("cvNodeNode.foreground", UIManager.getColor("Label.foreground"));
            UIManager.put("cvNodeReadOnly.background", Color.LIGHT_GRAY);
            UIManager.put("cvNodeReadOnly.foreground", UIManager.getColor("Label.foreground"));
            UIManager.put("cvNodeNode.cvNodeChangedValue", new Color(16763150));
            UIManager.put("cvNodeNode.cvNodeTimeout", new Color(11327718));
            UIManager.put("Chart.background", UIManager.getColor("Label.foreground"));
            UIManager.put("Chart.current.line", new Color(255));
            UIManager.put("Chart.title.foreground", UIManager.getColor("Label.foreground"));
            UIManager.put("InfoPanel.uniqueId.formatted.foreground", new Color(255));
            UIManager.put("BidibNodeName.blue", new Color(255));
            UIManager.put("BidibNodeName.selectionBlue", new Color(0xAEAEFF));
            UIManager.put("BidibNodeName.product.foreground", UIManager.getColor("Tree.foreground"));
            UIManager.put("BidibNodeName.product.selectionForeground", UIManager.getColor("Tree.selectionForeground"));
            UIManager.put("BoosterControl.connect.icon.name", "/icons/boostercontrol/connect.png");
            UIManager.put("BoosterControl.local.icon.name", "/icons/boostercontrol/local.png");
            UIManager.put("BoosterControl.remote.icon.name", "/icons/boostercontrol/remote.png");
            UIManager.put("NodeScriptWizard.defaultGraphic.image.name", "/icons/wizard/nodeScriptWizard.png");
            UIManager.put("AdjustServoInfoPage.servoRangeGraphic.image.name", "/images/wizard/wizard-servo-range-light.png");
            UIManager.put("comparison.icon.name", "compare.png");
            UIManager.put("FirmwareUpdate.available.icon.name", "/icons/16x16/firmware-available.png");
            UIManager.put("Console.red", Color.red);
            UIManager.put("Console.green", Color.green);
            UIManager.put("Console.blue", Color.blue);
            UIManager.put("Console.black", Color.black);
            UIManager.put("Console.gray", Color.gray);
            UIManager.put("AlertPanel.background", new Color(231, 229, 224));
            UIManager.put("AlertPanel.titleColor", Color.blue);
            String sliderUI = (String)UIManager.get("SliderUI");
            UIManager.put("ServoSpeedSliderUI", sliderUI);
            UIManager.put("EmptyPanel.warn", Color.red);
        }
        try {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows 10")) {
                ColorUIResource tableSelectionBackground = (ColorUIResource)UIManager.get("Table.selectionBackground");
                tableSelectionBackground = new ColorUIResource(tableSelectionBackground.darker());
                UIManager.put("Table.selectionBackground", tableSelectionBackground);
                LOGGER.info("Tweak the Table.selectionBackground color because the slider thumb has the same color: {}", (Object)tableSelectionBackground);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Tweak table selection background failed.", (Throwable)ex);
        }
        DockableContainerFactory.setFactory((DockableContainerFactory)new BidibDefaultDockableContainerFactory());
        DockingUISettings.getInstance().installUI();
        UIManager.put("TabbedContainer.requestFocusOnTabSelection", Boolean.TRUE);
    }
}

