package org.bidib.wizard.mvc.ifnet.model;

import com.jgoodies.binding.beans.Model;

public class IFnetConfigurationModel extends Model {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTYNAME_IP_MODE = "ipMode";

    public static final String PROPERTYNAME_STATIC_ADDRESS = "staticAddress";

    public static final String PROPERTYNAME_SUBNET_MASK = "subnetMask";

    public static final String PROPERTYNAME_GATEWAY = "gateway";

    public enum IpMode {
        DHCP("dhcp", "2"), STATIC("static", "1");

        private final String key;

        private final String value;

        IpMode(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return key;
        }

        public String getValue() {
            return value;
        }
    }

    private IpMode ipMode = IpMode.DHCP;

    private String staticAddress;

    private String subnetMask;

    private String gateway;

    /**
     * @return the ipMode
     */
    public IpMode getIpMode() {
        return ipMode;
    }

    /**
     * @param ipMode
     *            the ipMode to set
     */
    public void setIpMode(IpMode ipMode) {
        IpMode oldValue = this.ipMode;
        this.ipMode = ipMode;

        firePropertyChange(PROPERTYNAME_IP_MODE, oldValue, ipMode);
    }

    /**
     * @return the staticAddress
     */
    public String getStaticAddress() {
        return staticAddress;
    }

    /**
     * @param staticAddress
     *            the staticAddress to set
     */
    public void setStaticAddress(String staticAddress) {
        String oldValue = this.staticAddress;
        this.staticAddress = staticAddress;

        firePropertyChange(PROPERTYNAME_STATIC_ADDRESS, oldValue, staticAddress);
    }

    /**
     * @return the subnetMask
     */
    public String getSubnetMask() {
        return subnetMask;
    }

    /**
     * @param subnetMask
     *            the subnetMask to set
     */
    public void setSubnetMask(String subnetMask) {
        String oldValue = this.subnetMask;
        this.subnetMask = subnetMask;

        firePropertyChange(PROPERTYNAME_SUBNET_MASK, oldValue, subnetMask);
    }

    /**
     * @return the gateway
     */
    public String getGateway() {
        return gateway;
    }

    /**
     * @param gateway
     *            the gateway to set
     */
    public void setGateway(String gateway) {
        String oldValue = this.gateway;
        this.gateway = gateway;

        firePropertyChange(PROPERTYNAME_GATEWAY, oldValue, gateway);
    }

}
